/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.message;

import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.MessageData;
import net.sf.sdedit.diagram.SequenceDiagram;
import net.sf.sdedit.drawable.Arrow;
import net.sf.sdedit.drawable.BroadcastArrow;
import net.sf.sdedit.message.Answer;
import net.sf.sdedit.message.ForwardMessage;
import net.sf.sdedit.util.Direction;

public class BroadcastMessage
extends ForwardMessage {
    private Lifeline[] otherCallees;
    public static final int FIRST = 1;
    public static final int OTHER = 2;
    public static final int LAST = 3;

    public BroadcastMessage(Lifeline caller, Lifeline callee, SequenceDiagram diagram, MessageData data) {
        super(caller, callee, diagram, data);
    }

    @Override
    public Answer getAnswerMessage() {
        return null;
    }

    public void setOtherCallees(Lifeline[] otherCallees) {
        this.otherCallees = otherCallees;
    }

    @Override
    protected void execute() {
        if (this.getData().getBroadcastType() == 1) {
            this.getDiagram().getPaintDevice().announce(this.getConfiguration().getSpaceBeforeActivation() + 3 + Arrow.getInnerHeight(this) + this.diagram.arrowSize / 2);
            this.extendLifelines(this.getConfiguration().getSpaceBeforeActivation() + 3);
        }
        BroadcastArrow arrow = this.getCaller().getPosition() < this.getCallee().getPosition() ? new BroadcastArrow(this, Direction.RIGHT, this.v()) : new BroadcastArrow(this, Direction.LEFT, this.v());
        this.setArrow(arrow);
        if (this.getData().getBroadcastType() == 3) {
            this.extendLifelines(arrow.getInnerHeight());
            for (Lifeline callee : this.otherCallees) {
                if (callee.isAlwaysActive() || !this.isActivating()) continue;
                callee.setActive(true);
            }
            if (!this.getCallee().isAlwaysActive() && this.isActivating()) {
                this.getCallee().setActive(true);
            }
        }
        this.getDiagram().getPaintDevice().append(arrow);
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }
}

