/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import processing.mode.java.pdex.SourceUtils;

public class ImportStatement {
    private static final String importKw = "import";
    private static final String staticKw = "static";
    private boolean isStarred;
    private boolean isStatic;
    private String className;
    private String packageName;

    private ImportStatement() {
    }

    public static ImportStatement wholePackage(String pckg) {
        ImportStatement is = new ImportStatement();
        is.packageName = pckg;
        is.className = "*";
        is.isStarred = true;
        return is;
    }

    public static ImportStatement singleClass(String cls) {
        ImportStatement is = new ImportStatement();
        int lastDot = cls.lastIndexOf(46);
        is.className = lastDot >= 0 ? cls.substring(lastDot + 1) : cls;
        is.packageName = lastDot >= 0 ? cls.substring(0, lastDot) : "";
        return is;
    }

    public static ImportStatement parse(String importString) {
        Matcher matcher = SourceUtils.IMPORT_REGEX_NO_KEYWORD.matcher(importString);
        if (!matcher.find()) {
            return null;
        }
        return ImportStatement.parse(matcher.toMatchResult());
    }

    public static ImportStatement parse(MatchResult match) {
        ImportStatement is = new ImportStatement();
        is.isStatic = match.group(2) != null;
        String pckg = match.group(3);
        pckg = pckg == null ? "" : pckg.replaceAll("\\s", "");
        is.packageName = pckg.endsWith(".") ? pckg.substring(0, pckg.length() - 1) : pckg;
        is.className = match.group(4);
        is.isStarred = is.className.equals("*");
        return is;
    }

    public String getFullSourceLine() {
        return "import " + (this.isStatic ? "static " : "") + this.packageName + "." + this.className + ";";
    }

    public String getFullClassName() {
        return String.valueOf(this.packageName) + "." + this.className;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean isStarredImport() {
        return this.isStarred;
    }

    public boolean isStaticImport() {
        return this.isStatic;
    }

    public boolean isSameAs(ImportStatement is) {
        return this.packageName.equals(is.packageName) && this.className.equals(is.className) && this.isStatic == is.isStatic;
    }
}

