/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import org.sejda.conversion.AdapterUtils;
import org.sejda.conversion.EnumUtils;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.exception.SejdaRuntimeException;
import org.sejda.model.pdf.headerfooter.Numbering;
import org.sejda.model.pdf.headerfooter.NumberingStyle;

public class NumberingAdapter {
    private static final int TOKENS_NUMBER = 2;
    private Numbering numbering = Numbering.NULL;

    public NumberingAdapter(String rawString) {
        try {
            this.doParseInput(rawString);
        }
        catch (SejdaRuntimeException e) {
            throw new ConversionException("Could not parse input: '" + rawString + "'. " + e.getMessage(), e);
        }
    }

    private void doParseInput(String input) {
        String[] tokens = AdapterUtils.split(input);
        if (tokens.length != 2) {
            throw new ConversionException("Format expected is: pageNumber(mandatory):numberingStyle(mandatory)'");
        }
        int pageNumber = AdapterUtils.parseInt(tokens[0], "page number");
        NumberingStyle numberingStyle = EnumUtils.valueOf(NumberingStyle.class, tokens[1], "numbering style");
        this.numbering = new Numbering(numberingStyle, pageNumber);
    }

    public Numbering getNumbering() {
        return this.numbering;
    }
}

