/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins;

import co.elastic.logstash.api.Context;
import co.elastic.logstash.api.DeadLetterQueueWriter;
import co.elastic.logstash.api.EventFactory;
import co.elastic.logstash.api.Metric;
import co.elastic.logstash.api.NamespacedMetric;
import co.elastic.logstash.api.Plugin;
import java.io.Serializable;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.ConvertedMap;
import org.logstash.Event;
import org.logstash.plugins.PluginLookup;

public class ContextImpl
implements Context {
    private DeadLetterQueueWriter dlqWriter;
    private Metric pluginsScopedMetric;

    public ContextImpl(DeadLetterQueueWriter dlqWriter, Metric metric) {
        this.dlqWriter = dlqWriter;
        this.pluginsScopedMetric = metric;
    }

    @Override
    public DeadLetterQueueWriter getDlqWriter() {
        return this.dlqWriter;
    }

    @Override
    public NamespacedMetric getMetric(Plugin plugin) {
        return this.pluginsScopedMetric.namespace(PluginLookup.PluginType.getTypeByPlugin(plugin).metricNamespace(), plugin.getId());
    }

    @Override
    public Logger getLogger(Plugin plugin) {
        return LogManager.getLogger(plugin.getClass());
    }

    @Override
    public EventFactory getEventFactory() {
        return new EventFactory(){

            @Override
            public co.elastic.logstash.api.Event newEvent() {
                return new Event();
            }

            @Override
            public co.elastic.logstash.api.Event newEvent(Map<? extends Serializable, Object> data) {
                if (data instanceof ConvertedMap) {
                    return new Event((ConvertedMap)data);
                }
                return new Event(data);
            }
        };
    }
}

