/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.expression;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.List;
import org.jruby.RubyHash;
import org.logstash.common.SourceWithMetadata;
import org.logstash.config.ir.InvalidIRException;
import org.logstash.config.ir.SourceComponent;
import org.logstash.config.ir.expression.Expression;

public class ValueExpression
extends Expression {
    protected final Object value;

    public ValueExpression(SourceWithMetadata meta, Object value) throws InvalidIRException {
        super(meta);
        if (!(value == null || value instanceof Short || value instanceof Long || value instanceof Integer || value instanceof Float || value instanceof Double || value instanceof BigDecimal || value instanceof String || value instanceof List || value instanceof RubyHash || value instanceof Instant)) {
            throw new InvalidIRException("Invalid eValue " + value + " with class " + value.getClass().getName());
        }
        this.value = value;
    }

    public Object get() {
        return this.value;
    }

    @Override
    public boolean sourceComponentEquals(SourceComponent sourceComponent) {
        if (sourceComponent == null) {
            return false;
        }
        if (this == sourceComponent) {
            return true;
        }
        if (sourceComponent instanceof ValueExpression) {
            ValueExpression other = (ValueExpression)sourceComponent;
            if (this.get() == null) {
                return other.get() == null;
            }
            return this.get().equals(other.get());
        }
        return false;
    }

    @Override
    public String toRubyString() {
        if (this.value == null) {
            return "null";
        }
        if (this.value instanceof String) {
            return "'" + this.get() + "'";
        }
        return this.get().toString();
    }

    @Override
    public String hashSource() {
        return this.getClass().getCanonicalName() + "|" + this.value;
    }
}

