/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.task;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskEvent;
import org.jkiss.dbeaver.model.task.DBTTaskListener;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.model.task.DBTTaskRun;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DatabaseTasksView
extends ViewPart
implements DBTTaskListener {
    public static final String VIEW_ID = "org.jkiss.dbeaver.tasks";
    public static final String CREATE_TASK_CMD_ID = "org.jkiss.dbeaver.task.create";
    public static final String EDIT_TASK_CMD_ID = "org.jkiss.dbeaver.task.edit";
    public static final String RUN_TASK_CMD_ID = "org.jkiss.dbeaver.task.run";
    public static final ArrayList<Object> EMPTY_TASK_RUN_LIST = new ArrayList();
    private TreeViewer taskViewer;
    private ViewerColumnController taskColumnController;
    private TreeViewer taskRunViewer;
    private ViewerColumnController taskRunColumnController;
    private final List<DBTTask> allTasks = new ArrayList<DBTTask>();
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
    private Color colorError;

    public void createPartControl(Composite parent) {
        ColorRegistry colorRegistry = this.getSite().getWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        this.colorError = colorRegistry.get("org.jkiss.dbeaver.txn.color.reverted.background");
        CustomSashForm sashForm = UIUtils.createPartDivider((IWorkbenchPart)this, (Composite)parent, (int)256);
        this.createTaskTree((Composite)sashForm);
        this.createTaskRunTable((Composite)sashForm);
        sashForm.setWeights(new int[]{700, 300});
        this.loadTasks();
    }

    private void createTaskTree(Composite composite) {
        FilteredTree filteredTree = new FilteredTree(composite, 65538, (PatternFilter)new NamedObjectPatternFilter(), true);
        filteredTree.setInitialText("Tasks: type a part of task name here");
        this.taskViewer = filteredTree.getViewer();
        Tree taskTree = this.taskViewer.getTree();
        taskTree.setHeaderVisible(true);
        taskTree.setLayoutData((Object)new GridData(1808));
        this.taskColumnController = new ViewerColumnController("tasks", (ColumnViewer)filteredTree.getViewer());
        this.taskColumnController.addColumn("Name", "Task name", 16384, true, true, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(DBTTask task) {
                return task.getName();
            }

            @Override
            protected DBPImage getCellImage(DBTTask task) {
                DBPImage icon = task.getType().getIcon();
                return icon != null ? icon : DBIcon.TREE_TASK;
            }

            public String getToolTipText(Object element) {
                String description = ((DBTTask)element).getDescription();
                if (CommonUtils.isEmpty((String)description)) {
                    description = ((DBTTask)element).getName();
                }
                return description;
            }
        });
        this.taskColumnController.addColumn("Created", "Task create time", 16384, true, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(DBTTask task) {
                return dateFormat.format(task.getCreateTime());
            }
        });
        this.taskColumnController.addColumn("Last Run", "Task last start time", 16384, true, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(DBTTask task) {
                DBTTaskRun lastRun = task.getLastRun();
                if (lastRun == null) {
                    return "N/A";
                }
                return dateFormat.format(lastRun.getStartTime());
            }
        });
        this.taskColumnController.addColumn("Last Duration", "Task last run duration", 16384, false, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(DBTTask task) {
                DBTTaskRun lastRun = task.getLastRun();
                if (lastRun == null) {
                    return "N/A";
                }
                return RuntimeUtils.formatExecutionTime((long)lastRun.getRunDuration());
            }
        });
        this.taskColumnController.addColumn("Last Result", "Task last result", 16384, true, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(DBTTask task) {
                DBTTaskRun lastRun = task.getLastRun();
                if (lastRun == null) {
                    return "N/A";
                }
                if (lastRun.isRunSuccess()) {
                    return "Success";
                }
                return CommonUtils.notEmpty((String)lastRun.getErrorMessage());
            }
        });
        this.taskColumnController.addColumn("Description", "Task description", 16384, false, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(DBTTask task) {
                return CommonUtils.notEmpty((String)task.getDescription());
            }
        });
        this.taskColumnController.addColumn("Type", "Task type", 16384, true, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(DBTTask task) {
                return task.getType().getName();
            }
        });
        this.taskColumnController.addColumn("Category", "Task category", 16384, false, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(DBTTask task) {
                return task.getType().getCategory().getName();
            }
        });
        this.taskColumnController.addColumn("Project", "Task container project", 16384, true, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(DBTTask task) {
                return task.getProject().getName();
            }
        });
        this.taskColumnController.createColumns(true);
        this.taskViewer.setContentProvider((IContentProvider)new TreeListContentProvider());
        MenuManager menuMgr = this.createTaskContextMenu(this.taskViewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.taskViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)filteredTree.getViewer());
        this.taskViewer.addDoubleClickListener(event -> ActionUtils.runCommand((String)EDIT_TASK_CMD_ID, (ISelection)this.getSite().getSelectionProvider().getSelection(), (IServiceLocator)this.getSite()));
        this.taskViewer.addSelectionChangedListener(event -> this.loadTaskRuns());
    }

    private void createTaskRunTable(Composite parent) {
        FilteredTree filteredTree = new FilteredTree(parent, 65540, (PatternFilter)new NamedObjectPatternFilter(), true);
        filteredTree.setInitialText("Task executions: type a part of error message");
        this.taskRunViewer = filteredTree.getViewer();
        Tree taskrunTree = this.taskRunViewer.getTree();
        taskrunTree.setHeaderVisible(true);
        taskrunTree.setLayoutData((Object)new GridData(1808));
        this.taskRunColumnController = new ViewerColumnController("taskruns", (ColumnViewer)this.taskRunViewer);
        this.taskRunColumnController.addColumn("Time", "Task start time", 16384, true, true, (CellLabelProvider)new TaskRunLabelProvider(this){

            @Override
            protected void update(ViewerCell cell, DBTTaskRun taskRun) {
                cell.setText(dateFormat.format(taskRun.getStartTime()));
            }
        });
        this.taskRunColumnController.addColumn("Duration", "Task last run duration", 16384, true, false, (CellLabelProvider)new TaskRunLabelProvider(this){

            @Override
            protected void update(ViewerCell cell, DBTTaskRun taskRun) {
                cell.setText(RuntimeUtils.formatExecutionTime((long)taskRun.getRunDuration()));
            }
        });
        this.taskRunColumnController.addColumn("Result", "Task result", 16384, true, false, (CellLabelProvider)new TaskRunLabelProvider(this){

            @Override
            protected void update(ViewerCell cell, DBTTaskRun taskRun) {
                if (taskRun.isRunSuccess()) {
                    cell.setText("Success");
                } else {
                    cell.setText(CommonUtils.notEmpty((String)taskRun.getErrorMessage()));
                }
            }
        });
        this.taskRunColumnController.setForceAutoSize(true);
        this.taskRunColumnController.createColumns(true);
        this.taskRunViewer.setContentProvider((IContentProvider)new TreeListContentProvider());
        MenuManager menuMgr = this.createTaskRunContextMenu(this.taskRunViewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.taskRunViewer);
        this.taskRunViewer.addDoubleClickListener(event -> new ViewRunLogAction().run());
    }

    private MenuManager createTaskContextMenu(TreeViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> {
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)RUN_TASK_CMD_ID));
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)EDIT_TASK_CMD_ID));
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)CREATE_TASK_CMD_ID));
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.eclipse.ui.edit.delete", (String)"Delete task", null));
            manager.add((IContributionItem)new Separator("additions"));
            manager.add((IContributionItem)new Separator());
            this.taskColumnController.fillConfigMenu((IContributionManager)manager);
        });
        Control control = viewer.getControl();
        control.setMenu(menuMgr.createContextMenu(control));
        return menuMgr;
    }

    private MenuManager createTaskRunContextMenu(TreeViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> {
            DBTTask task = this.getSelectedTask();
            DBTTaskRun taskRun = this.getSelectedTaskRun();
            if (task != null && taskRun != null) {
                manager.add((IAction)new ViewRunLogAction());
            }
            manager.add((IContributionItem)new Separator("additions"));
            manager.add((IContributionItem)new Separator());
            this.taskRunColumnController.fillConfigMenu((IContributionManager)manager);
        });
        Control control = viewer.getControl();
        control.setMenu(menuMgr.createContextMenu(control));
        return menuMgr;
    }

    @Nullable
    private DBTTask getSelectedTask() {
        ISelection selection = this.taskViewer.getSelection();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        return element instanceof DBTTask ? (DBTTask)element : null;
    }

    @Nullable
    private DBTTaskRun getSelectedTaskRun() {
        ISelection selection = this.taskRunViewer.getSelection();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        return element instanceof DBTTaskRun ? (DBTTaskRun)element : null;
    }

    public void setFocus() {
        this.taskViewer.getControl().setFocus();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return adapter.cast(new WorkbenchAdapter(){

                public String getLabel(Object o) {
                    return "Database Tasks";
                }
            });
        }
        return (T)super.getAdapter(adapter);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        TaskRegistry.getInstance().addTaskListener((DBTTaskListener)this);
    }

    public void dispose() {
        TaskRegistry.getInstance().removeTaskListener((DBTTaskListener)this);
        super.dispose();
    }

    public void handleTaskEvent(DBTTaskEvent event) {
        UIUtils.asyncExec(() -> {
            DBTTask task = event.getTask();
            switch (event.getAction()) {
                case TASK_ADD: {
                    this.allTasks.add(task);
                    this.taskViewer.add(this.taskViewer.getInput(), (Object)task);
                    break;
                }
                case TASK_REMOVE: {
                    this.allTasks.remove(task);
                    this.taskViewer.remove((Object)task);
                    break;
                }
                case TASK_UPDATE: {
                    this.taskViewer.refresh((Object)task);
                    if (task != this.getSelectedTask()) break;
                    this.loadTaskRuns();
                }
            }
        });
    }

    private void loadTasks() {
        this.allTasks.clear();
        ArrayList<DBPProject> projectsWithTasks = new ArrayList<DBPProject>();
        for (DBPProject project : DBWorkbench.getPlatform().getWorkspace().getProjects()) {
            DBTTaskManager taskManager = project.getTaskManager();
            DBTTask[] tasks = taskManager.getTaskConfigurations();
            if (tasks.length == 0) continue;
            projectsWithTasks.add(project);
            Collections.addAll(this.allTasks, tasks);
        }
        this.allTasks.sort(Comparator.comparing(DBTTask::getCreateTime));
        this.taskViewer.setInput(this.allTasks);
        this.taskColumnController.repackColumns();
    }

    private void loadTaskRuns() {
        DBTTask selectedTask = this.getSelectedTask();
        if (selectedTask == null) {
            this.taskRunViewer.setInput(EMPTY_TASK_RUN_LIST);
        } else {
            Object[] runs = selectedTask.getRunStatistics();
            if (ArrayUtils.isEmpty((Object[])runs)) {
                this.taskRunViewer.setInput(EMPTY_TASK_RUN_LIST);
            } else {
                Arrays.sort(runs, Comparator.comparing(DBTTaskRun::getStartTime).reversed());
                this.taskRunViewer.setInput(Arrays.asList(runs));
            }
        }
    }

    public class NamedObjectPatternFilter
    extends PatternFilter {
        NamedObjectPatternFilter() {
            this.setIncludeLeadingWildcard(true);
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            if (element instanceof DBTTask) {
                return this.wordMatches(((DBTTask)element).getName());
            }
            if (element instanceof DBTTaskRun) {
                return this.wordMatches(element.toString());
            }
            return true;
        }
    }

    private abstract class TaskLabelProvider
    extends ColumnLabelProvider {
        private TaskLabelProvider() {
        }

        public final void update(ViewerCell cell) {
            DBTTask task = (DBTTask)cell.getElement();
            DBTTaskRun lastRun = task.getLastRun();
            if (lastRun != null && !lastRun.isRunSuccess()) {
                cell.setBackground(DatabaseTasksView.this.colorError);
            } else {
                cell.setBackground(null);
            }
            cell.setText(this.getCellText(task));
            DBPImage cellImage = this.getCellImage(task);
            if (cellImage != null) {
                cell.setImage(DBeaverIcons.getImage((DBPImage)cellImage));
            }
        }

        protected DBPImage getCellImage(DBTTask task) {
            return null;
        }

        protected abstract String getCellText(DBTTask var1);

        public String getText(Object element) {
            return this.getCellText((DBTTask)element);
        }
    }

    private abstract class TaskRunLabelProvider
    extends ColumnLabelProvider {
        private TaskRunLabelProvider() {
        }

        public final void update(ViewerCell cell) {
            DBTTaskRun taskRun = (DBTTaskRun)cell.getElement();
            if (taskRun != null && !taskRun.isRunSuccess()) {
                cell.setBackground(DatabaseTasksView.this.colorError);
            } else {
                cell.setBackground(null);
            }
            this.update(cell, taskRun);
        }

        protected abstract void update(ViewerCell var1, DBTTaskRun var2);
    }

    private static class TreeListContentProvider
    implements ITreeContentProvider {
        private TreeListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class ViewRunLogAction
    extends Action {
        ViewRunLogAction() {
            super("View log");
        }

        public void run() {
            DBTTask task = DatabaseTasksView.this.getSelectedTask();
            DBTTaskRun taskRun = DatabaseTasksView.this.getSelectedTaskRun();
            if (task != null && taskRun != null) {
                File runLog = task.getRunLog(taskRun);
                if (runLog.exists()) {
                    try {
                        EditorUtils.openExternalFileEditor((File)runLog, (IWorkbenchWindow)DatabaseTasksView.this.getSite().getWorkbenchWindow());
                    }
                    catch (Exception e) {
                        DBWorkbench.getPlatformUI().showError("Open log error", "Error while opening task execution log", (Throwable)e);
                    }
                } else {
                    UIUtils.showMessageBox((Shell)DatabaseTasksView.this.getSite().getShell(), (String)"Lof file not found", (String)("Can't find log file '" + runLog.getAbsolutePath() + "'"), (int)1);
                }
            }
        }
    }
}

