import { Injectable, NgModule } from '@angular/core';
import { BlockUIService, BLOCKUI_DEFAULT, BlockUIModule } from 'ng-block-ui';

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
class BlockUIPreventNavigation {
    /**
     * @param {?} blockUIService
     */
    constructor(blockUIService) {
        this.blockUIService = blockUIService;
    }
    /**
     * @return {?}
     */
    canActivate() {
        return !this.blockUIService.isActive(BLOCKUI_DEFAULT);
    }
    /**
     * @return {?}
     */
    canActivateChild() {
        return !this.blockUIService.isActive(BLOCKUI_DEFAULT);
    }
}
BlockUIPreventNavigation.decorators = [
    { type: Injectable },
];
/** @nocollapse */
BlockUIPreventNavigation.ctorParameters = () => [
    { type: BlockUIService }
];

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
class BlockUIRouterModule {
    /**
     * @return {?}
     */
    static forRoot() {
        return {
            ngModule: BlockUIRouterModule,
            providers: [
                BlockUIPreventNavigation
            ]
        };
    }
}
BlockUIRouterModule.decorators = [
    { type: NgModule, args: [{
                imports: [
                    BlockUIModule
                ]
            },] },
];

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

export { BlockUIRouterModule, BlockUIPreventNavigation };

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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