/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Injectable } from '@angular/core';
import { finalize } from 'rxjs/operators';
import { BlockUIService, BLOCKUI_DEFAULT } from 'ng-block-ui';
import { BlockUIHttpSettings } from './block-ui-http-settings.service';
var BlockUIInterceptor = /** @class */ (function () {
    function BlockUIInterceptor(blockUIService, blockUIHttpSettings) {
        this.blockUIService = blockUIService;
        this.blockUIHttpSettings = blockUIHttpSettings;
        this.activeHttpRequests = 0;
    }
    /**
     * @param {?} request
     * @param {?} next
     * @return {?}
     */
    BlockUIInterceptor.prototype.intercept = /**
     * @param {?} request
     * @param {?} next
     * @return {?}
     */
    function (request, next) {
        var _this = this;
        var /** @type {?} */ active = false;
        if (this.shouldBlock(request)) {
            active = true;
            this.activeHttpRequests++;
            this.blockUIService.start(BLOCKUI_DEFAULT);
        }
        return next.handle(request)
            .pipe(finalize(function () {
            if (_this.shouldBlock(request)) {
                _this.activeHttpRequests--;
                var /** @type {?} */ stopBlockUI = false;
                if (!!_this.blockUIHttpSettings.settings.blockAllRequestsInProgress && _this.activeHttpRequests <= 0) {
                    _this.activeHttpRequests = 0;
                    stopBlockUI = true;
                }
                else if (active) {
                    stopBlockUI = true;
                }
                if (stopBlockUI) {
                    _this.blockUIService.stop(BLOCKUI_DEFAULT);
                }
            }
        }));
    };
    /**
     * @param {?} request
     * @return {?}
     */
    BlockUIInterceptor.prototype.shouldBlock = /**
     * @param {?} request
     * @return {?}
     */
    function (request) {
        var method = request.method, urlWithParams = request.urlWithParams;
        var /** @type {?} */ settings = this.blockUIHttpSettings.settings;
        var /** @type {?} */ requestFilters = settings.requestFilters || [];
        return !requestFilters.some(function (f) {
            if (f && f.method && f.url) {
                return f.method.toUpperCase() === method && f.url.test(urlWithParams);
            }
            else if (typeof f === 'function') {
                return f(request);
            }
            return f.test(urlWithParams);
        });
    };
    BlockUIInterceptor.decorators = [
        { type: Injectable },
    ];
    /** @nocollapse */
    BlockUIInterceptor.ctorParameters = function () { return [
        { type: BlockUIService },
        { type: BlockUIHttpSettings }
    ]; };
    return BlockUIInterceptor;
}());
export { BlockUIInterceptor };
function BlockUIInterceptor_tsickle_Closure_declarations() {
    /** @type {?} */
    BlockUIInterceptor.prototype.activeHttpRequests;
    /** @type {?} */
    BlockUIInterceptor.prototype.blockUIService;
    /** @type {?} */
    BlockUIInterceptor.prototype.blockUIHttpSettings;
}

//# sourceMappingURL=data:application/json;base64,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