'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
exports.default = void 0;

function _assert() {
  const data = _interopRequireDefault(require('assert'));

  _assert = function _assert() {
    return data;
  };

  return data;
}

function _util() {
  const data = require('util');

  _util = function _util() {
    return data;
  };

  return data;
}

function _console() {
  const data = require('console');

  _console = function _console() {
    return data;
  };

  return data;
}

function _chalk() {
  const data = _interopRequireDefault(require('chalk'));

  _chalk = function _chalk() {
    return data;
  };

  return data;
}

var _clearLine = _interopRequireDefault(require('./clearLine'));

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {default: obj};
}

/**
 * Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 */

/* global stream$Writable */
class CustomConsole extends _console().Console {
  constructor(stdout, stderr, formatBuffer) {
    super(stdout, stderr);

    this._formatBuffer = formatBuffer || ((type, message) => message);

    this._counters = {};
    this._timers = {};
    this._groupDepth = 0;
  }

  _logToParentConsole(message) {
    super.log(message);
  }

  _log(type, message) {
    (0, _clearLine.default)(this._stdout);

    this._logToParentConsole(
      this._formatBuffer(type, '  '.repeat(this._groupDepth) + message)
    );
  }

  assert(...args) {
    try {
      (0, _assert().default)(...args);
    } catch (error) {
      this._log('assert', error.toString());
    }
  }

  count(label = 'default') {
    if (!this._counters[label]) {
      this._counters[label] = 0;
    }

    this._log(
      'count',
      (0, _util().format)(`${label}: ${++this._counters[label]}`)
    );
  }

  countReset(label = 'default') {
    this._counters[label] = 0;
  }

  debug(...args) {
    this._log('debug', (0, _util().format)(...args));
  }

  dir(...args) {
    this._log('dir', (0, _util().format)(...args));
  }

  dirxml(...args) {
    this._log('dirxml', (0, _util().format)(...args));
  }

  error(...args) {
    this._log('error', (0, _util().format)(...args));
  }

  group(...args) {
    this._groupDepth++;

    if (args.length > 0) {
      this._log('group', _chalk().default.bold((0, _util().format)(...args)));
    }
  }

  groupCollapsed(...args) {
    this._groupDepth++;

    if (args.length > 0) {
      this._log(
        'groupCollapsed',
        _chalk().default.bold((0, _util().format)(...args))
      );
    }
  }

  groupEnd() {
    if (this._groupDepth > 0) {
      this._groupDepth--;
    }
  }

  info(...args) {
    this._log('info', (0, _util().format)(...args));
  }

  log(...args) {
    this._log('log', (0, _util().format)(...args));
  }

  time(label = 'default') {
    if (this._timers[label]) {
      return;
    }

    this._timers[label] = new Date();
  }

  timeEnd(label = 'default') {
    const startTime = this._timers[label];

    if (startTime) {
      const endTime = new Date();
      const time = endTime - startTime;

      this._log('time', (0, _util().format)(`${label}: ${time}ms`));

      delete this._timers[label];
    }
  }

  warn(...args) {
    this._log('warn', (0, _util().format)(...args));
  }

  getBuffer() {
    return null;
  }
}

exports.default = CustomConsole;
