"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const core_1 = require("@angular-devkit/core");
const schematics_1 = require("@angular-devkit/schematics");
const latest_versions_1 = require("../utility/latest-versions");
function default_1(options) {
    const minimalFilesRegExp = /(.editorconfig|tslint.json)\.template$/;
    return schematics_1.mergeWith(schematics_1.apply(schematics_1.url('./files'), [
        options.minimal ? schematics_1.filter(path => !minimalFilesRegExp.test(path)) : schematics_1.noop(),
        schematics_1.applyTemplates(Object.assign({ utils: core_1.strings }, options, { 'dot': '.', latestVersions: latest_versions_1.latestVersions })),
    ]));
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiLi8iLCJzb3VyY2VzIjpbInBhY2thZ2VzL3NjaGVtYXRpY3MvYW5ndWxhci93b3Jrc3BhY2UvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7Ozs7O0dBTUc7QUFDSCwrQ0FBK0M7QUFDL0MsMkRBUW9DO0FBQ3BDLGdFQUE0RDtBQUk1RCxtQkFBeUIsT0FBeUI7SUFDaEQsTUFBTSxrQkFBa0IsR0FBRyx3Q0FBd0MsQ0FBQztJQUVwRSxPQUFPLHNCQUFTLENBQUMsa0JBQUssQ0FBQyxnQkFBRyxDQUFDLFNBQVMsQ0FBQyxFQUFFO1FBQ3JDLE9BQU8sQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLG1CQUFNLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxpQkFBSSxFQUFFO1FBQ3pFLDJCQUFjLGlCQUNaLEtBQUssRUFBRSxjQUFPLElBQ1gsT0FBTyxJQUNWLEtBQUssRUFBRSxHQUFHLEVBQ1YsY0FBYyxFQUFkLGdDQUFjLElBQ2Q7S0FDSCxDQUFDLENBQUMsQ0FBQztBQUNOLENBQUM7QUFaRCw0QkFZQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0IGh0dHBzOi8vYW5ndWxhci5pby9saWNlbnNlXG4gKi9cbmltcG9ydCB7IHN0cmluZ3MgfSBmcm9tICdAYW5ndWxhci1kZXZraXQvY29yZSc7XG5pbXBvcnQge1xuICBSdWxlLFxuICBhcHBseSxcbiAgYXBwbHlUZW1wbGF0ZXMsXG4gIGZpbHRlcixcbiAgbWVyZ2VXaXRoLFxuICBub29wLFxuICB1cmwsXG59IGZyb20gJ0Bhbmd1bGFyLWRldmtpdC9zY2hlbWF0aWNzJztcbmltcG9ydCB7IGxhdGVzdFZlcnNpb25zIH0gZnJvbSAnLi4vdXRpbGl0eS9sYXRlc3QtdmVyc2lvbnMnO1xuaW1wb3J0IHsgU2NoZW1hIGFzIFdvcmtzcGFjZU9wdGlvbnMgfSBmcm9tICcuL3NjaGVtYSc7XG5cblxuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG9wdGlvbnM6IFdvcmtzcGFjZU9wdGlvbnMpOiBSdWxlIHtcbiAgY29uc3QgbWluaW1hbEZpbGVzUmVnRXhwID0gLyguZWRpdG9yY29uZmlnfHRzbGludC5qc29uKVxcLnRlbXBsYXRlJC87XG5cbiAgcmV0dXJuIG1lcmdlV2l0aChhcHBseSh1cmwoJy4vZmlsZXMnKSwgW1xuICAgIG9wdGlvbnMubWluaW1hbCA/IGZpbHRlcihwYXRoID0+ICFtaW5pbWFsRmlsZXNSZWdFeHAudGVzdChwYXRoKSkgOiBub29wKCksXG4gICAgYXBwbHlUZW1wbGF0ZXMoe1xuICAgICAgdXRpbHM6IHN0cmluZ3MsXG4gICAgICAuLi5vcHRpb25zLFxuICAgICAgJ2RvdCc6ICcuJyxcbiAgICAgIGxhdGVzdFZlcnNpb25zLFxuICAgIH0pLFxuICBdKSk7XG59XG4iXX0=