"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const options_1 = require("../node-package/options");
const options_2 = require("../repo-init/options");
const options_3 = require("../run-schematic/options");
const options_4 = require("../tslint-fix/options");
class BuiltinTaskExecutor {
}
BuiltinTaskExecutor.NodePackage = {
    name: options_1.NodePackageName,
    create: (options) => Promise.resolve().then(() => require('../node-package/executor')).then(mod => mod.default(options)),
};
BuiltinTaskExecutor.RepositoryInitializer = {
    name: options_2.RepositoryInitializerName,
    create: (options) => Promise.resolve().then(() => require('../repo-init/executor')).then(mod => mod.default(options)),
};
BuiltinTaskExecutor.RunSchematic = {
    name: options_3.RunSchematicName,
    create: () => Promise.resolve().then(() => require('../run-schematic/executor')).then(mod => mod.default()),
};
BuiltinTaskExecutor.TslintFix = {
    name: options_4.TslintFixName,
    create: () => Promise.resolve().then(() => require('../tslint-fix/executor')).then(mod => mod.default()),
};
exports.BuiltinTaskExecutor = BuiltinTaskExecutor;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiLi8iLCJzb3VyY2VzIjpbInBhY2thZ2VzL2FuZ3VsYXJfZGV2a2l0L3NjaGVtYXRpY3MvdGFza3Mvbm9kZS9pbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQVFBLHFEQUF5RjtBQUN6RixrREFHK0I7QUFDL0Isc0RBQTREO0FBQzVELG1EQUFzRDtBQUV0RCxNQUFhLG1CQUFtQjs7QUFDZCwrQkFBVyxHQUF1RDtJQUNoRixJQUFJLEVBQUUseUJBQWU7SUFDckIsTUFBTSxFQUFFLENBQUMsT0FBTyxFQUFFLEVBQUUsQ0FBQyxxQ0FBTywwQkFBMEIsR0FBRSxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDO0NBQzFGLENBQUM7QUFDYyx5Q0FBcUIsR0FDNEI7SUFDL0QsSUFBSSxFQUFFLG1DQUF5QjtJQUMvQixNQUFNLEVBQUUsQ0FBQyxPQUFPLEVBQUUsRUFBRSxDQUFDLHFDQUFPLHVCQUF1QixHQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLENBQUM7Q0FDdkYsQ0FBQztBQUNjLGdDQUFZLEdBQTRCO0lBQ3RELElBQUksRUFBRSwwQkFBZ0I7SUFDdEIsTUFBTSxFQUFFLEdBQUcsRUFBRSxDQUFDLHFDQUFPLDJCQUEyQixHQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxPQUFPLEVBQUUsQ0FBQztDQUM3RSxDQUFDO0FBQ2MsNkJBQVMsR0FBNEI7SUFDbkQsSUFBSSxFQUFFLHVCQUFhO0lBQ25CLE1BQU0sRUFBRSxHQUFHLEVBQUUsQ0FBQyxxQ0FBTyx3QkFBd0IsR0FBRSxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLENBQUMsT0FBTyxFQUFFLENBQUM7Q0FDMUUsQ0FBQztBQWpCSixrREFrQkMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgR29vZ2xlIEluYy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5pbXBvcnQgeyBUYXNrRXhlY3V0b3JGYWN0b3J5IH0gZnJvbSAnLi4vLi4vc3JjJztcbmltcG9ydCB7IE5vZGVQYWNrYWdlTmFtZSwgTm9kZVBhY2thZ2VUYXNrRmFjdG9yeU9wdGlvbnMgfSBmcm9tICcuLi9ub2RlLXBhY2thZ2Uvb3B0aW9ucyc7XG5pbXBvcnQge1xuICBSZXBvc2l0b3J5SW5pdGlhbGl6ZXJOYW1lLFxuICBSZXBvc2l0b3J5SW5pdGlhbGl6ZXJUYXNrRmFjdG9yeU9wdGlvbnMsXG4gfSBmcm9tICcuLi9yZXBvLWluaXQvb3B0aW9ucyc7XG5pbXBvcnQgeyBSdW5TY2hlbWF0aWNOYW1lIH0gZnJvbSAnLi4vcnVuLXNjaGVtYXRpYy9vcHRpb25zJztcbmltcG9ydCB7IFRzbGludEZpeE5hbWUgfSBmcm9tICcuLi90c2xpbnQtZml4L29wdGlvbnMnO1xuXG5leHBvcnQgY2xhc3MgQnVpbHRpblRhc2tFeGVjdXRvciB7XG4gIHN0YXRpYyByZWFkb25seSBOb2RlUGFja2FnZTogVGFza0V4ZWN1dG9yRmFjdG9yeTxOb2RlUGFja2FnZVRhc2tGYWN0b3J5T3B0aW9ucz4gPSB7XG4gICAgbmFtZTogTm9kZVBhY2thZ2VOYW1lLFxuICAgIGNyZWF0ZTogKG9wdGlvbnMpID0+IGltcG9ydCgnLi4vbm9kZS1wYWNrYWdlL2V4ZWN1dG9yJykudGhlbihtb2QgPT4gbW9kLmRlZmF1bHQob3B0aW9ucykpLFxuICB9O1xuICBzdGF0aWMgcmVhZG9ubHkgUmVwb3NpdG9yeUluaXRpYWxpemVyOlxuICAgIFRhc2tFeGVjdXRvckZhY3Rvcnk8UmVwb3NpdG9yeUluaXRpYWxpemVyVGFza0ZhY3RvcnlPcHRpb25zPiA9IHtcbiAgICBuYW1lOiBSZXBvc2l0b3J5SW5pdGlhbGl6ZXJOYW1lLFxuICAgIGNyZWF0ZTogKG9wdGlvbnMpID0+IGltcG9ydCgnLi4vcmVwby1pbml0L2V4ZWN1dG9yJykudGhlbihtb2QgPT4gbW9kLmRlZmF1bHQob3B0aW9ucykpLFxuICB9O1xuICBzdGF0aWMgcmVhZG9ubHkgUnVuU2NoZW1hdGljOiBUYXNrRXhlY3V0b3JGYWN0b3J5PHt9PiA9IHtcbiAgICBuYW1lOiBSdW5TY2hlbWF0aWNOYW1lLFxuICAgIGNyZWF0ZTogKCkgPT4gaW1wb3J0KCcuLi9ydW4tc2NoZW1hdGljL2V4ZWN1dG9yJykudGhlbihtb2QgPT4gbW9kLmRlZmF1bHQoKSksXG4gIH07XG4gIHN0YXRpYyByZWFkb25seSBUc2xpbnRGaXg6IFRhc2tFeGVjdXRvckZhY3Rvcnk8e30+ID0ge1xuICAgIG5hbWU6IFRzbGludEZpeE5hbWUsXG4gICAgY3JlYXRlOiAoKSA9PiBpbXBvcnQoJy4uL3RzbGludC1maXgvZXhlY3V0b3InKS50aGVuKG1vZCA9PiBtb2QuZGVmYXVsdCgpKSxcbiAgfTtcbn1cbiJdfQ==