"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const node_1 = require("@angular-devkit/core/node");
// Resolve dependencies within the target project.
function resolveProjectModule(root, moduleName) {
    return node_1.resolve(moduleName, {
        basedir: root,
        checkGlobal: false,
        checkLocal: true,
    });
}
exports.resolveProjectModule = resolveProjectModule;
// Require dependencies within the target project.
function requireProjectModule(root, moduleName) {
    return require(resolveProjectModule(root, moduleName));
}
exports.requireProjectModule = requireProjectModule;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVxdWlyZS1wcm9qZWN0LW1vZHVsZS5qcyIsInNvdXJjZVJvb3QiOiIuLyIsInNvdXJjZXMiOlsicGFja2FnZXMvYW5ndWxhcl9kZXZraXQvYnVpbGRfYW5ndWxhci9zcmMvYW5ndWxhci1jbGktZmlsZXMvdXRpbGl0aWVzL3JlcXVpcmUtcHJvamVjdC1tb2R1bGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7Ozs7O0dBTUc7QUFDSCxvREFBb0Q7QUFFcEQsa0RBQWtEO0FBQ2xELFNBQWdCLG9CQUFvQixDQUFDLElBQVksRUFBRSxVQUFrQjtJQUNuRSxPQUFPLGNBQU8sQ0FDWixVQUFVLEVBQ1Y7UUFDRSxPQUFPLEVBQUUsSUFBSTtRQUNiLFdBQVcsRUFBRSxLQUFLO1FBQ2xCLFVBQVUsRUFBRSxJQUFJO0tBQ2pCLENBQ0YsQ0FBQztBQUNKLENBQUM7QUFURCxvREFTQztBQUVELGtEQUFrRDtBQUNsRCxTQUFnQixvQkFBb0IsQ0FBQyxJQUFZLEVBQUUsVUFBa0I7SUFDbkUsT0FBTyxPQUFPLENBQUMsb0JBQW9CLENBQUMsSUFBSSxFQUFFLFVBQVUsQ0FBQyxDQUFDLENBQUM7QUFDekQsQ0FBQztBQUZELG9EQUVDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBJbmMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9hbmd1bGFyLmlvL2xpY2Vuc2VcbiAqL1xuaW1wb3J0IHsgcmVzb2x2ZSB9IGZyb20gJ0Bhbmd1bGFyLWRldmtpdC9jb3JlL25vZGUnO1xuXG4vLyBSZXNvbHZlIGRlcGVuZGVuY2llcyB3aXRoaW4gdGhlIHRhcmdldCBwcm9qZWN0LlxuZXhwb3J0IGZ1bmN0aW9uIHJlc29sdmVQcm9qZWN0TW9kdWxlKHJvb3Q6IHN0cmluZywgbW9kdWxlTmFtZTogc3RyaW5nKSB7XG4gIHJldHVybiByZXNvbHZlKFxuICAgIG1vZHVsZU5hbWUsXG4gICAge1xuICAgICAgYmFzZWRpcjogcm9vdCxcbiAgICAgIGNoZWNrR2xvYmFsOiBmYWxzZSxcbiAgICAgIGNoZWNrTG9jYWw6IHRydWUsXG4gICAgfSxcbiAgKTtcbn1cblxuLy8gUmVxdWlyZSBkZXBlbmRlbmNpZXMgd2l0aGluIHRoZSB0YXJnZXQgcHJvamVjdC5cbmV4cG9ydCBmdW5jdGlvbiByZXF1aXJlUHJvamVjdE1vZHVsZShyb290OiBzdHJpbmcsIG1vZHVsZU5hbWU6IHN0cmluZykge1xuICByZXR1cm4gcmVxdWlyZShyZXNvbHZlUHJvamVjdE1vZHVsZShyb290LCBtb2R1bGVOYW1lKSk7XG59XG4iXX0=