/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inject.ElementPredicates;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

@BugPattern(name="MoreThanOneInjectableConstructor", summary="This class has more than one @Inject-annotated constructor. Please remove the @Inject annotation from all but one of them.", severity=BugPattern.SeverityLevel.ERROR, altNames={"inject-constructors", "InjectMultipleAtInjectConstructors"})
public class MoreThanOneInjectableConstructor
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final Matcher<AnnotationTree> IS_EITHER_INJECT = Matchers.anyOf((Matcher[])new Matcher[]{InjectMatchers.IS_APPLICATION_OF_GUICE_INJECT, InjectMatchers.IS_APPLICATION_OF_JAVAX_INJECT});

    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        Tree injectedMember;
        if (IS_EITHER_INJECT.matches((Tree)tree, state) && ElementPredicates.isFirstConstructorOfMultiInjectedClass(ASTHelpers.getSymbol((Tree)(injectedMember = state.getPath().getParentPath().getParentPath().getLeaf())))) {
            return this.describeMatch((Tree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class));
        }
        return Description.NO_MATCH;
    }
}

