Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

exports.activate = activate;
exports.deactivate = deactivate;
exports.consumeStatusBar = consumeStatusBar;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var _statusBarItem = require('./status-bar-item');

var _statusBarItem2 = _interopRequireDefault(_statusBarItem);

var _helpers = require('./helpers');

var _helpers2 = _interopRequireDefault(_helpers);

'use babel';

var LineEndingRegExp = /\r\n|\n/g;

// the following regular expression is executed natively via the `substring` package,
// where `\A` corresponds to the beginning of the string.
// More info: https://github.com/atom/line-ending-selector/pull/56
// eslint-disable-next-line no-useless-escape
var LFRegExp = /(\A|[^\r])\n/g;
var CRLFRegExp = /\r\n/g;

var disposables = null;
var modalPanel = null;
var lineEndingListView = null;

function activate() {
  disposables = new _atom.CompositeDisposable();

  disposables.add(atom.commands.add('atom-text-editor', {
    'line-ending-selector:show': function lineEndingSelectorShow(event) {
      if (!modalPanel) {
        lineEndingListView = new _atomSelectList2['default']({
          items: [{ name: 'LF', value: '\n' }, { name: 'CRLF', value: '\r\n' }],
          filterKeyForItem: function filterKeyForItem(lineEnding) {
            return lineEnding.name;
          },
          didConfirmSelection: function didConfirmSelection(lineEnding) {
            setLineEnding(atom.workspace.getActiveTextEditor(), lineEnding.value);
            modalPanel.hide();
          },
          didCancelSelection: function didCancelSelection() {
            modalPanel.hide();
          },
          elementForItem: function elementForItem(lineEnding) {
            var element = document.createElement('li');
            element.textContent = lineEnding.name;
            return element;
          }
        });
        modalPanel = atom.workspace.addModalPanel({
          item: lineEndingListView
        });
        disposables.add(new _atom.Disposable(function () {
          lineEndingListView.destroy();
          modalPanel.destroy();
          modalPanel = null;
        }));
      }

      lineEndingListView.reset();
      modalPanel.show();
      lineEndingListView.focus();
    },

    'line-ending-selector:convert-to-LF': function lineEndingSelectorConvertToLF(event) {
      var editorElement = event.target.closest('atom-text-editor');
      setLineEnding(editorElement.getModel(), '\n');
    },

    'line-ending-selector:convert-to-CRLF': function lineEndingSelectorConvertToCRLF(event) {
      var editorElement = event.target.closest('atom-text-editor');
      setLineEnding(editorElement.getModel(), '\r\n');
    }
  }));
}

function deactivate() {
  disposables.dispose();
}

function consumeStatusBar(statusBar) {
  var statusBarItem = new _statusBarItem2['default']();
  var currentBufferDisposable = null;
  var tooltipDisposable = null;

  var updateTile = _underscorePlus2['default'].debounce(function (buffer) {
    getLineEndings(buffer).then(function (lineEndings) {
      if (lineEndings.size === 0) {
        var defaultLineEnding = getDefaultLineEnding();
        buffer.setPreferredLineEnding(defaultLineEnding);
        lineEndings = new Set().add(defaultLineEnding);
      }
      statusBarItem.setLineEndings(lineEndings);
    });
  }, 0);

  disposables.add(atom.workspace.observeActiveTextEditor(function (editor) {
    if (currentBufferDisposable) currentBufferDisposable.dispose();

    if (editor && editor.getBuffer) {
      (function () {
        var buffer = editor.getBuffer();
        updateTile(buffer);
        currentBufferDisposable = buffer.onDidChange(function (_ref) {
          var oldText = _ref.oldText;
          var newText = _ref.newText;

          if (!statusBarItem.hasLineEnding('\n')) {
            if (newText.indexOf('\n') >= 0) {
              updateTile(buffer);
            }
          } else if (!statusBarItem.hasLineEnding('\r\n')) {
            if (newText.indexOf('\r\n') >= 0) {
              updateTile(buffer);
            }
          } else if (oldText.indexOf('\n')) {
            updateTile(buffer);
          }
        });
      })();
    } else {
      statusBarItem.setLineEndings(new Set());
      currentBufferDisposable = null;
    }

    if (tooltipDisposable) {
      disposables.remove(tooltipDisposable);
      tooltipDisposable.dispose();
    }
    tooltipDisposable = atom.tooltips.add(statusBarItem.element, {
      title: function title() {
        return 'File uses ' + statusBarItem.description() + ' line endings';
      }
    });
    disposables.add(tooltipDisposable);
  }));

  disposables.add(new _atom.Disposable(function () {
    if (currentBufferDisposable) currentBufferDisposable.dispose();
  }));

  statusBarItem.onClick(function () {
    var editor = atom.workspace.getActiveTextEditor();
    atom.commands.dispatch(atom.views.getView(editor), 'line-ending-selector:show');
  });

  var tile = statusBar.addRightTile({ item: statusBarItem, priority: 200 });
  disposables.add(new _atom.Disposable(function () {
    return tile.destroy();
  }));
}

function getDefaultLineEnding() {
  switch (atom.config.get('line-ending-selector.defaultLineEnding')) {
    case 'LF':
      return '\n';
    case 'CRLF':
      return '\r\n';
    case 'OS Default':
    default:
      return _helpers2['default'].getProcessPlatform() === 'win32' ? '\r\n' : '\n';
  }
}

function getLineEndings(buffer) {
  if (typeof buffer.find === 'function') {
    return Promise.all([buffer.find(LFRegExp), buffer.find(CRLFRegExp)]).then(function (_ref2) {
      var _ref22 = _slicedToArray(_ref2, 2);

      var hasLF = _ref22[0];
      var hasCRLF = _ref22[1];

      var result = new Set();
      if (hasLF) result.add('\n');
      if (hasCRLF) result.add('\r\n');
      return result;
    });
  } else {
    return new Promise(function (resolve) {
      var result = new Set();
      for (var i = 0; i < buffer.getLineCount() - 1; i++) {
        result.add(buffer.lineEndingForRow(i));
      }
      resolve(result);
    });
  }
}

function setLineEnding(item, lineEnding) {
  if (item && item.getBuffer) {
    var buffer = item.getBuffer();
    buffer.setPreferredLineEnding(lineEnding);
    buffer.setText(buffer.getText().replace(LineEndingRegExp, lineEnding));
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tLTEuNDEuMC9vdXQvYXBwL25vZGVfbW9kdWxlcy9saW5lLWVuZGluZy1zZWxlY3Rvci9saWIvbWFpbi5qcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7OEJBRWMsaUJBQWlCOzs7O29CQUNpQixNQUFNOzs4QkFDM0Isa0JBQWtCOzs7OzZCQUNuQixtQkFBbUI7Ozs7dUJBQ3pCLFdBQVc7Ozs7QUFOL0IsV0FBVyxDQUFDOztBQVFaLElBQU0sZ0JBQWdCLEdBQUcsVUFBVSxDQUFDOzs7Ozs7QUFNcEMsSUFBTSxRQUFRLEdBQUcsZUFBZSxDQUFDO0FBQ2pDLElBQU0sVUFBVSxHQUFHLE9BQU8sQ0FBQzs7QUFFM0IsSUFBSSxXQUFXLEdBQUcsSUFBSSxDQUFDO0FBQ3ZCLElBQUksVUFBVSxHQUFHLElBQUksQ0FBQztBQUN0QixJQUFJLGtCQUFrQixHQUFHLElBQUksQ0FBQzs7QUFFdkIsU0FBUyxRQUFRLEdBQUc7QUFDekIsYUFBVyxHQUFHLCtCQUF5QixDQUFDOztBQUV4QyxhQUFXLENBQUMsR0FBRyxDQUNiLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLGtCQUFrQixFQUFFO0FBQ3BDLCtCQUEyQixFQUFFLGdDQUFBLEtBQUssRUFBSTtBQUNwQyxVQUFJLENBQUMsVUFBVSxFQUFFO0FBQ2YsMEJBQWtCLEdBQUcsZ0NBQW1CO0FBQ3RDLGVBQUssRUFBRSxDQUNMLEVBQUUsSUFBSSxFQUFFLElBQUksRUFBRSxLQUFLLEVBQUUsSUFBSSxFQUFFLEVBQzNCLEVBQUUsSUFBSSxFQUFFLE1BQU0sRUFBRSxLQUFLLEVBQUUsTUFBTSxFQUFFLENBQ2hDO0FBQ0QsMEJBQWdCLEVBQUUsMEJBQUEsVUFBVTttQkFBSSxVQUFVLENBQUMsSUFBSTtXQUFBO0FBQy9DLDZCQUFtQixFQUFFLDZCQUFBLFVBQVUsRUFBSTtBQUNqQyx5QkFBYSxDQUNYLElBQUksQ0FBQyxTQUFTLENBQUMsbUJBQW1CLEVBQUUsRUFDcEMsVUFBVSxDQUFDLEtBQUssQ0FDakIsQ0FBQztBQUNGLHNCQUFVLENBQUMsSUFBSSxFQUFFLENBQUM7V0FDbkI7QUFDRCw0QkFBa0IsRUFBRSw4QkFBTTtBQUN4QixzQkFBVSxDQUFDLElBQUksRUFBRSxDQUFDO1dBQ25CO0FBQ0Qsd0JBQWMsRUFBRSx3QkFBQSxVQUFVLEVBQUk7QUFDNUIsZ0JBQU0sT0FBTyxHQUFHLFFBQVEsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLENBQUM7QUFDN0MsbUJBQU8sQ0FBQyxXQUFXLEdBQUcsVUFBVSxDQUFDLElBQUksQ0FBQztBQUN0QyxtQkFBTyxPQUFPLENBQUM7V0FDaEI7U0FDRixDQUFDLENBQUM7QUFDSCxrQkFBVSxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxDQUFDO0FBQ3hDLGNBQUksRUFBRSxrQkFBa0I7U0FDekIsQ0FBQyxDQUFDO0FBQ0gsbUJBQVcsQ0FBQyxHQUFHLENBQ2IscUJBQWUsWUFBTTtBQUNuQiw0QkFBa0IsQ0FBQyxPQUFPLEVBQUUsQ0FBQztBQUM3QixvQkFBVSxDQUFDLE9BQU8sRUFBRSxDQUFDO0FBQ3JCLG9CQUFVLEdBQUcsSUFBSSxDQUFDO1NBQ25CLENBQUMsQ0FDSCxDQUFDO09BQ0g7O0FBRUQsd0JBQWtCLENBQUMsS0FBSyxFQUFFLENBQUM7QUFDM0IsZ0JBQVUsQ0FBQyxJQUFJLEVBQUUsQ0FBQztBQUNsQix3QkFBa0IsQ0FBQyxLQUFLLEVBQUUsQ0FBQztLQUM1Qjs7QUFFRCx3Q0FBb0MsRUFBRSx1Q0FBQSxLQUFLLEVBQUk7QUFDN0MsVUFBTSxhQUFhLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsa0JBQWtCLENBQUMsQ0FBQztBQUMvRCxtQkFBYSxDQUFDLGFBQWEsQ0FBQyxRQUFRLEVBQUUsRUFBRSxJQUFJLENBQUMsQ0FBQztLQUMvQzs7QUFFRCwwQ0FBc0MsRUFBRSx5Q0FBQSxLQUFLLEVBQUk7QUFDL0MsVUFBTSxhQUFhLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsa0JBQWtCLENBQUMsQ0FBQztBQUMvRCxtQkFBYSxDQUFDLGFBQWEsQ0FBQyxRQUFRLEVBQUUsRUFBRSxNQUFNLENBQUMsQ0FBQztLQUNqRDtHQUNGLENBQUMsQ0FDSCxDQUFDO0NBQ0g7O0FBRU0sU0FBUyxVQUFVLEdBQUc7QUFDM0IsYUFBVyxDQUFDLE9BQU8sRUFBRSxDQUFDO0NBQ3ZCOztBQUVNLFNBQVMsZ0JBQWdCLENBQUMsU0FBUyxFQUFFO0FBQzFDLE1BQUksYUFBYSxHQUFHLGdDQUFtQixDQUFDO0FBQ3hDLE1BQUksdUJBQXVCLEdBQUcsSUFBSSxDQUFDO0FBQ25DLE1BQUksaUJBQWlCLEdBQUcsSUFBSSxDQUFDOztBQUU3QixNQUFNLFVBQVUsR0FBRyw0QkFBRSxRQUFRLENBQUMsVUFBQSxNQUFNLEVBQUk7QUFDdEMsa0JBQWMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxJQUFJLENBQUMsVUFBQSxXQUFXLEVBQUk7QUFDekMsVUFBSSxXQUFXLENBQUMsSUFBSSxLQUFLLENBQUMsRUFBRTtBQUMxQixZQUFJLGlCQUFpQixHQUFHLG9CQUFvQixFQUFFLENBQUM7QUFDL0MsY0FBTSxDQUFDLHNCQUFzQixDQUFDLGlCQUFpQixDQUFDLENBQUM7QUFDakQsbUJBQVcsR0FBRyxJQUFJLEdBQUcsRUFBRSxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO09BQ2hEO0FBQ0QsbUJBQWEsQ0FBQyxjQUFjLENBQUMsV0FBVyxDQUFDLENBQUM7S0FDM0MsQ0FBQyxDQUFDO0dBQ0osRUFBRSxDQUFDLENBQUMsQ0FBQzs7QUFFTixhQUFXLENBQUMsR0FBRyxDQUNiLElBQUksQ0FBQyxTQUFTLENBQUMsdUJBQXVCLENBQUMsVUFBQSxNQUFNLEVBQUk7QUFDL0MsUUFBSSx1QkFBdUIsRUFBRSx1QkFBdUIsQ0FBQyxPQUFPLEVBQUUsQ0FBQzs7QUFFL0QsUUFBSSxNQUFNLElBQUksTUFBTSxDQUFDLFNBQVMsRUFBRTs7QUFDOUIsWUFBSSxNQUFNLEdBQUcsTUFBTSxDQUFDLFNBQVMsRUFBRSxDQUFDO0FBQ2hDLGtCQUFVLENBQUMsTUFBTSxDQUFDLENBQUM7QUFDbkIsK0JBQXVCLEdBQUcsTUFBTSxDQUFDLFdBQVcsQ0FBQyxVQUFDLElBQW9CLEVBQUs7Y0FBdkIsT0FBTyxHQUFULElBQW9CLENBQWxCLE9BQU87Y0FBRSxPQUFPLEdBQWxCLElBQW9CLENBQVQsT0FBTzs7QUFDOUQsY0FBSSxDQUFDLGFBQWEsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLEVBQUU7QUFDdEMsZ0JBQUksT0FBTyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEVBQUU7QUFDOUIsd0JBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQzthQUNwQjtXQUNGLE1BQU0sSUFBSSxDQUFDLGFBQWEsQ0FBQyxhQUFhLENBQUMsTUFBTSxDQUFDLEVBQUU7QUFDL0MsZ0JBQUksT0FBTyxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLEVBQUU7QUFDaEMsd0JBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQzthQUNwQjtXQUNGLE1BQU0sSUFBSSxPQUFPLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxFQUFFO0FBQ2hDLHNCQUFVLENBQUMsTUFBTSxDQUFDLENBQUM7V0FDcEI7U0FDRixDQUFDLENBQUM7O0tBQ0osTUFBTTtBQUNMLG1CQUFhLENBQUMsY0FBYyxDQUFDLElBQUksR0FBRyxFQUFFLENBQUMsQ0FBQztBQUN4Qyw2QkFBdUIsR0FBRyxJQUFJLENBQUM7S0FDaEM7O0FBRUQsUUFBSSxpQkFBaUIsRUFBRTtBQUNyQixpQkFBVyxDQUFDLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0FBQ3RDLHVCQUFpQixDQUFDLE9BQU8sRUFBRSxDQUFDO0tBQzdCO0FBQ0QscUJBQWlCLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsYUFBYSxDQUFDLE9BQU8sRUFBRTtBQUMzRCxXQUFLLEVBQUEsaUJBQUc7QUFDTiw4QkFBb0IsYUFBYSxDQUFDLFdBQVcsRUFBRSxtQkFBZ0I7T0FDaEU7S0FDRixDQUFDLENBQUM7QUFDSCxlQUFXLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUM7R0FDcEMsQ0FBQyxDQUNILENBQUM7O0FBRUYsYUFBVyxDQUFDLEdBQUcsQ0FDYixxQkFBZSxZQUFNO0FBQ25CLFFBQUksdUJBQXVCLEVBQUUsdUJBQXVCLENBQUMsT0FBTyxFQUFFLENBQUM7R0FDaEUsQ0FBQyxDQUNILENBQUM7O0FBRUYsZUFBYSxDQUFDLE9BQU8sQ0FBQyxZQUFNO0FBQzFCLFFBQU0sTUFBTSxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsbUJBQW1CLEVBQUUsQ0FBQztBQUNwRCxRQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FDcEIsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLEVBQzFCLDJCQUEyQixDQUM1QixDQUFDO0dBQ0gsQ0FBQyxDQUFDOztBQUVILE1BQUksSUFBSSxHQUFHLFNBQVMsQ0FBQyxZQUFZLENBQUMsRUFBRSxJQUFJLEVBQUUsYUFBYSxFQUFFLFFBQVEsRUFBRSxHQUFHLEVBQUUsQ0FBQyxDQUFDO0FBQzFFLGFBQVcsQ0FBQyxHQUFHLENBQUMscUJBQWU7V0FBTSxJQUFJLENBQUMsT0FBTyxFQUFFO0dBQUEsQ0FBQyxDQUFDLENBQUM7Q0FDdkQ7O0FBRUQsU0FBUyxvQkFBb0IsR0FBRztBQUM5QixVQUFRLElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLHdDQUF3QyxDQUFDO0FBQy9ELFNBQUssSUFBSTtBQUNQLGFBQU8sSUFBSSxDQUFDO0FBQUEsQUFDZCxTQUFLLE1BQU07QUFDVCxhQUFPLE1BQU0sQ0FBQztBQUFBLEFBQ2hCLFNBQUssWUFBWSxDQUFDO0FBQ2xCO0FBQ0UsYUFBTyxxQkFBUSxrQkFBa0IsRUFBRSxLQUFLLE9BQU8sR0FBRyxNQUFNLEdBQUcsSUFBSSxDQUFDO0FBQUEsR0FDbkU7Q0FDRjs7QUFFRCxTQUFTLGNBQWMsQ0FBQyxNQUFNLEVBQUU7QUFDOUIsTUFBSSxPQUFPLE1BQU0sQ0FBQyxJQUFJLEtBQUssVUFBVSxFQUFFO0FBQ3JDLFdBQU8sT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLEVBQUUsTUFBTSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUN2RSxVQUFDLEtBQWdCLEVBQUs7a0NBQXJCLEtBQWdCOztVQUFmLEtBQUs7VUFBRSxPQUFPOztBQUNkLFVBQU0sTUFBTSxHQUFHLElBQUksR0FBRyxFQUFFLENBQUM7QUFDekIsVUFBSSxLQUFLLEVBQUUsTUFBTSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsQ0FBQztBQUM1QixVQUFJLE9BQU8sRUFBRSxNQUFNLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0FBQ2hDLGFBQU8sTUFBTSxDQUFDO0tBQ2YsQ0FDRixDQUFDO0dBQ0gsTUFBTTtBQUNMLFdBQU8sSUFBSSxPQUFPLENBQUMsVUFBQSxPQUFPLEVBQUk7QUFDNUIsVUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLEVBQUUsQ0FBQztBQUN6QixXQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsTUFBTSxDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRTtBQUNsRCxjQUFNLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO09BQ3hDO0FBQ0QsYUFBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0tBQ2pCLENBQUMsQ0FBQztHQUNKO0NBQ0Y7O0FBRUQsU0FBUyxhQUFhLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtBQUN2QyxNQUFJLElBQUksSUFBSSxJQUFJLENBQUMsU0FBUyxFQUFFO0FBQzFCLFFBQUksTUFBTSxHQUFHLElBQUksQ0FBQyxTQUFTLEVBQUUsQ0FBQztBQUM5QixVQUFNLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLENBQUM7QUFDMUMsVUFBTSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsT0FBTyxFQUFFLENBQUMsT0FBTyxDQUFDLGdCQUFnQixFQUFFLFVBQVUsQ0FBQyxDQUFDLENBQUM7R0FDeEU7Q0FDRiIsImZpbGUiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjQxLjAvb3V0L2FwcC9ub2RlX21vZHVsZXMvbGluZS1lbmRpbmctc2VsZWN0b3IvbGliL21haW4uanMiLCJzb3VyY2VzQ29udGVudCI6WyIndXNlIGJhYmVsJztcblxuaW1wb3J0IF8gZnJvbSAndW5kZXJzY29yZS1wbHVzJztcbmltcG9ydCB7IENvbXBvc2l0ZURpc3Bvc2FibGUsIERpc3Bvc2FibGUgfSBmcm9tICdhdG9tJztcbmltcG9ydCBTZWxlY3RMaXN0VmlldyBmcm9tICdhdG9tLXNlbGVjdC1saXN0JztcbmltcG9ydCBTdGF0dXNCYXJJdGVtIGZyb20gJy4vc3RhdHVzLWJhci1pdGVtJztcbmltcG9ydCBoZWxwZXJzIGZyb20gJy4vaGVscGVycyc7XG5cbmNvbnN0IExpbmVFbmRpbmdSZWdFeHAgPSAvXFxyXFxufFxcbi9nO1xuXG4vLyB0aGUgZm9sbG93aW5nIHJlZ3VsYXIgZXhwcmVzc2lvbiBpcyBleGVjdXRlZCBuYXRpdmVseSB2aWEgdGhlIGBzdWJzdHJpbmdgIHBhY2thZ2UsXG4vLyB3aGVyZSBgXFxBYCBjb3JyZXNwb25kcyB0byB0aGUgYmVnaW5uaW5nIG9mIHRoZSBzdHJpbmcuXG4vLyBNb3JlIGluZm86IGh0dHBzOi8vZ2l0aHViLmNvbS9hdG9tL2xpbmUtZW5kaW5nLXNlbGVjdG9yL3B1bGwvNTZcbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby11c2VsZXNzLWVzY2FwZVxuY29uc3QgTEZSZWdFeHAgPSAvKFxcQXxbXlxccl0pXFxuL2c7XG5jb25zdCBDUkxGUmVnRXhwID0gL1xcclxcbi9nO1xuXG5sZXQgZGlzcG9zYWJsZXMgPSBudWxsO1xubGV0IG1vZGFsUGFuZWwgPSBudWxsO1xubGV0IGxpbmVFbmRpbmdMaXN0VmlldyA9IG51bGw7XG5cbmV4cG9ydCBmdW5jdGlvbiBhY3RpdmF0ZSgpIHtcbiAgZGlzcG9zYWJsZXMgPSBuZXcgQ29tcG9zaXRlRGlzcG9zYWJsZSgpO1xuXG4gIGRpc3Bvc2FibGVzLmFkZChcbiAgICBhdG9tLmNvbW1hbmRzLmFkZCgnYXRvbS10ZXh0LWVkaXRvcicsIHtcbiAgICAgICdsaW5lLWVuZGluZy1zZWxlY3RvcjpzaG93JzogZXZlbnQgPT4ge1xuICAgICAgICBpZiAoIW1vZGFsUGFuZWwpIHtcbiAgICAgICAgICBsaW5lRW5kaW5nTGlzdFZpZXcgPSBuZXcgU2VsZWN0TGlzdFZpZXcoe1xuICAgICAgICAgICAgaXRlbXM6IFtcbiAgICAgICAgICAgICAgeyBuYW1lOiAnTEYnLCB2YWx1ZTogJ1xcbicgfSxcbiAgICAgICAgICAgICAgeyBuYW1lOiAnQ1JMRicsIHZhbHVlOiAnXFxyXFxuJyB9XG4gICAgICAgICAgICBdLFxuICAgICAgICAgICAgZmlsdGVyS2V5Rm9ySXRlbTogbGluZUVuZGluZyA9PiBsaW5lRW5kaW5nLm5hbWUsXG4gICAgICAgICAgICBkaWRDb25maXJtU2VsZWN0aW9uOiBsaW5lRW5kaW5nID0+IHtcbiAgICAgICAgICAgICAgc2V0TGluZUVuZGluZyhcbiAgICAgICAgICAgICAgICBhdG9tLndvcmtzcGFjZS5nZXRBY3RpdmVUZXh0RWRpdG9yKCksXG4gICAgICAgICAgICAgICAgbGluZUVuZGluZy52YWx1ZVxuICAgICAgICAgICAgICApO1xuICAgICAgICAgICAgICBtb2RhbFBhbmVsLmhpZGUoKTtcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBkaWRDYW5jZWxTZWxlY3Rpb246ICgpID0+IHtcbiAgICAgICAgICAgICAgbW9kYWxQYW5lbC5oaWRlKCk7XG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgZWxlbWVudEZvckl0ZW06IGxpbmVFbmRpbmcgPT4ge1xuICAgICAgICAgICAgICBjb25zdCBlbGVtZW50ID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnbGknKTtcbiAgICAgICAgICAgICAgZWxlbWVudC50ZXh0Q29udGVudCA9IGxpbmVFbmRpbmcubmFtZTtcbiAgICAgICAgICAgICAgcmV0dXJuIGVsZW1lbnQ7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgfSk7XG4gICAgICAgICAgbW9kYWxQYW5lbCA9IGF0b20ud29ya3NwYWNlLmFkZE1vZGFsUGFuZWwoe1xuICAgICAgICAgICAgaXRlbTogbGluZUVuZGluZ0xpc3RWaWV3XG4gICAgICAgICAgfSk7XG4gICAgICAgICAgZGlzcG9zYWJsZXMuYWRkKFxuICAgICAgICAgICAgbmV3IERpc3Bvc2FibGUoKCkgPT4ge1xuICAgICAgICAgICAgICBsaW5lRW5kaW5nTGlzdFZpZXcuZGVzdHJveSgpO1xuICAgICAgICAgICAgICBtb2RhbFBhbmVsLmRlc3Ryb3koKTtcbiAgICAgICAgICAgICAgbW9kYWxQYW5lbCA9IG51bGw7XG4gICAgICAgICAgICB9KVxuICAgICAgICAgICk7XG4gICAgICAgIH1cblxuICAgICAgICBsaW5lRW5kaW5nTGlzdFZpZXcucmVzZXQoKTtcbiAgICAgICAgbW9kYWxQYW5lbC5zaG93KCk7XG4gICAgICAgIGxpbmVFbmRpbmdMaXN0Vmlldy5mb2N1cygpO1xuICAgICAgfSxcblxuICAgICAgJ2xpbmUtZW5kaW5nLXNlbGVjdG9yOmNvbnZlcnQtdG8tTEYnOiBldmVudCA9PiB7XG4gICAgICAgIGNvbnN0IGVkaXRvckVsZW1lbnQgPSBldmVudC50YXJnZXQuY2xvc2VzdCgnYXRvbS10ZXh0LWVkaXRvcicpO1xuICAgICAgICBzZXRMaW5lRW5kaW5nKGVkaXRvckVsZW1lbnQuZ2V0TW9kZWwoKSwgJ1xcbicpO1xuICAgICAgfSxcblxuICAgICAgJ2xpbmUtZW5kaW5nLXNlbGVjdG9yOmNvbnZlcnQtdG8tQ1JMRic6IGV2ZW50ID0+IHtcbiAgICAgICAgY29uc3QgZWRpdG9yRWxlbWVudCA9IGV2ZW50LnRhcmdldC5jbG9zZXN0KCdhdG9tLXRleHQtZWRpdG9yJyk7XG4gICAgICAgIHNldExpbmVFbmRpbmcoZWRpdG9yRWxlbWVudC5nZXRNb2RlbCgpLCAnXFxyXFxuJyk7XG4gICAgICB9XG4gICAgfSlcbiAgKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGRlYWN0aXZhdGUoKSB7XG4gIGRpc3Bvc2FibGVzLmRpc3Bvc2UoKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGNvbnN1bWVTdGF0dXNCYXIoc3RhdHVzQmFyKSB7XG4gIGxldCBzdGF0dXNCYXJJdGVtID0gbmV3IFN0YXR1c0Jhckl0ZW0oKTtcbiAgbGV0IGN1cnJlbnRCdWZmZXJEaXNwb3NhYmxlID0gbnVsbDtcbiAgbGV0IHRvb2x0aXBEaXNwb3NhYmxlID0gbnVsbDtcblxuICBjb25zdCB1cGRhdGVUaWxlID0gXy5kZWJvdW5jZShidWZmZXIgPT4ge1xuICAgIGdldExpbmVFbmRpbmdzKGJ1ZmZlcikudGhlbihsaW5lRW5kaW5ncyA9PiB7XG4gICAgICBpZiAobGluZUVuZGluZ3Muc2l6ZSA9PT0gMCkge1xuICAgICAgICBsZXQgZGVmYXVsdExpbmVFbmRpbmcgPSBnZXREZWZhdWx0TGluZUVuZGluZygpO1xuICAgICAgICBidWZmZXIuc2V0UHJlZmVycmVkTGluZUVuZGluZyhkZWZhdWx0TGluZUVuZGluZyk7XG4gICAgICAgIGxpbmVFbmRpbmdzID0gbmV3IFNldCgpLmFkZChkZWZhdWx0TGluZUVuZGluZyk7XG4gICAgICB9XG4gICAgICBzdGF0dXNCYXJJdGVtLnNldExpbmVFbmRpbmdzKGxpbmVFbmRpbmdzKTtcbiAgICB9KTtcbiAgfSwgMCk7XG5cbiAgZGlzcG9zYWJsZXMuYWRkKFxuICAgIGF0b20ud29ya3NwYWNlLm9ic2VydmVBY3RpdmVUZXh0RWRpdG9yKGVkaXRvciA9PiB7XG4gICAgICBpZiAoY3VycmVudEJ1ZmZlckRpc3Bvc2FibGUpIGN1cnJlbnRCdWZmZXJEaXNwb3NhYmxlLmRpc3Bvc2UoKTtcblxuICAgICAgaWYgKGVkaXRvciAmJiBlZGl0b3IuZ2V0QnVmZmVyKSB7XG4gICAgICAgIGxldCBidWZmZXIgPSBlZGl0b3IuZ2V0QnVmZmVyKCk7XG4gICAgICAgIHVwZGF0ZVRpbGUoYnVmZmVyKTtcbiAgICAgICAgY3VycmVudEJ1ZmZlckRpc3Bvc2FibGUgPSBidWZmZXIub25EaWRDaGFuZ2UoKHsgb2xkVGV4dCwgbmV3VGV4dCB9KSA9PiB7XG4gICAgICAgICAgaWYgKCFzdGF0dXNCYXJJdGVtLmhhc0xpbmVFbmRpbmcoJ1xcbicpKSB7XG4gICAgICAgICAgICBpZiAobmV3VGV4dC5pbmRleE9mKCdcXG4nKSA+PSAwKSB7XG4gICAgICAgICAgICAgIHVwZGF0ZVRpbGUoYnVmZmVyKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9IGVsc2UgaWYgKCFzdGF0dXNCYXJJdGVtLmhhc0xpbmVFbmRpbmcoJ1xcclxcbicpKSB7XG4gICAgICAgICAgICBpZiAobmV3VGV4dC5pbmRleE9mKCdcXHJcXG4nKSA+PSAwKSB7XG4gICAgICAgICAgICAgIHVwZGF0ZVRpbGUoYnVmZmVyKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9IGVsc2UgaWYgKG9sZFRleHQuaW5kZXhPZignXFxuJykpIHtcbiAgICAgICAgICAgIHVwZGF0ZVRpbGUoYnVmZmVyKTtcbiAgICAgICAgICB9XG4gICAgICAgIH0pO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgc3RhdHVzQmFySXRlbS5zZXRMaW5lRW5kaW5ncyhuZXcgU2V0KCkpO1xuICAgICAgICBjdXJyZW50QnVmZmVyRGlzcG9zYWJsZSA9IG51bGw7XG4gICAgICB9XG5cbiAgICAgIGlmICh0b29sdGlwRGlzcG9zYWJsZSkge1xuICAgICAgICBkaXNwb3NhYmxlcy5yZW1vdmUodG9vbHRpcERpc3Bvc2FibGUpO1xuICAgICAgICB0b29sdGlwRGlzcG9zYWJsZS5kaXNwb3NlKCk7XG4gICAgICB9XG4gICAgICB0b29sdGlwRGlzcG9zYWJsZSA9IGF0b20udG9vbHRpcHMuYWRkKHN0YXR1c0Jhckl0ZW0uZWxlbWVudCwge1xuICAgICAgICB0aXRsZSgpIHtcbiAgICAgICAgICByZXR1cm4gYEZpbGUgdXNlcyAke3N0YXR1c0Jhckl0ZW0uZGVzY3JpcHRpb24oKX0gbGluZSBlbmRpbmdzYDtcbiAgICAgICAgfVxuICAgICAgfSk7XG4gICAgICBkaXNwb3NhYmxlcy5hZGQodG9vbHRpcERpc3Bvc2FibGUpO1xuICAgIH0pXG4gICk7XG5cbiAgZGlzcG9zYWJsZXMuYWRkKFxuICAgIG5ldyBEaXNwb3NhYmxlKCgpID0+IHtcbiAgICAgIGlmIChjdXJyZW50QnVmZmVyRGlzcG9zYWJsZSkgY3VycmVudEJ1ZmZlckRpc3Bvc2FibGUuZGlzcG9zZSgpO1xuICAgIH0pXG4gICk7XG5cbiAgc3RhdHVzQmFySXRlbS5vbkNsaWNrKCgpID0+IHtcbiAgICBjb25zdCBlZGl0b3IgPSBhdG9tLndvcmtzcGFjZS5nZXRBY3RpdmVUZXh0RWRpdG9yKCk7XG4gICAgYXRvbS5jb21tYW5kcy5kaXNwYXRjaChcbiAgICAgIGF0b20udmlld3MuZ2V0VmlldyhlZGl0b3IpLFxuICAgICAgJ2xpbmUtZW5kaW5nLXNlbGVjdG9yOnNob3cnXG4gICAgKTtcbiAgfSk7XG5cbiAgbGV0IHRpbGUgPSBzdGF0dXNCYXIuYWRkUmlnaHRUaWxlKHsgaXRlbTogc3RhdHVzQmFySXRlbSwgcHJpb3JpdHk6IDIwMCB9KTtcbiAgZGlzcG9zYWJsZXMuYWRkKG5ldyBEaXNwb3NhYmxlKCgpID0+IHRpbGUuZGVzdHJveSgpKSk7XG59XG5cbmZ1bmN0aW9uIGdldERlZmF1bHRMaW5lRW5kaW5nKCkge1xuICBzd2l0Y2ggKGF0b20uY29uZmlnLmdldCgnbGluZS1lbmRpbmctc2VsZWN0b3IuZGVmYXVsdExpbmVFbmRpbmcnKSkge1xuICAgIGNhc2UgJ0xGJzpcbiAgICAgIHJldHVybiAnXFxuJztcbiAgICBjYXNlICdDUkxGJzpcbiAgICAgIHJldHVybiAnXFxyXFxuJztcbiAgICBjYXNlICdPUyBEZWZhdWx0JzpcbiAgICBkZWZhdWx0OlxuICAgICAgcmV0dXJuIGhlbHBlcnMuZ2V0UHJvY2Vzc1BsYXRmb3JtKCkgPT09ICd3aW4zMicgPyAnXFxyXFxuJyA6ICdcXG4nO1xuICB9XG59XG5cbmZ1bmN0aW9uIGdldExpbmVFbmRpbmdzKGJ1ZmZlcikge1xuICBpZiAodHlwZW9mIGJ1ZmZlci5maW5kID09PSAnZnVuY3Rpb24nKSB7XG4gICAgcmV0dXJuIFByb21pc2UuYWxsKFtidWZmZXIuZmluZChMRlJlZ0V4cCksIGJ1ZmZlci5maW5kKENSTEZSZWdFeHApXSkudGhlbihcbiAgICAgIChbaGFzTEYsIGhhc0NSTEZdKSA9PiB7XG4gICAgICAgIGNvbnN0IHJlc3VsdCA9IG5ldyBTZXQoKTtcbiAgICAgICAgaWYgKGhhc0xGKSByZXN1bHQuYWRkKCdcXG4nKTtcbiAgICAgICAgaWYgKGhhc0NSTEYpIHJlc3VsdC5hZGQoJ1xcclxcbicpO1xuICAgICAgICByZXR1cm4gcmVzdWx0O1xuICAgICAgfVxuICAgICk7XG4gIH0gZWxzZSB7XG4gICAgcmV0dXJuIG5ldyBQcm9taXNlKHJlc29sdmUgPT4ge1xuICAgICAgY29uc3QgcmVzdWx0ID0gbmV3IFNldCgpO1xuICAgICAgZm9yIChsZXQgaSA9IDA7IGkgPCBidWZmZXIuZ2V0TGluZUNvdW50KCkgLSAxOyBpKyspIHtcbiAgICAgICAgcmVzdWx0LmFkZChidWZmZXIubGluZUVuZGluZ0ZvclJvdyhpKSk7XG4gICAgICB9XG4gICAgICByZXNvbHZlKHJlc3VsdCk7XG4gICAgfSk7XG4gIH1cbn1cblxuZnVuY3Rpb24gc2V0TGluZUVuZGluZyhpdGVtLCBsaW5lRW5kaW5nKSB7XG4gIGlmIChpdGVtICYmIGl0ZW0uZ2V0QnVmZmVyKSB7XG4gICAgbGV0IGJ1ZmZlciA9IGl0ZW0uZ2V0QnVmZmVyKCk7XG4gICAgYnVmZmVyLnNldFByZWZlcnJlZExpbmVFbmRpbmcobGluZUVuZGluZyk7XG4gICAgYnVmZmVyLnNldFRleHQoYnVmZmVyLmdldFRleHQoKS5yZXBsYWNlKExpbmVFbmRpbmdSZWdFeHAsIGxpbmVFbmRpbmcpKTtcbiAgfVxufVxuIl19