"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _util = _interopRequireDefault(require("util"));

var _branch = require("./branch");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// Store and index a set of Branches in a repository.
class BranchSet {
  constructor(all = []) {
    this.all = [];
    this.head = _branch.nullBranch;
    this.byUpstreamRef = new Map();
    this.byPushRef = new Map();

    for (const branch of all) {
      this.add(branch);
    }
  }

  add(branch) {
    this.all.push(branch);

    if (branch.isHead()) {
      this.head = branch;
    }

    const u = branch.getUpstream();

    if (u.isPresent() && u.isRemoteTracking()) {
      const k = `${u.getRemoteName()}\0${u.getRemoteRef()}`;
      (0, _helpers.pushAtKey)(this.byUpstreamRef, k, branch);
    }

    const p = branch.getPush();

    if (p.isPresent() && p.isRemoteTracking()) {
      const k = `${p.getRemoteName()}\0${p.getRemoteRef()}`;
      (0, _helpers.pushAtKey)(this.byPushRef, k, branch);
    }
  }

  getNames() {
    return this.all.map(branch => branch.getName());
  } // Return the HEAD branch, or `nullBranch` if HEAD is not a branch. This can happen if HEAD is unborn (the repository
  // was just initialized) or if HEAD is detached.


  getHeadBranch() {
    return this.head;
  } // Return an Array of Branches that would be updated from a given remote ref with a `git pull`. This corresponds with
  // git's notion of an _upstream_ and takes into account the current `branch.remote` setting and `remote.<name>.fetch`
  // refspec.


  getPullTargets(remoteName, remoteRefName) {
    return this.byUpstreamRef.get(`${remoteName}\0${remoteRefName}`) || [];
  } // Return an Array of Branches that will update a given remote ref on an unqualified `git push`. This accounts for
  // the current `branch.pushRemote` setting and `remote.<name>.push` refspec.


  getPushSources(remoteName, remoteRefName) {
    return this.byPushRef.get(`${remoteName}\0${remoteRefName}`) || [];
  }

  inspect(depth, options) {
    return `BranchSet {${_util["default"].inspect(this.all)}}`;
  }

}

exports["default"] = BranchSet;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImJyYW5jaC1zZXQuanMiXSwibmFtZXMiOlsiQnJhbmNoU2V0IiwiY29uc3RydWN0b3IiLCJhbGwiLCJoZWFkIiwibnVsbEJyYW5jaCIsImJ5VXBzdHJlYW1SZWYiLCJNYXAiLCJieVB1c2hSZWYiLCJicmFuY2giLCJhZGQiLCJwdXNoIiwiaXNIZWFkIiwidSIsImdldFVwc3RyZWFtIiwiaXNQcmVzZW50IiwiaXNSZW1vdGVUcmFja2luZyIsImsiLCJnZXRSZW1vdGVOYW1lIiwiZ2V0UmVtb3RlUmVmIiwicCIsImdldFB1c2giLCJnZXROYW1lcyIsIm1hcCIsImdldE5hbWUiLCJnZXRIZWFkQnJhbmNoIiwiZ2V0UHVsbFRhcmdldHMiLCJyZW1vdGVOYW1lIiwicmVtb3RlUmVmTmFtZSIsImdldCIsImdldFB1c2hTb3VyY2VzIiwiaW5zcGVjdCIsImRlcHRoIiwib3B0aW9ucyIsInV0aWwiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7QUFFQTs7QUFDQTs7OztBQUVBO0FBQ2UsTUFBTUEsU0FBTixDQUFnQjtBQUM3QkMsRUFBQUEsV0FBVyxDQUFDQyxHQUFHLEdBQUcsRUFBUCxFQUFXO0FBQ3BCLFNBQUtBLEdBQUwsR0FBVyxFQUFYO0FBQ0EsU0FBS0MsSUFBTCxHQUFZQyxrQkFBWjtBQUNBLFNBQUtDLGFBQUwsR0FBcUIsSUFBSUMsR0FBSixFQUFyQjtBQUNBLFNBQUtDLFNBQUwsR0FBaUIsSUFBSUQsR0FBSixFQUFqQjs7QUFDQSxTQUFLLE1BQU1FLE1BQVgsSUFBcUJOLEdBQXJCLEVBQTBCO0FBQ3hCLFdBQUtPLEdBQUwsQ0FBU0QsTUFBVDtBQUNEO0FBQ0Y7O0FBRURDLEVBQUFBLEdBQUcsQ0FBQ0QsTUFBRCxFQUFTO0FBQ1YsU0FBS04sR0FBTCxDQUFTUSxJQUFULENBQWNGLE1BQWQ7O0FBRUEsUUFBSUEsTUFBTSxDQUFDRyxNQUFQLEVBQUosRUFBcUI7QUFDbkIsV0FBS1IsSUFBTCxHQUFZSyxNQUFaO0FBQ0Q7O0FBRUQsVUFBTUksQ0FBQyxHQUFHSixNQUFNLENBQUNLLFdBQVAsRUFBVjs7QUFDQSxRQUFJRCxDQUFDLENBQUNFLFNBQUYsTUFBaUJGLENBQUMsQ0FBQ0csZ0JBQUYsRUFBckIsRUFBMkM7QUFDekMsWUFBTUMsQ0FBQyxHQUFJLEdBQUVKLENBQUMsQ0FBQ0ssYUFBRixFQUFrQixLQUFJTCxDQUFDLENBQUNNLFlBQUYsRUFBaUIsRUFBcEQ7QUFDQSw4QkFBVSxLQUFLYixhQUFmLEVBQThCVyxDQUE5QixFQUFpQ1IsTUFBakM7QUFDRDs7QUFFRCxVQUFNVyxDQUFDLEdBQUdYLE1BQU0sQ0FBQ1ksT0FBUCxFQUFWOztBQUNBLFFBQUlELENBQUMsQ0FBQ0wsU0FBRixNQUFpQkssQ0FBQyxDQUFDSixnQkFBRixFQUFyQixFQUEyQztBQUN6QyxZQUFNQyxDQUFDLEdBQUksR0FBRUcsQ0FBQyxDQUFDRixhQUFGLEVBQWtCLEtBQUlFLENBQUMsQ0FBQ0QsWUFBRixFQUFpQixFQUFwRDtBQUNBLDhCQUFVLEtBQUtYLFNBQWYsRUFBMEJTLENBQTFCLEVBQTZCUixNQUE3QjtBQUNEO0FBQ0Y7O0FBRURhLEVBQUFBLFFBQVEsR0FBRztBQUNULFdBQU8sS0FBS25CLEdBQUwsQ0FBU29CLEdBQVQsQ0FBYWQsTUFBTSxJQUFJQSxNQUFNLENBQUNlLE9BQVAsRUFBdkIsQ0FBUDtBQUNELEdBakM0QixDQW1DN0I7QUFDQTs7O0FBQ0FDLEVBQUFBLGFBQWEsR0FBRztBQUNkLFdBQU8sS0FBS3JCLElBQVo7QUFDRCxHQXZDNEIsQ0F5QzdCO0FBQ0E7QUFDQTs7O0FBQ0FzQixFQUFBQSxjQUFjLENBQUNDLFVBQUQsRUFBYUMsYUFBYixFQUE0QjtBQUN4QyxXQUFPLEtBQUt0QixhQUFMLENBQW1CdUIsR0FBbkIsQ0FBd0IsR0FBRUYsVUFBVyxLQUFJQyxhQUFjLEVBQXZELEtBQTZELEVBQXBFO0FBQ0QsR0E5QzRCLENBZ0Q3QjtBQUNBOzs7QUFDQUUsRUFBQUEsY0FBYyxDQUFDSCxVQUFELEVBQWFDLGFBQWIsRUFBNEI7QUFDeEMsV0FBTyxLQUFLcEIsU0FBTCxDQUFlcUIsR0FBZixDQUFvQixHQUFFRixVQUFXLEtBQUlDLGFBQWMsRUFBbkQsS0FBeUQsRUFBaEU7QUFDRDs7QUFFREcsRUFBQUEsT0FBTyxDQUFDQyxLQUFELEVBQVFDLE9BQVIsRUFBaUI7QUFDdEIsV0FBUSxjQUFhQyxpQkFBS0gsT0FBTCxDQUFhLEtBQUs1QixHQUFsQixDQUF1QixHQUE1QztBQUNEOztBQXhENEIiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS40MS4wL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB1dGlsIGZyb20gJ3V0aWwnO1xuXG5pbXBvcnQge251bGxCcmFuY2h9IGZyb20gJy4vYnJhbmNoJztcbmltcG9ydCB7cHVzaEF0S2V5fSBmcm9tICcuLi9oZWxwZXJzJztcblxuLy8gU3RvcmUgYW5kIGluZGV4IGEgc2V0IG9mIEJyYW5jaGVzIGluIGEgcmVwb3NpdG9yeS5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEJyYW5jaFNldCB7XG4gIGNvbnN0cnVjdG9yKGFsbCA9IFtdKSB7XG4gICAgdGhpcy5hbGwgPSBbXTtcbiAgICB0aGlzLmhlYWQgPSBudWxsQnJhbmNoO1xuICAgIHRoaXMuYnlVcHN0cmVhbVJlZiA9IG5ldyBNYXAoKTtcbiAgICB0aGlzLmJ5UHVzaFJlZiA9IG5ldyBNYXAoKTtcbiAgICBmb3IgKGNvbnN0IGJyYW5jaCBvZiBhbGwpIHtcbiAgICAgIHRoaXMuYWRkKGJyYW5jaCk7XG4gICAgfVxuICB9XG5cbiAgYWRkKGJyYW5jaCkge1xuICAgIHRoaXMuYWxsLnB1c2goYnJhbmNoKTtcblxuICAgIGlmIChicmFuY2guaXNIZWFkKCkpIHtcbiAgICAgIHRoaXMuaGVhZCA9IGJyYW5jaDtcbiAgICB9XG5cbiAgICBjb25zdCB1ID0gYnJhbmNoLmdldFVwc3RyZWFtKCk7XG4gICAgaWYgKHUuaXNQcmVzZW50KCkgJiYgdS5pc1JlbW90ZVRyYWNraW5nKCkpIHtcbiAgICAgIGNvbnN0IGsgPSBgJHt1LmdldFJlbW90ZU5hbWUoKX1cXDAke3UuZ2V0UmVtb3RlUmVmKCl9YDtcbiAgICAgIHB1c2hBdEtleSh0aGlzLmJ5VXBzdHJlYW1SZWYsIGssIGJyYW5jaCk7XG4gICAgfVxuXG4gICAgY29uc3QgcCA9IGJyYW5jaC5nZXRQdXNoKCk7XG4gICAgaWYgKHAuaXNQcmVzZW50KCkgJiYgcC5pc1JlbW90ZVRyYWNraW5nKCkpIHtcbiAgICAgIGNvbnN0IGsgPSBgJHtwLmdldFJlbW90ZU5hbWUoKX1cXDAke3AuZ2V0UmVtb3RlUmVmKCl9YDtcbiAgICAgIHB1c2hBdEtleSh0aGlzLmJ5UHVzaFJlZiwgaywgYnJhbmNoKTtcbiAgICB9XG4gIH1cblxuICBnZXROYW1lcygpIHtcbiAgICByZXR1cm4gdGhpcy5hbGwubWFwKGJyYW5jaCA9PiBicmFuY2guZ2V0TmFtZSgpKTtcbiAgfVxuXG4gIC8vIFJldHVybiB0aGUgSEVBRCBicmFuY2gsIG9yIGBudWxsQnJhbmNoYCBpZiBIRUFEIGlzIG5vdCBhIGJyYW5jaC4gVGhpcyBjYW4gaGFwcGVuIGlmIEhFQUQgaXMgdW5ib3JuICh0aGUgcmVwb3NpdG9yeVxuICAvLyB3YXMganVzdCBpbml0aWFsaXplZCkgb3IgaWYgSEVBRCBpcyBkZXRhY2hlZC5cbiAgZ2V0SGVhZEJyYW5jaCgpIHtcbiAgICByZXR1cm4gdGhpcy5oZWFkO1xuICB9XG5cbiAgLy8gUmV0dXJuIGFuIEFycmF5IG9mIEJyYW5jaGVzIHRoYXQgd291bGQgYmUgdXBkYXRlZCBmcm9tIGEgZ2l2ZW4gcmVtb3RlIHJlZiB3aXRoIGEgYGdpdCBwdWxsYC4gVGhpcyBjb3JyZXNwb25kcyB3aXRoXG4gIC8vIGdpdCdzIG5vdGlvbiBvZiBhbiBfdXBzdHJlYW1fIGFuZCB0YWtlcyBpbnRvIGFjY291bnQgdGhlIGN1cnJlbnQgYGJyYW5jaC5yZW1vdGVgIHNldHRpbmcgYW5kIGByZW1vdGUuPG5hbWU+LmZldGNoYFxuICAvLyByZWZzcGVjLlxuICBnZXRQdWxsVGFyZ2V0cyhyZW1vdGVOYW1lLCByZW1vdGVSZWZOYW1lKSB7XG4gICAgcmV0dXJuIHRoaXMuYnlVcHN0cmVhbVJlZi5nZXQoYCR7cmVtb3RlTmFtZX1cXDAke3JlbW90ZVJlZk5hbWV9YCkgfHwgW107XG4gIH1cblxuICAvLyBSZXR1cm4gYW4gQXJyYXkgb2YgQnJhbmNoZXMgdGhhdCB3aWxsIHVwZGF0ZSBhIGdpdmVuIHJlbW90ZSByZWYgb24gYW4gdW5xdWFsaWZpZWQgYGdpdCBwdXNoYC4gVGhpcyBhY2NvdW50cyBmb3JcbiAgLy8gdGhlIGN1cnJlbnQgYGJyYW5jaC5wdXNoUmVtb3RlYCBzZXR0aW5nIGFuZCBgcmVtb3RlLjxuYW1lPi5wdXNoYCByZWZzcGVjLlxuICBnZXRQdXNoU291cmNlcyhyZW1vdGVOYW1lLCByZW1vdGVSZWZOYW1lKSB7XG4gICAgcmV0dXJuIHRoaXMuYnlQdXNoUmVmLmdldChgJHtyZW1vdGVOYW1lfVxcMCR7cmVtb3RlUmVmTmFtZX1gKSB8fCBbXTtcbiAgfVxuXG4gIGluc3BlY3QoZGVwdGgsIG9wdGlvbnMpIHtcbiAgICByZXR1cm4gYEJyYW5jaFNldCB7JHt1dGlsLmluc3BlY3QodGhpcy5hbGwpfX1gO1xuICB9XG59XG4iXX0=