"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareReviewsController = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _propTypes2 = require("../prop-types");

var _reviewsView = _interopRequireDefault(require("../views/reviews-view"));

var _prCheckoutController = _interopRequireDefault(require("../controllers/pr-checkout-controller"));

var _addPrReview = _interopRequireDefault(require("../mutations/add-pr-review"));

var _addPrReviewComment = _interopRequireDefault(require("../mutations/add-pr-review-comment"));

var _submitPrReview = _interopRequireDefault(require("../mutations/submit-pr-review"));

var _deletePrReview = _interopRequireDefault(require("../mutations/delete-pr-review"));

var _resolveReviewThread = _interopRequireDefault(require("../mutations/resolve-review-thread"));

var _unresolveReviewThread = _interopRequireDefault(require("../mutations/unresolve-review-thread"));

var _updatePrReviewComment = _interopRequireDefault(require("../mutations/update-pr-review-comment"));

var _updatePrReviewSummary = _interopRequireDefault(require("../mutations/update-pr-review-summary"));

var _issueishDetailItem = _interopRequireDefault(require("../items/issueish-detail-item"));

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Milliseconds to update highlightedThreadIDs
const FLASH_DELAY = 1500;

class BareReviewsController extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "openFile", async (filePath, lineNumber) => {
      await this.props.workspace.open(filePath, {
        initialLine: lineNumber - 1,
        initialColumn: 0,
        pending: true
      });
      (0, _reporterProxy.addEvent)('reviews-dock-open-file', {
        "package": 'github'
      });
    });

    _defineProperty(this, "openDiff", async (filePath, lineNumber) => {
      const item = await this.getPRDetailItem();
      item.openFilesTab({
        changedFilePath: filePath,
        changedFilePosition: lineNumber
      });
      (0, _reporterProxy.addEvent)('reviews-dock-open-diff', {
        "package": 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "openPR", async () => {
      await this.getPRDetailItem();
      (0, _reporterProxy.addEvent)('reviews-dock-open-pr', {
        "package": 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "getPRDetailItem", () => {
      return this.props.workspace.open(_issueishDetailItem["default"].buildURI({
        host: this.props.endpoint.getHost(),
        owner: this.props.owner,
        repo: this.props.repo,
        number: this.props.number,
        workdir: this.props.workdir
      }), {
        pending: true,
        searchAllPanes: true
      });
    });

    _defineProperty(this, "moreContext", () => {
      this.setState(prev => ({
        contextLines: prev.contextLines + 1
      }));
      (0, _reporterProxy.addEvent)('reviews-dock-show-more-context', {
        "package": 'github'
      });
    });

    _defineProperty(this, "lessContext", () => {
      this.setState(prev => ({
        contextLines: Math.max(prev.contextLines - 1, 1)
      }));
      (0, _reporterProxy.addEvent)('reviews-dock-show-less-context', {
        "package": 'github'
      });
    });

    _defineProperty(this, "openIssueish", async (owner, repo, number) => {
      const host = this.props.endpoint.getHost();
      const homeRepository = (await this.props.localRepository.hasGitHubRemote(host, owner, repo)) ? this.props.localRepository : (await this.props.workdirContextPool.getMatchingContext(host, owner, repo)).getRepository();

      const uri = _issueishDetailItem["default"].buildURI({
        host,
        owner,
        repo,
        number,
        workdir: homeRepository.getWorkingDirectoryPath()
      });

      return this.props.workspace.open(uri, {
        pending: true,
        searchAllPanes: true
      });
    });

    _defineProperty(this, "showSummaries", () => new Promise(resolve => this.setState({
      summarySectionOpen: true
    }, resolve)));

    _defineProperty(this, "hideSummaries", () => new Promise(resolve => this.setState({
      summarySectionOpen: false
    }, resolve)));

    _defineProperty(this, "showComments", () => new Promise(resolve => this.setState({
      commentSectionOpen: true
    }, resolve)));

    _defineProperty(this, "hideComments", () => new Promise(resolve => this.setState({
      commentSectionOpen: false
    }, resolve)));

    _defineProperty(this, "showThreadID", commentID => new Promise(resolve => this.setState(state => {
      state.threadIDsOpen.add(commentID);
      return {};
    }, resolve)));

    _defineProperty(this, "hideThreadID", commentID => new Promise(resolve => this.setState(state => {
      state.threadIDsOpen["delete"](commentID);
      return {};
    }, resolve)));

    _defineProperty(this, "highlightThread", threadID => {
      this.setState(state => {
        state.highlightedThreadIDs.add(threadID);
        return {};
      }, () => {
        setTimeout(() => this.setState(state => {
          state.highlightedThreadIDs["delete"](threadID);

          if (state.scrollToThreadID === threadID) {
            return {
              scrollToThreadID: null
            };
          }

          return {};
        }), FLASH_DELAY);
      });
    });

    _defineProperty(this, "resolveThread", async thread => {
      if (thread.viewerCanResolve) {
        // optimistically hide the thread to avoid jankiness;
        // if the operation fails, the onError callback will revert it.
        this.hideThreadID(thread.id);

        try {
          await (0, _resolveReviewThread["default"])(this.props.relay.environment, {
            threadID: thread.id,
            viewerID: this.props.viewer.id,
            viewerLogin: this.props.viewer.login
          });
          this.highlightThread(thread.id);
          (0, _reporterProxy.addEvent)('resolve-comment-thread', {
            "package": 'github'
          });
        } catch (err) {
          this.showThreadID(thread.id);
          this.props.reportRelayError('Unable to resolve the comment thread', err);
        }
      }
    });

    _defineProperty(this, "unresolveThread", async thread => {
      if (thread.viewerCanUnresolve) {
        try {
          await (0, _unresolveReviewThread["default"])(this.props.relay.environment, {
            threadID: thread.id,
            viewerID: this.props.viewer.id,
            viewerLogin: this.props.viewer.login
          });
          this.highlightThread(thread.id);
          (0, _reporterProxy.addEvent)('unresolve-comment-thread', {
            "package": 'github'
          });
        } catch (err) {
          this.props.reportRelayError('Unable to unresolve the comment thread', err);
        }
      }
    });

    _defineProperty(this, "addSingleComment", async (commentBody, threadID, replyToID, path, position, callbacks = {}) => {
      let pendingReviewID = null;

      try {
        this.setState({
          postingToThreadID: threadID
        });
        const reviewResult = await (0, _addPrReview["default"])(this.props.relay.environment, {
          pullRequestID: this.props.pullRequest.id,
          viewerID: this.props.viewer.id
        });
        const reviewID = reviewResult.addPullRequestReview.reviewEdge.node.id;
        pendingReviewID = reviewID;
        const commentPromise = (0, _addPrReviewComment["default"])(this.props.relay.environment, {
          body: commentBody,
          inReplyTo: replyToID,
          reviewID,
          threadID,
          viewerID: this.props.viewer.id,
          path,
          position
        });

        if (callbacks.didSubmitComment) {
          callbacks.didSubmitComment();
        }

        await commentPromise;
        pendingReviewID = null;
        await (0, _submitPrReview["default"])(this.props.relay.environment, {
          event: 'COMMENT',
          reviewID
        });
        (0, _reporterProxy.addEvent)('add-single-comment', {
          "package": 'github'
        });
      } catch (error) {
        if (callbacks.didFailComment) {
          callbacks.didFailComment();
        }

        if (pendingReviewID !== null) {
          try {
            await (0, _deletePrReview["default"])(this.props.relay.environment, {
              reviewID: pendingReviewID,
              pullRequestID: this.props.pullRequest.id
            });
          } catch (e) {
            /* istanbul ignore else */
            if (error.errors && e.errors) {
              error.errors.push(...e.errors);
            } else {
              // eslint-disable-next-line no-console
              console.warn('Unable to delete pending review', e);
            }
          }
        }

        this.props.reportRelayError('Unable to submit your comment', error);
      } finally {
        this.setState({
          postingToThreadID: null
        });
      }
    });

    _defineProperty(this, "updateComment", async (commentId, commentBody) => {
      try {
        await (0, _updatePrReviewComment["default"])(this.props.relay.environment, {
          commentId,
          commentBody
        });
        (0, _reporterProxy.addEvent)('update-review-comment', {
          "package": 'github'
        });
      } catch (error) {
        this.props.reportRelayError('Unable to update comment', error);
        throw error;
      }
    });

    _defineProperty(this, "updateSummary", async (reviewId, reviewBody) => {
      try {
        await (0, _updatePrReviewSummary["default"])(this.props.relay.environment, {
          reviewId,
          reviewBody
        });
        (0, _reporterProxy.addEvent)('update-review-summary', {
          "package": 'github'
        });
      } catch (error) {
        this.props.reportRelayError('Unable to update review summary', error);
        throw error;
      }
    });

    this.state = {
      contextLines: 4,
      postingToThreadID: null,
      scrollToThreadID: this.props.initThreadID,
      summarySectionOpen: true,
      commentSectionOpen: true,
      threadIDsOpen: new Set(this.props.initThreadID ? [this.props.initThreadID] : []),
      highlightedThreadIDs: new Set()
    };
  }

  componentDidMount() {
    const {
      scrollToThreadID
    } = this.state;

    if (scrollToThreadID) {
      this.highlightThread(scrollToThreadID);
    }
  }

  componentDidUpdate(prevProps) {
    const {
      initThreadID
    } = this.props;

    if (initThreadID && initThreadID !== prevProps.initThreadID) {
      this.setState(prev => {
        prev.threadIDsOpen.add(initThreadID);
        this.highlightThread(initThreadID);
        return {
          commentSectionOpen: true,
          scrollToThreadID: initThreadID
        };
      });
    }
  }

  render() {
    return _react["default"].createElement(_prCheckoutController["default"], {
      repository: this.props.repository,
      pullRequest: this.props.pullRequest,
      localRepository: this.props.localRepository,
      isAbsent: this.props.isAbsent,
      isLoading: this.props.isLoading,
      isPresent: this.props.isPresent,
      isMerging: this.props.isMerging,
      isRebasing: this.props.isRebasing,
      branches: this.props.branches,
      remotes: this.props.remotes
    }, checkoutOp => _react["default"].createElement(_reviewsView["default"], _extends({
      checkoutOp: checkoutOp,
      contextLines: this.state.contextLines,
      postingToThreadID: this.state.postingToThreadID,
      summarySectionOpen: this.state.summarySectionOpen,
      commentSectionOpen: this.state.commentSectionOpen,
      threadIDsOpen: this.state.threadIDsOpen,
      highlightedThreadIDs: this.state.highlightedThreadIDs,
      scrollToThreadID: this.state.scrollToThreadID,
      moreContext: this.moreContext,
      lessContext: this.lessContext,
      openFile: this.openFile,
      openDiff: this.openDiff,
      openPR: this.openPR,
      openIssueish: this.openIssueish,
      showSummaries: this.showSummaries,
      hideSummaries: this.hideSummaries,
      showComments: this.showComments,
      hideComments: this.hideComments,
      showThreadID: this.showThreadID,
      hideThreadID: this.hideThreadID,
      resolveThread: this.resolveThread,
      unresolveThread: this.unresolveThread,
      addSingleComment: this.addSingleComment,
      updateComment: this.updateComment,
      updateSummary: this.updateSummary
    }, this.props)));
  }

}

exports.BareReviewsController = BareReviewsController;

_defineProperty(BareReviewsController, "propTypes", {
  // Relay results
  relay: _propTypes["default"].shape({
    environment: _propTypes["default"].object.isRequired
  }).isRequired,
  viewer: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired
  }).isRequired,
  repository: _propTypes["default"].object.isRequired,
  pullRequest: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired
  }).isRequired,
  summaries: _propTypes["default"].array.isRequired,
  commentThreads: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    thread: _propTypes["default"].object.isRequired,
    comments: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired
  })),
  refetch: _propTypes["default"].func.isRequired,
  // Package models
  workdirContextPool: _propTypes2.WorkdirContextPoolPropType.isRequired,
  localRepository: _propTypes["default"].object.isRequired,
  isAbsent: _propTypes["default"].bool.isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  isPresent: _propTypes["default"].bool.isRequired,
  isMerging: _propTypes["default"].bool.isRequired,
  isRebasing: _propTypes["default"].bool.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  multiFilePatch: _propTypes["default"].object.isRequired,
  initThreadID: _propTypes["default"].string,
  // Connection properties
  endpoint: _propTypes2.EndpointPropType.isRequired,
  // URL parameters
  owner: _propTypes["default"].string.isRequired,
  repo: _propTypes["default"].string.isRequired,
  number: _propTypes["default"].number.isRequired,
  workdir: _propTypes["default"].string.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  confirm: _propTypes["default"].func.isRequired,
  // Action methods
  reportRelayError: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareReviewsController, {
  viewer: function () {
    const node = require("./__generated__/reviewsController_viewer.graphql");

    if (node.hash && node.hash !== "e9e4cf88f2d8a809620a0f225d502896") {
      console.error("The definition of 'reviewsController_viewer' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/reviewsController_viewer.graphql");
  },
  repository: function () {
    const node = require("./__generated__/reviewsController_repository.graphql");

    if (node.hash && node.hash !== "1e0016aed6db6035651ff6213eb38ff6") {
      console.error("The definition of 'reviewsController_repository' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/reviewsController_repository.graphql");
  },
  pullRequest: function () {
    const node = require("./__generated__/reviewsController_pullRequest.graphql");

    if (node.hash && node.hash !== "9d67f9908ab4ed776af5f1ee14f61ccb") {
      console.error("The definition of 'reviewsController_pullRequest' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/reviewsController_pullRequest.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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