"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _githubTabView = _interopRequireDefault(require("../views/github-tab-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitHubTabController extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "handlePushBranch", (currentBranch, targetRemote) => {
      return this.props.repository.push(currentBranch.getName(), {
        remote: targetRemote,
        setUpstream: true
      });
    });

    _defineProperty(this, "handleRemoteSelect", (e, remote) => {
      e.preventDefault();
      return this.props.repository.setConfig('atomGithub.currentRemote', remote.getName());
    });
  }

  render() {
    const gitHubRemotes = this.props.allRemotes.filter(remote => remote.isGithubRepo());
    const currentBranch = this.props.branches.getHeadBranch();
    let currentRemote = gitHubRemotes.withName(this.props.selectedRemoteName);
    let manyRemotesAvailable = false;

    if (!currentRemote.isPresent() && gitHubRemotes.size() === 1) {
      currentRemote = Array.from(gitHubRemotes)[0];
    } else if (!currentRemote.isPresent() && gitHubRemotes.size() > 1) {
      manyRemotesAvailable = true;
    }

    return _react["default"].createElement(_githubTabView["default"], {
      workspace: this.props.workspace,
      remoteOperationObserver: this.props.remoteOperationObserver,
      loginModel: this.props.loginModel,
      rootHolder: this.props.rootHolder,
      workingDirectory: this.props.workingDirectory,
      branches: this.props.branches,
      currentBranch: currentBranch,
      remotes: gitHubRemotes,
      currentRemote: currentRemote,
      manyRemotesAvailable: manyRemotesAvailable,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      isLoading: this.props.isLoading,
      handlePushBranch: this.handlePushBranch,
      handleRemoteSelect: this.handleRemoteSelect
    });
  }

}

exports["default"] = GitHubTabController;

_defineProperty(GitHubTabController, "propTypes", {
  workspace: _propTypes["default"].object.isRequired,
  repository: _propTypes["default"].object.isRequired,
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  rootHolder: _propTypes2.RefHolderPropType.isRequired,
  workingDirectory: _propTypes["default"].string,
  allRemotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  selectedRemoteName: _propTypes["default"].string,
  aheadCount: _propTypes["default"].number,
  pushInProgress: _propTypes["default"].bool.isRequired,
  isLoading: _propTypes["default"].bool.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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