/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.dom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.util.Debug;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DOMDocument
implements Document {
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private org.w3c.dom.Document contentDoc = null;
    private String documentName = null;
    private String fileName = null;
    private String fileExt = null;

    public DOMDocument(String name, String ext) {
        this(name, ext, true, false);
    }

    private String getFileExtension() {
        return this.fileExt;
    }

    private DOMDocument(String name, String ext, boolean namespaceAware, boolean validating) {
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceAware);
        this.fileExt = ext;
        this.documentName = this.trimDocumentName(name);
        this.fileName = this.documentName + this.getFileExtension();
    }

    private String trimDocumentName(String name) {
        String ext;
        String temp = name.toLowerCase();
        if (temp.endsWith(ext = this.getFileExtension())) {
            int nlen = name.length();
            int endIndex = nlen - ext.length();
            name = name.substring(0, endIndex);
        }
        return name;
    }

    public org.w3c.dom.Document getContentDOM() {
        return this.contentDoc;
    }

    public void setContentDOM(Node newDom) {
        this.contentDoc = (org.w3c.dom.Document)newDom;
    }

    public String getName() {
        return this.documentName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void read(InputStream is) throws IOException {
        Debug.log(1, "reading file");
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.contentDoc = builder.parse(is);
        }
        catch (ParserConfigurationException ex) {
            System.out.println("Error:" + ex);
        }
        catch (SAXException ex) {
            System.out.println("Error:" + ex);
        }
    }

    public void write(OutputStream os) throws IOException {
        byte[] contentBytes = this.docToBytes(this.contentDoc);
        os.write(contentBytes);
    }

    private byte[] docToBytes(org.w3c.dom.Document doc) throws IOException {
        ByteArrayOutputStream baos;
        block8: {
            baos = new ByteArrayOutputStream();
            String domImpl = doc.getClass().getName();
            System.err.println("type b " + domImpl);
            try {
                if (domImpl.equals("com.sun.xml.tree.XmlDocument")) {
                    System.out.println("Using JAXP");
                    Class<?> jaxpDoc = Class.forName("com.sun.xml.tree.XmlDocument");
                    Method meth = jaxpDoc.getMethod("write", Class.forName("java.io.OutputStream"));
                    meth.invoke((Object)doc, baos);
                    break block8;
                }
                if (domImpl.equals("org.apache.crimson.tree.XmlDocument")) {
                    System.out.println("Using Crimson");
                    Class<?> crimsonDoc = Class.forName("org.apache.crimson.tree.XmlDocument");
                    Method meth = crimsonDoc.getMethod("write", Class.forName("java.io.OutputStream"));
                    meth.invoke((Object)doc, baos);
                    break block8;
                }
                if (domImpl.equals("org.apache.xerces.dom.DocumentImpl") || domImpl.equals("org.apache.xerces.dom.DeferredDocumentImpl")) {
                    System.out.println("Using Xerces");
                    Class<?> xercesSer = Class.forName("org.apache.xml.serialize.XMLSerializer");
                    Constructor<?> con = xercesSer.getConstructor(Class.forName("java.io.OutputStream"), Class.forName("org.apache.xml.serialize.OutputFormat"));
                    Method meth = xercesSer.getMethod("serialize", Class.forName("org.w3c.dom.Document"));
                    Object serializer = con.newInstance(baos, null);
                    meth.invoke(serializer, doc);
                    break block8;
                }
                if (domImpl.equals("gnu.xml.dom.DomDocument")) {
                    System.out.println("Using GNU");
                    Class<?> gnuSer = Class.forName("gnu.xml.dom.ls.DomLSSerializer");
                    Method meth = gnuSer.getMethod("serialize", Class.forName("org.w3c.dom.Node"), Class.forName("java.io.OutputStream"));
                    Object serializer = gnuSer.newInstance();
                    meth.invoke(serializer, doc, baos);
                    break block8;
                }
                try {
                    DOMSource domSource = new DOMSource(doc);
                    StringWriter writer = new StringWriter();
                    StreamResult result = new StreamResult(writer);
                    TransformerFactory tf = TransformerFactory.newInstance();
                    Transformer transformer = tf.newTransformer();
                    transformer.transform(domSource, result);
                    return writer.toString().getBytes();
                }
                catch (Exception e) {
                    IOException ex2 = new IOException("No appropriate API (JAXP/Xerces) to serialize XML document: " + domImpl);
                    ex2.initCause(e);
                    throw ex2;
                }
            }
            catch (Exception e) {
                IOException newEx = new IOException(e.getMessage());
                newEx.initCause(e);
                throw newEx;
            }
        }
        byte[] bytes = baos.toByteArray();
        return bytes;
    }
}

