"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var _this = this;
Object.defineProperty(exports, "__esModule", { value: true });
var electron_1 = require("electron");
var fileUrl = require("file-url");
var path = require("path");
var eventType_1 = require("../lib/eventType");
var locale = require("../locale/locale");
var config_1 = require("../settings/config");
var appPath = path.join(electron_1.app.getAppPath(), config_1.config.electronDirectory);
var promptHtmlPath = fileUrl(path.join(appPath, 'html/proxy-prompt.html'));
var proxyPromptWindowWhitelist = [promptHtmlPath, fileUrl(path.join(appPath, 'css/proxy-prompt.css'))];
var preloadPath = path.join(appPath, 'dist/renderer/menu/preload-proxy-prompt.js');
var windowSize = {
    HEIGHT: 350,
    WIDTH: 550,
};
var showWindow = function () {
    var proxyPromptWindow;
    if (!proxyPromptWindow) {
        proxyPromptWindow = new electron_1.BrowserWindow({
            alwaysOnTop: true,
            backgroundColor: '#ececec',
            fullscreen: false,
            height: windowSize.HEIGHT,
            maximizable: false,
            minimizable: false,
            resizable: false,
            show: false,
            title: config_1.config.name,
            webPreferences: {
                javascript: true,
                nodeIntegration: false,
                nodeIntegrationInWorker: false,
                preload: preloadPath,
                session: electron_1.session.fromPartition('proxy-prompt-window'),
                webviewTag: false,
            },
            width: windowSize.WIDTH,
        });
        proxyPromptWindow.setMenuBarVisibility(false);
        proxyPromptWindow.webContents.session.webRequest.onBeforeRequest(function (_a, callback) {
            var url = _a.url;
            return __awaiter(_this, void 0, void 0, function () {
                return __generator(this, function (_b) {
                    if (proxyPromptWindowWhitelist.includes(url)) {
                        return [2, callback({ cancel: false })];
                    }
                    callback({ redirectURL: promptHtmlPath });
                    return [2];
                });
            });
        });
        electron_1.ipcMain.on(eventType_1.EVENT_TYPE.PROXY_PROMPT.LOCALE_VALUES, function (event, labels) {
            if (proxyPromptWindow) {
                var isExpected = event.sender.id === proxyPromptWindow.webContents.id;
                if (isExpected) {
                    var resultLabels_1 = {};
                    labels.forEach(function (label) { return (resultLabels_1[label] = locale.getText(label)); });
                    event.sender.send(eventType_1.EVENT_TYPE.PROXY_PROMPT.LOCALE_RENDER, resultLabels_1);
                }
            }
        });
        proxyPromptWindow.on('closed', function () { return (proxyPromptWindow = undefined); });
        proxyPromptWindow.loadURL(promptHtmlPath);
        proxyPromptWindow.webContents.on('dom-ready', function () {
            if (proxyPromptWindow) {
                proxyPromptWindow.webContents.send(eventType_1.EVENT_TYPE.PROXY_PROMPT.LOADED);
            }
        });
    }
    proxyPromptWindow.show();
};
exports.ProxyPromptWindow = { showWindow: showWindow };
//# sourceMappingURL=ProxyPromptWindow.js.map