"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var electron_1 = require("electron");
var eventType_1 = require("../../lib/eventType");
electron_1.ipcRenderer.once(eventType_1.EVENT_TYPE.PROXY_PROMPT.LOCALE_RENDER, function (event, labels) {
    for (var label in labels) {
        var labelElement = document.querySelector("[data-string=\"" + label + "\"]");
        if (labelElement) {
            labelElement.innerHTML = labels[label];
        }
    }
});
electron_1.ipcRenderer.once(eventType_1.EVENT_TYPE.PROXY_PROMPT.LOADED, function () {
    var labels = [];
    var dataStrings = document.querySelectorAll('[data-string]');
    for (var index in dataStrings) {
        var label = dataStrings[index];
        if (label.dataset) {
            labels.push(label.dataset.string);
        }
    }
    electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.PROXY_PROMPT.LOCALE_VALUES, labels);
    var okButton = document.querySelector('#okButton');
    var cancelButton = document.querySelector('#cancelButton');
    var usernameInput = document.querySelector('#usernameInput');
    var passwordInput = document.querySelector('#passwordInput');
    var form = document.querySelector('#form');
    if (cancelButton && okButton && usernameInput && passwordInput && form) {
        usernameInput.focus();
        var sendData_1 = function () {
            electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.PROXY_PROMPT.SUBMITTED, {
                password: passwordInput.value,
                username: usernameInput.value,
            });
            window.close();
        };
        cancelButton.addEventListener('click', function () {
            electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.PROXY_PROMPT.CANCELED);
            window.close();
        });
        form.addEventListener('submit', function () { return sendData_1(); });
        window.addEventListener('keydown', function (event) {
            if (event.key === 'Escape') {
                electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.PROXY_PROMPT.CANCELED);
                window.close();
            }
        });
    }
});
//# sourceMappingURL=preload-proxy-prompt.js.map