/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkDomainsParallelChemistryObjectFactory.h

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef vtkDomainsParallelChemistryObjectFactory_h
#define vtkDomainsParallelChemistryObjectFactory_h

#include "vtkDomainsParallelChemistryModule.h" // For export macro
#include "vtkObjectFactory.h"

class VTKDOMAINSPARALLELCHEMISTRY_EXPORT vtkDomainsParallelChemistryObjectFactory : public vtkObjectFactory
{
public:
  static vtkDomainsParallelChemistryObjectFactory * New();
  vtkTypeMacro(vtkDomainsParallelChemistryObjectFactory, vtkObjectFactory)

  const char * GetDescription() override { return "vtkDomainsParallelChemistry factory overrides."; }

  const char * GetVTKSourceVersion() override;

  void PrintSelf(ostream &os, vtkIndent indent) override;

protected:
  vtkDomainsParallelChemistryObjectFactory();

private:
  vtkDomainsParallelChemistryObjectFactory(const vtkDomainsParallelChemistryObjectFactory&) = delete;
  void operator=(const vtkDomainsParallelChemistryObjectFactory&) = delete;
};

#endif // vtkDomainsParallelChemistryObjectFactory_h
