# -*- coding: utf-8 -*-
info = {
    "name": "ta",
    "date_order": "DMY",
    "january": [
        "ஜனவரி",
        "ஜன"
    ],
    "february": [
        "பிப்ரவரி",
        "பிப்"
    ],
    "march": [
        "மார்ச்",
        "மார்"
    ],
    "april": [
        "ஏப்ரல்",
        "ஏப்"
    ],
    "may": [
        "மே"
    ],
    "june": [
        "ஜூன்"
    ],
    "july": [
        "ஜூலை"
    ],
    "august": [
        "ஆகஸ்ட்",
        "ஆக"
    ],
    "september": [
        "செப்டம்பர்",
        "செப்"
    ],
    "october": [
        "அக்டோபர்",
        "அக்"
    ],
    "november": [
        "நவம்பர்",
        "நவ"
    ],
    "december": [
        "டிசம்பர்",
        "டிச"
    ],
    "monday": [
        "திங்கள்",
        "திங்"
    ],
    "tuesday": [
        "செவ்வாய்",
        "செவ்"
    ],
    "wednesday": [
        "புதன்",
        "புத"
    ],
    "thursday": [
        "வியாழன்",
        "வியா"
    ],
    "friday": [
        "வெள்ளி",
        "வெள்"
    ],
    "saturday": [
        "சனி"
    ],
    "sunday": [
        "ஞாயிறு",
        "ஞாயி"
    ],
    "am": [
        "முற்பகல்"
    ],
    "pm": [
        "பிற்பகல்"
    ],
    "year": [
        "ஆண்டு",
        "ஆ"
    ],
    "month": [
        "மாதம்",
        "மாத",
        "மா"
    ],
    "week": [
        "வாரம்",
        "வா"
    ],
    "day": [
        "நாள்",
        "நா"
    ],
    "hour": [
        "மணி",
        "ம"
    ],
    "minute": [
        "நிமிடம்",
        "நிமி"
    ],
    "second": [
        "விநாடி",
        "விநா",
        "வி"
    ],
    "relative-type": {
        "1 year ago": [
            "கடந்த ஆண்டு"
        ],
        "0 year ago": [
            "இந்த ஆண்டு"
        ],
        "in 1 year": [
            "அடுத்த ஆண்டு"
        ],
        "1 month ago": [
            "கடந்த மாதம்"
        ],
        "0 month ago": [
            "இந்த மாதம்"
        ],
        "in 1 month": [
            "அடுத்த மாதம்"
        ],
        "1 week ago": [
            "கடந்த வாரம்"
        ],
        "0 week ago": [
            "இந்த வாரம்"
        ],
        "in 1 week": [
            "அடுத்த வாரம்"
        ],
        "1 day ago": [
            "நேற்று"
        ],
        "0 day ago": [
            "இன்று"
        ],
        "in 1 day": [
            "நாளை"
        ],
        "0 hour ago": [
            "இந்த ஒரு மணிநேரத்தில்"
        ],
        "0 minute ago": [
            "இந்த ஒரு நிமிடத்தில்"
        ],
        "0 second ago": [
            "இப்போது"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "(\\d+) ஆண்டில்",
            "(\\d+) ஆண்டுகளில்",
            "(\\d+) ஆ"
        ],
        "\\1 year ago": [
            "(\\d+) ஆண்டிற்கு முன்",
            "(\\d+) ஆண்டுகளுக்கு முன்",
            "(\\d+) ஆ முன்"
        ],
        "in \\1 month": [
            "(\\d+) மாதத்தில்",
            "(\\d+) மாதங்களில்",
            "(\\d+) மாத",
            "(\\d+) மா"
        ],
        "\\1 month ago": [
            "(\\d+) மாதத்துக்கு முன்",
            "(\\d+) மாதங்களுக்கு முன்",
            "(\\d+) மாத முன்",
            "(\\d+) மா முன்"
        ],
        "in \\1 week": [
            "(\\d+) வாரத்தில்",
            "(\\d+) வாரங்களில்",
            "(\\d+) வார",
            "(\\d+) வா"
        ],
        "\\1 week ago": [
            "(\\d+) வாரத்திற்கு முன்பு",
            "(\\d+) வாரங்களுக்கு முன்",
            "(\\d+) வார முன்",
            "(\\d+) வா முன்"
        ],
        "in \\1 day": [
            "(\\d+) நாளில்",
            "(\\d+) நாட்களில்",
            "(\\d+) நா"
        ],
        "\\1 day ago": [
            "(\\d+) நாளுக்கு முன்",
            "(\\d+) நாட்களுக்கு முன்",
            "(\\d+) நா முன்"
        ],
        "in \\1 hour": [
            "(\\d+) மணிநேரத்தில்",
            "(\\d+) மணி",
            "(\\d+) ம"
        ],
        "\\1 hour ago": [
            "(\\d+) மணிநேரம் முன்",
            "(\\d+) மணி முன்",
            "(\\d+) ம முன்"
        ],
        "in \\1 minute": [
            "(\\d+) நிமிடத்தில்",
            "(\\d+) நிமிடங்களில்",
            "(\\d+) நிமி",
            "(\\d+) நி"
        ],
        "\\1 minute ago": [
            "(\\d+) நிமிடத்திற்கு முன்",
            "(\\d+) நிமிடங்களுக்கு முன்",
            "(\\d+) நிமி முன்",
            "(\\d+) நி முன்"
        ],
        "in \\1 second": [
            "(\\d+) விநாடியில்",
            "(\\d+) விநாடிகளில்",
            "(\\d+) விநா",
            "(\\d+) வி"
        ],
        "\\1 second ago": [
            "(\\d+) விநாடிக்கு முன்",
            "(\\d+) விநாடிகளுக்கு முன்",
            "(\\d+) விநா முன்",
            "(\\d+) வி முன்"
        ]
    },
    "locale_specific": {
        "ta-SG": {
            "name": "ta-SG"
        },
        "ta-LK": {
            "name": "ta-LK"
        },
        "ta-MY": {
            "name": "ta-MY"
        }
    },
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}