/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.codeInsight;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.changes.ignore.cache.PatternCache;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreEntryDirectory;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreEntryFile;
import com.intellij.openapi.vcs.changes.ignore.util.RegexUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoreDirectoryMarkerProvider
implements LineMarkerProvider {
    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result2) {
        if (elements == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(2);
        }
        for (PsiElement element : elements) {
            if (!(element instanceof IgnoreEntryFile)) continue;
            boolean isDirectory = element instanceof IgnoreEntryDirectory;
            if (!isDirectory) {
                IgnoreEntryFile entry = (IgnoreEntryFile)element;
                VirtualFile parent = element.getContainingFile().getVirtualFile().getParent();
                Project project = element.getProject();
                VirtualFile projectDir = project.getBaseDir();
                if (parent == null || projectDir == null) continue;
                PatternCache patternCache = PatternCache.getInstance(element.getProject());
                Pattern pattern = patternCache.createPattern(entry);
                boolean bl = isDirectory = pattern != null && IgnoreDirectoryMarkerProvider.isDirectoryExist(parent, pattern);
            }
            if (!isDirectory) continue;
            result2.add(new LineMarkerInfo(element.getFirstChild(), element.getTextRange(), PlatformIcons.FOLDER_ICON, null, null, GutterIconRenderer.Alignment.CENTER));
        }
    }

    private static boolean isDirectoryExist(@NotNull VirtualFile root, @NotNull Pattern pattern) {
        if (root == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(3);
        }
        if (pattern == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(4);
        }
        Ref found = Ref.create((Object)false);
        VfsUtilCore.iterateChildrenRecursively((VirtualFile)root, file -> file.isDirectory(), dir -> {
            String path = VfsUtilCore.getRelativePath((VirtualFile)dir, (VirtualFile)root);
            if (path != null && RegexUtil.match(pattern, path)) {
                found.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)found.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/ignore/codeInsight/IgnoreDirectoryMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isDirectoryExist";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

