/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.search;

import com.intellij.icons.AllIcons;
import com.intellij.largeFilesEditor.editor.EditorManagerAccessorImpl;
import com.intellij.largeFilesEditor.search.SearchResultsPanelManagerAccessor;
import com.intellij.largeFilesEditor.search.searchResultsPanel.SearchResultsToolWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SearchResultsPanelManagerAccessorImpl
implements SearchResultsPanelManagerAccessor {
    private static final Logger logger = Logger.getInstance(SearchResultsPanelManagerAccessorImpl.class);
    private static final String TOOLWINDOW_ID = "lfe.toolWindow.searchResults";
    private static final String TOOLWINDOW_STRIPE_TITLE = "Find in Large File";

    @Override
    public SearchResultsToolWindow getSearchResultsToolWindow(boolean createIfNotExists, Project project, VirtualFile virtualFile) {
        Content neededContent;
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(TOOLWINDOW_ID);
        if (toolWindow == null) {
            if (!createIfNotExists) {
                return null;
            }
            toolWindow = ToolWindowManager.getInstance((Project)project).registerToolWindow(TOOLWINDOW_ID, true, ToolWindowAnchor.BOTTOM, (Disposable)project, true);
            toolWindow.setStripeTitle(TOOLWINDOW_STRIPE_TITLE);
            toolWindow.setToHideOnEmptyContent(true);
            toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowFind);
        }
        if ((neededContent = SearchResultsPanelManagerAccessorImpl.tryGetNeededContentFromRangeSearchToolWindow(toolWindow, virtualFile)) == null) {
            if (!createIfNotExists) {
                return null;
            }
            EditorManagerAccessorImpl editorManagerAccessor = new EditorManagerAccessorImpl();
            final SearchResultsToolWindow searchResultsToolWindow = new SearchResultsToolWindow(virtualFile, project, editorManagerAccessor);
            JComponent toolWindowTabContent = searchResultsToolWindow.getComponent();
            String tabName = virtualFile.getName();
            neededContent = ContentFactory.SERVICE.getInstance().createContent(toolWindowTabContent, tabName, true);
            neededContent.putUserData(SearchResultsToolWindow.KEY, (Object)searchResultsToolWindow);
            neededContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
            toolWindow.getContentManager().addContent(neededContent);
            searchResultsToolWindow.setRelativeTab(neededContent);
            ContentManager contentManager = toolWindow.getContentManager();
            contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

                public void contentRemoved(@NotNull ContentManagerEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    searchResultsToolWindow.tellWasClosed();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/largeFilesEditor/search/SearchResultsPanelManagerAccessorImpl$1", "contentRemoved"));
                }
            });
            return searchResultsToolWindow;
        }
        SearchResultsToolWindow searchResultsToolWindow = (SearchResultsToolWindow)((Object)neededContent.getUserData(SearchResultsToolWindow.KEY));
        if (searchResultsToolWindow != null) {
            return searchResultsToolWindow;
        }
        logger.warn("searchResultsToolWindow is null, but it shouldn't be");
        return null;
    }

    @Override
    public void showSearchResultsToolWindow(@NotNull SearchResultsToolWindow searchResultsToolWindow) {
        ToolWindow toolWindow;
        if (searchResultsToolWindow == null) {
            SearchResultsPanelManagerAccessorImpl.$$$reportNull$$$0(0);
        }
        if ((toolWindow = ToolWindowManager.getInstance((Project)searchResultsToolWindow.getProject()).getToolWindow(TOOLWINDOW_ID)) != null) {
            toolWindow.show(null);
            Content neededContent = SearchResultsPanelManagerAccessorImpl.tryGetNeededContentFromRangeSearchToolWindow(toolWindow, searchResultsToolWindow.getVirtualFile());
            if (neededContent != null) {
                toolWindow.getContentManager().setSelectedContent(neededContent);
            }
        }
    }

    @Override
    public void closeToolWindowTab(VirtualFile virtualFile, Project project) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(TOOLWINDOW_ID);
        if (toolWindow == null) {
            return;
        }
        ContentManager contentManager = toolWindow.getContentManager();
        Content[] contents = contentManager.getContents();
        Content neededContent = null;
        for (Content content2 : contents) {
            SearchResultsToolWindow connectedSearchResultsGUI = (SearchResultsToolWindow)((Object)content2.getUserData(SearchResultsToolWindow.KEY));
            if (connectedSearchResultsGUI == null) {
                logger.warn("connectedSearchResultsToolWindow is null, however it shouldn't.");
                continue;
            }
            if (!connectedSearchResultsGUI.getVirtualFile().equals(virtualFile)) continue;
            neededContent = content2;
            break;
        }
        if (neededContent == null) {
            return;
        }
        contentManager.removeContent(neededContent, true);
    }

    private static Content tryGetNeededContentFromRangeSearchToolWindow(ToolWindow rangeSearchToolWindow, VirtualFile virtualFile) {
        Content[] contents;
        ContentManager contentManager = rangeSearchToolWindow.getContentManager();
        for (Content content2 : contents = contentManager.getContents()) {
            SearchResultsToolWindow connectedSearchResultsToolWindow = (SearchResultsToolWindow)((Object)content2.getUserData(SearchResultsToolWindow.KEY));
            if (connectedSearchResultsToolWindow == null) {
                logger.warn("connectedSearchResultsToolWindow is null, however it shouldn't.");
                continue;
            }
            if (!connectedSearchResultsToolWindow.getVirtualFile().equals(virtualFile)) continue;
            return content2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchResultsToolWindow", "com/intellij/largeFilesEditor/search/SearchResultsPanelManagerAccessorImpl", "showSearchResultsToolWindow"));
    }
}

