/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.file;

import com.google.common.collect.EvictingQueue;
import com.intellij.largeFilesEditor.editor.Page;
import com.intellij.largeFilesEditor.file.FileAdapter;
import com.intellij.largeFilesEditor.file.FileManager;
import com.intellij.largeFilesEditor.file.ReadingPageResultHandler;
import com.intellij.largeFilesEditor.search.searchTask.FileDataProviderForSearch;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ConcurrencyUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

public class FileManagerImpl
implements FileManager {
    private static final Logger logger = Logger.getInstance(FileManagerImpl.class);
    private static final int MAX_SIZE_OF_PAGE_CASH = 3;
    private FileAdapter fileAdapter;
    private final Queue<Page> notUpdatedPagesCash;
    private final ExecutorService readingPageExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)"Large File Editor Reading File Executor");

    public FileManagerImpl(VirtualFile vFile, int pageSize, int maxPageBorderShift) throws FileNotFoundException {
        this.fileAdapter = new FileAdapter(pageSize, maxPageBorderShift, vFile);
        this.notUpdatedPagesCash = EvictingQueue.create((int)3);
    }

    @Override
    public synchronized void reset(Charset charset) {
        this.notUpdatedPagesCash.clear();
        this.fileAdapter.setCharset(charset);
    }

    @Override
    public void dispose() {
        try {
            this.fileAdapter.closeFile();
        }
        catch (IOException e) {
            logger.warn((Throwable)e);
        }
    }

    @Override
    public String getCharsetName() {
        return this.fileAdapter.getCharsetName();
    }

    @Override
    public long getPagesAmount() throws IOException {
        return this.fileAdapter.getPagesAmount();
    }

    @Override
    public int getPageSize() {
        return this.fileAdapter.getPageSize();
    }

    @Override
    @NotNull
    public synchronized Page getPage_wait(long pageNumber) throws IOException {
        String notUpdatedPageText;
        Page notUpdatedPage = null;
        for (Page page : this.notUpdatedPagesCash) {
            if (page.getPageNumber() != pageNumber) continue;
            notUpdatedPage = page;
        }
        if (notUpdatedPage != null) {
            notUpdatedPageText = notUpdatedPage.getText();
        } else {
            notUpdatedPageText = this.fileAdapter.getPageText(pageNumber);
            notUpdatedPage = new Page(notUpdatedPageText, pageNumber);
            this.notUpdatedPagesCash.add(notUpdatedPage);
        }
        String notUpdatedPageTextWithoutSlashR = FileManagerImpl.destroySlashRSeparators(notUpdatedPageText);
        Page page = new Page(notUpdatedPageTextWithoutSlashR, pageNumber);
        if (page == null) {
            FileManagerImpl.$$$reportNull$$$0(0);
        }
        return page;
    }

    private static String destroySlashRSeparators(String str) {
        return str.replace("\r\n", "\n").replace("\r", "\n");
    }

    @Override
    public boolean hasBOM() {
        if (this.fileAdapter == null) {
            return false;
        }
        VirtualFile vFile = this.fileAdapter.getVirtualFile();
        return vFile.getBOM() != null && vFile.getBOM().length > 0;
    }

    @Override
    public String getFileName() {
        return this.fileAdapter.getFileName();
    }

    @Override
    public FileDataProviderForSearch getFileDataProviderForSearch() {
        return new FileDataProviderForSearch(){

            @Override
            public long getPagesAmount() throws IOException {
                return FileManagerImpl.this.getPagesAmount();
            }

            @Override
            public Page getPage_wait(long pageNumber) throws IOException {
                return FileManagerImpl.this.getPage_wait(pageNumber);
            }

            @Override
            public String getName() {
                return FileManagerImpl.this.getFileName();
            }
        };
    }

    @Override
    public void requestReadPage(long pageNumber, ReadingPageResultHandler readingPageResultHandler) {
        this.readingPageExecutor.execute(() -> {
            try {
                Page page = this.getPage_wait(pageNumber);
                readingPageResultHandler.run(page);
            }
            catch (IOException e) {
                logger.warn((Throwable)e);
                readingPageResultHandler.run(null);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/largeFilesEditor/file/FileManagerImpl", "getPage_wait"));
    }
}

