/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public class FormatTextRange {
    @NotNull
    private TextRange formattingRange;
    private final boolean processHeadingWhitespace;

    public FormatTextRange(@NotNull TextRange range2, boolean processHeadingSpace) {
        if (range2 == null) {
            FormatTextRange.$$$reportNull$$$0(0);
        }
        this.formattingRange = range2;
        this.processHeadingWhitespace = processHeadingSpace;
    }

    public boolean isProcessHeadingWhitespace() {
        return this.processHeadingWhitespace;
    }

    public boolean isWhitespaceReadOnly(@NotNull TextRange range2) {
        if (range2 == null) {
            FormatTextRange.$$$reportNull$$$0(1);
        }
        if (range2.getStartOffset() >= this.formattingRange.getEndOffset()) {
            return true;
        }
        if (this.processHeadingWhitespace && range2.getEndOffset() == this.formattingRange.getStartOffset()) {
            return false;
        }
        return range2.getEndOffset() <= this.formattingRange.getStartOffset();
    }

    public int getStartOffset() {
        return this.formattingRange.getStartOffset();
    }

    public boolean isReadOnly(@NotNull TextRange range2) {
        if (range2 == null) {
            FormatTextRange.$$$reportNull$$$0(2);
        }
        return range2.getStartOffset() > this.formattingRange.getEndOffset() || range2.getEndOffset() < this.formattingRange.getStartOffset();
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.formattingRange;
        if (textRange == null) {
            FormatTextRange.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    public void setTextRange(@NotNull TextRange range2) {
        if (range2 == null) {
            FormatTextRange.$$$reportNull$$$0(4);
        }
        this.formattingRange = range2;
    }

    public TextRange getNonEmptyTextRange() {
        int endOffset = this.formattingRange.getStartOffset() == this.formattingRange.getEndOffset() ? this.formattingRange.getEndOffset() + 1 : this.formattingRange.getEndOffset();
        return new TextRange(this.formattingRange.getStartOffset(), endOffset);
    }

    public String toString() {
        return this.formattingRange.toString() + (this.processHeadingWhitespace ? "+" : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/FormatTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/FormatTextRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isWhitespaceReadOnly";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isReadOnly";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTextRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

