/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.AbstractElementSignatureProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlElementSignatureProvider
extends AbstractElementSignatureProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.XmlElementSignatureProvider");

    public String getSignature(@NotNull PsiElement element) {
        if (element == null) {
            XmlElementSignatureProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            PsiElement parent = tag.getParent();
            StringBuilder buffer = new StringBuilder();
            buffer.append("tag").append("#");
            String name = tag.getName();
            buffer.append(name.length() == 0 ? "<unnamed>" : XmlElementSignatureProvider.escape((String)name));
            buffer.append("#");
            int childIndex = XmlElementSignatureProvider.getChildIndex((PsiNamedElement)tag, (PsiElement)parent, (String)name, XmlTag.class);
            if (childIndex < 0) {
                return null;
            }
            buffer.append(childIndex);
            if (!(parent instanceof PsiFile)) {
                String parentSignature = this.getSignature(parent);
                if (parentSignature == null) {
                    return null;
                }
                buffer.append(";");
                buffer.append(parentSignature);
            }
            return buffer.toString();
        }
        return null;
    }

    protected PsiElement restoreBySignatureTokens(@NotNull PsiFile file, @NotNull PsiElement parent, @NotNull String type, @NotNull StringTokenizer tokenizer, @Nullable StringBuilder processingInfoStorage) {
        if (file == null) {
            XmlElementSignatureProvider.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            XmlElementSignatureProvider.$$$reportNull$$$0(2);
        }
        if (type == null) {
            XmlElementSignatureProvider.$$$reportNull$$$0(3);
        }
        if (tokenizer == null) {
            XmlElementSignatureProvider.$$$reportNull$$$0(4);
        }
        if (type.equals("tag")) {
            String name = tokenizer.nextToken();
            if (parent instanceof XmlFile && (parent = ((XmlFile)parent).getDocument()) == null) {
                return null;
            }
            try {
                int index = Integer.parseInt(tokenizer.nextToken());
                String unescapedName = XmlElementSignatureProvider.unescape((String)name);
                PsiNamedElement result = XmlElementSignatureProvider.restoreElementInternal((PsiElement)parent, (String)unescapedName, (int)index, XmlTag.class);
                if (result == null && file.getFileType() == StdFileTypes.JSP) {
                    if (parent instanceof XmlDocument) {
                        result = XmlElementSignatureProvider.restoreElementInternal((PsiElement)HtmlUtil.getRealXmlDocument((XmlDocument)parent), (String)unescapedName, (int)index, XmlTag.class);
                    } else if (name.equals("<unnamed>") && parent != null) {
                        result = XmlElementSignatureProvider.restoreElementInternal((PsiElement)parent, (String)"", (int)index, XmlTag.class);
                    }
                }
                return result;
            }
            catch (NumberFormatException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/XmlElementSignatureProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSignature";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreBySignatureTokens";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

