/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.common.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import java.util.zip.CRC32;
import org.logstash.common.io.RecordHeader;
import org.logstash.common.io.RecordType;

public final class RecordIOReader
implements Closeable {
    private final FileChannel channel;
    private ByteBuffer currentBlock;
    private int currentBlockSizeReadFromChannel;
    private final Path path;
    private long channelPosition;
    private static final int UNSET = -1;

    public RecordIOReader(Path path) throws IOException {
        this.path = path;
        this.channel = FileChannel.open(path, StandardOpenOption.READ);
        this.currentBlock = ByteBuffer.allocate(32768);
        this.currentBlockSizeReadFromChannel = 0;
        ByteBuffer versionBuffer = ByteBuffer.allocate(1);
        this.channel.read(versionBuffer);
        versionBuffer.rewind();
        byte versionInFile = versionBuffer.get();
        if (versionInFile != 49) {
            this.channel.close();
            throw new RuntimeException(String.format("Invalid version on DLQ data file %s. Expected version: %c. Version found on file: %c", path, Character.valueOf('1'), versionInFile));
        }
        this.channelPosition = this.channel.position();
    }

    public Path getPath() {
        return this.path;
    }

    public void seekToBlock(int bid) throws IOException {
        this.seekToOffset(bid * 32768 + 1);
    }

    public void seekToOffset(long channelOffset) throws IOException {
        this.currentBlock.rewind();
        this.currentBlockSizeReadFromChannel = 0;
        this.channel.position(channelOffset);
        this.channelPosition = this.channel.position();
    }

    public <T> byte[] seekToNextEventPosition(T target, Function<byte[], T> keyExtractor, Comparator<T> keyComparator) throws IOException {
        int matchingBlock = -1;
        int lowBlock = 0;
        int highBlock = (int)(this.channel.size() - 1L) / 32768;
        while (lowBlock < highBlock) {
            int middle = (int)Math.ceil((double)(highBlock + lowBlock) / 2.0);
            this.seekToBlock(middle);
            byte[] readEvent = this.readEvent();
            if (readEvent == null) {
                matchingBlock = lowBlock;
                break;
            }
            T found = keyExtractor.apply(readEvent);
            int compare = keyComparator.compare(found, target);
            if (compare > 0) {
                highBlock = middle - 1;
                continue;
            }
            if (compare < 0) {
                lowBlock = middle;
                continue;
            }
            matchingBlock = middle;
            break;
        }
        if (matchingBlock == -1) {
            matchingBlock = lowBlock;
        }
        this.seekToBlock(matchingBlock);
        int compare = -1;
        byte[] event = null;
        BufferState restorePoint = null;
        while (compare < 0) {
            restorePoint = this.saveBufferState();
            event = this.readEvent();
            if (event == null) {
                return null;
            }
            compare = keyComparator.compare(keyExtractor.apply(event), target);
        }
        if (restorePoint != null) {
            this.restoreFrom(restorePoint);
        }
        return event;
    }

    public long getChannelPosition() {
        return this.channelPosition;
    }

    void consumeBlock(boolean rewind) throws IOException {
        if (rewind) {
            this.currentBlockSizeReadFromChannel = 0;
            this.currentBlock.rewind();
        } else if (this.currentBlockSizeReadFromChannel == 32768) {
            return;
        }
        int processedPosition = this.currentBlock.position();
        try {
            this.currentBlock.position(this.currentBlockSizeReadFromChannel);
            this.channel.read(this.currentBlock);
            this.currentBlockSizeReadFromChannel = this.currentBlock.position();
        }
        finally {
            this.currentBlock.position(processedPosition);
        }
    }

    public boolean isEndOfStream() {
        return this.currentBlockSizeReadFromChannel < 32768;
    }

    int seekToStartOfEventInBlock() {
        block3: {
            if (this.currentBlock.position() >= this.currentBlockSizeReadFromChannel) {
                return -1;
            }
            do {
                RecordType type;
                if (RecordType.COMPLETE.equals((Object)(type = RecordType.fromByte(this.currentBlock.array()[this.currentBlock.arrayOffset() + this.currentBlock.position()]))) || RecordType.START.equals((Object)type)) {
                    return this.currentBlock.position();
                }
                if (!RecordType.END.equals((Object)type)) break block3;
                RecordHeader header = RecordHeader.get(this.currentBlock);
                this.currentBlock.position(this.currentBlock.position() + header.getSize());
            } while (!this.isEndOfStream());
            return -1;
        }
        return -1;
    }

    boolean consumeToStartOfEvent() throws IOException {
        int eventStartPosition;
        this.consumeBlock(false);
        while ((eventStartPosition = this.seekToStartOfEventInBlock()) < 0) {
            if (this.isEndOfStream()) {
                return false;
            }
            this.consumeBlock(true);
        }
        return true;
    }

    private void maybeRollToNextBlock() throws IOException {
        if (this.currentBlock.remaining() < 14) {
            this.consumeBlock(true);
        }
    }

    private void getRecord(ByteBuffer buffer, RecordHeader header) {
        CRC32 computedChecksum = new CRC32();
        computedChecksum.update(this.currentBlock.array(), this.currentBlock.position(), header.getSize());
        if ((int)computedChecksum.getValue() != header.getChecksum()) {
            throw new RuntimeException("invalid checksum of record");
        }
        buffer.put(this.currentBlock.array(), this.currentBlock.position(), header.getSize());
        this.currentBlock.position(this.currentBlock.position() + header.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readEvent() throws IOException {
        try {
            if (!this.channel.isOpen() || !this.consumeToStartOfEvent()) {
                byte[] byArray = null;
                return byArray;
            }
            RecordHeader header = RecordHeader.get(this.currentBlock);
            int cumReadSize = 0;
            int bufferSize = header.getTotalEventSize().orElseGet(header::getSize);
            ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
            this.getRecord(buffer, header);
            cumReadSize += header.getSize();
            while (cumReadSize < bufferSize) {
                this.maybeRollToNextBlock();
                RecordHeader nextHeader = RecordHeader.get(this.currentBlock);
                this.getRecord(buffer, nextHeader);
                cumReadSize += nextHeader.getSize();
            }
            byte[] byArray = buffer.array();
            return byArray;
        }
        catch (ClosedByInterruptException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (this.channel.isOpen()) {
                this.channelPosition = this.channel.position();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    private BufferState saveBufferState() throws IOException {
        return new BufferState.Builder().channelPosition(this.channel.position()).blockContents(Arrays.copyOf(this.currentBlock.array(), this.currentBlock.array().length)).currentBlockPosition(this.currentBlock.position()).currentBlockSizeReadFromChannel(this.currentBlockSizeReadFromChannel).build();
    }

    private void restoreFrom(BufferState bufferState) throws IOException {
        this.currentBlock = ByteBuffer.wrap(bufferState.blockContents);
        this.currentBlock.position(bufferState.currentBlockPosition);
        this.channel.position(bufferState.channelPosition);
        this.channelPosition = this.channel.position();
        this.currentBlockSizeReadFromChannel = bufferState.currentBlockSizeReadFromChannel;
    }

    static final class BufferState {
        private int currentBlockPosition;
        private int currentBlockSizeReadFromChannel;
        private long channelPosition;
        private byte[] blockContents;

        BufferState(Builder builder) {
            this.currentBlockPosition = builder.currentBlockPosition;
            this.currentBlockSizeReadFromChannel = builder.currentBlockSizeReadFromChannel;
            this.channelPosition = builder.channelPosition;
            this.blockContents = builder.blockContents;
        }

        public String toString() {
            return String.format("CurrentBlockPosition:%d, currentBlockSizeReadFromChannel: %d, channelPosition: %d", this.currentBlockPosition, this.currentBlockSizeReadFromChannel, this.channelPosition);
        }

        static final class Builder {
            private int currentBlockPosition;
            private int currentBlockSizeReadFromChannel;
            private long channelPosition;
            private byte[] blockContents;

            Builder() {
            }

            Builder currentBlockPosition(int currentBlockPosition) {
                this.currentBlockPosition = currentBlockPosition;
                return this;
            }

            Builder currentBlockSizeReadFromChannel(int currentBlockSizeReadFromChannel) {
                this.currentBlockSizeReadFromChannel = currentBlockSizeReadFromChannel;
                return this;
            }

            Builder channelPosition(long channelPosition) {
                this.channelPosition = channelPosition;
                return this;
            }

            Builder blockContents(byte[] blockContents) {
                this.blockContents = blockContents;
                return this;
            }

            BufferState build() {
                return new BufferState(this);
            }
        }
    }
}

