/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public class LongParagraphRule
extends TextLevelRule {
    public static final String RULE_ID = "TOO_LONG_PARAGRAPH";
    private static final int DEFAULT_MAX_WORDS = 80;
    private static final boolean DEFAULT_ACTIVATION = false;
    protected int maxWords = 80;
    private final Language lang;

    public LongParagraphRule(ResourceBundle messages, Language lang, UserConfig userConfig, int defaultWords, boolean defaultActive) {
        super(messages);
        int confWords;
        super.setCategory(new Category(new CategoryId("CREATIVE_WRITING"), messages.getString("category_creative_writing"), Category.Location.INTERNAL, false));
        this.lang = lang;
        if (!defaultActive) {
            this.setDefaultOff();
        }
        if (defaultWords > 0) {
            this.maxWords = defaultWords;
        }
        if (userConfig != null && (confWords = userConfig.getConfigValueByID(this.getId())) > 0) {
            this.maxWords = confWords;
        }
        this.setLocQualityIssueType(ITSIssueType.Style);
    }

    public LongParagraphRule(ResourceBundle messages, Language lang, UserConfig userConfig, int defaultWords) {
        this(messages, lang, userConfig, defaultWords, false);
    }

    public LongParagraphRule(ResourceBundle messages, Language lang, UserConfig userConfig) {
        this(messages, lang, userConfig, -1, false);
    }

    @Override
    public String getDescription() {
        return MessageFormat.format(this.messages.getString("long_paragraph_rule_desc"), this.maxWords);
    }

    @Override
    public String getId() {
        return RULE_ID;
    }

    @Override
    public int getDefaultValue() {
        return this.maxWords;
    }

    @Override
    public boolean hasConfigurableValue() {
        return true;
    }

    @Override
    public int getMinConfigurableValue() {
        return 5;
    }

    @Override
    public int getMaxConfigurableValue() {
        return 200;
    }

    @Override
    public String getConfigureText() {
        return this.messages.getString("guiLongParagraphsText");
    }

    public String getMessage() {
        return MessageFormat.format(this.messages.getString("long_paragraph_rule_msg"), this.maxWords);
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        String msg = this.getMessage();
        int pos = 0;
        int startPos = 0;
        int endPos = 0;
        int wordCount = 0;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens;
            for (AnalyzedTokenReadings token : tokens = sentence.getTokensWithoutWhitespace()) {
                if (token.isWhitespace() || token.isSentenceStart() || token.isNonWord()) continue;
                if (++wordCount == 1) {
                    startPos = token.getStartPos() + pos;
                    continue;
                }
                if (wordCount != this.maxWords) continue;
                endPos = token.getEndPos() + pos;
            }
            if (sentence.hasParagraphEndMark(this.lang)) {
                if (wordCount > this.maxWords) {
                    RuleMatch ruleMatch = new RuleMatch(this, sentence, startPos, endPos, msg);
                    ruleMatches.add(ruleMatch);
                }
                wordCount = 0;
            }
            pos += sentence.getText().length();
        }
        if (wordCount > this.maxWords) {
            RuleMatch ruleMatch = new RuleMatch(this, startPos, endPos, msg);
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public int minToCheckParagraph() {
        return 0;
    }
}

