"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceMarkWithReactDom = replaceMarkWithReactDom;
exports.convertAngularHtml = convertAngularHtml;
exports.arrayContainsObjects = arrayContainsObjects;
exports.formatValue = formatValue;

var _react = _interopRequireDefault(require("react"));

var _lodash = require("lodash");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

/**
 * Convert <mark> markup of the given string to ReactNodes
 * @param text
 */
function replaceMarkWithReactDom(text) {
  return _react.default.createElement(_react.default.Fragment, null, text.split('<mark>').map(function (markedText, idx) {
    var sub = markedText.split('</mark>');

    if (sub.length === 1) {
      return markedText;
    }

    return _react.default.createElement("span", {
      key: idx
    }, _react.default.createElement("mark", null, sub[0]), sub[1]);
  }));
}
/**
 * Current html of the formatter is angular flavored, this current workaround
 * should be removed when all consumers of the formatHit function are react based
 */


function convertAngularHtml(html) {
  if (typeof html === 'string') {
    var cleaned = html.replace('<span ng-non-bindable>', '').replace('</span>', '');
    var unescaped = (0, _lodash.unescape)(cleaned);

    if (unescaped.indexOf('<mark>') !== -1) {
      return replaceMarkWithReactDom(unescaped);
    }

    return unescaped;
  }

  return html;
}
/**
 * Returns true if the given array contains at least 1 object
 */


function arrayContainsObjects(value) {
  return Array.isArray(value) && value.some(function (v) {
    return _typeof(v) === 'object' && v !== null;
  });
}
/**
 * The current field formatter provides html for angular usage
 * This html is cleaned up and prepared for usage in the react world
 * Furthermore <mark>test</mark> are converted to ReactNodes
 */


function formatValue(value, valueFormatted) {
  if (Array.isArray(value) && arrayContainsObjects(value)) {
    return value.map(function (v) {
      return JSON.stringify(v, null, 2);
    }).join('\n');
  } else if (Array.isArray(value)) {
    return value.join(', ');
  } else if (_typeof(value) === 'object' && value !== null) {
    return JSON.stringify(value, null, 2);
  } else {
    return typeof valueFormatted === 'string' ? convertAngularHtml(valueFormatted) : String(value);
  }
}