"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_GLOBAL_ID = '__global__';
exports.HistogramModeAlignments = Object.freeze({
    Start: 'start',
    Center: 'center',
    End: 'end',
});
/**
 * The position of the axis relative to the chart.
 * A left or right positioned axis is a vertical axis.
 * A top or bottom positioned axis is an horizontal axis.
 */
exports.Position = Object.freeze({
    Top: 'top',
    Bottom: 'bottom',
    Left: 'left',
    Right: 'right',
});
exports.AnnotationTypes = Object.freeze({
    Line: 'line',
    Rectangle: 'rectangle',
    Text: 'text',
});
exports.AnnotationDomainTypes = Object.freeze({
    XDomain: 'xDomain',
    YDomain: 'yDomain',
});
function isLineAnnotation(spec) {
    return spec.annotationType === exports.AnnotationTypes.Line;
}
exports.isLineAnnotation = isLineAnnotation;
function isRectAnnotation(spec) {
    return spec.annotationType === exports.AnnotationTypes.Rectangle;
}
exports.isRectAnnotation = isRectAnnotation;
function isBarSeriesSpec(spec) {
    return spec.seriesType === 'bar';
}
exports.isBarSeriesSpec = isBarSeriesSpec;
function isLineSeriesSpec(spec) {
    return spec.seriesType === 'line';
}
exports.isLineSeriesSpec = isLineSeriesSpec;
function isAreaSeriesSpec(spec) {
    return spec.seriesType === 'area';
}
exports.isAreaSeriesSpec = isAreaSeriesSpec;
//# sourceMappingURL=specs.js.map