/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.ServiceLoader;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.JGroupsTransportServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.SiteServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceNameRegistry;
import org.wildfly.clustering.spi.CapabilityServiceNameRegistry;
import org.wildfly.clustering.spi.IdentityGroupServiceConfiguratorProvider;

public class JGroupsTransportServiceHandler
implements ResourceServiceHandler {
    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress containerAddress = address.getParent();
        String name = containerAddress.getLastElement().getValue();
        ServiceTarget target = context.getServiceTarget();
        JGroupsTransportServiceConfigurator transportBuilder = new JGroupsTransportServiceConfigurator(address).configure(context, model);
        transportBuilder.build(target).install();
        new SiteServiceConfigurator(address).configure(context, model).build(target).install();
        String channel = transportBuilder.getChannel();
        CapabilityServiceNameRegistry registry = new CapabilityServiceNameRegistry(TransportResourceDefinition.CLUSTERING_CAPABILITIES, address);
        for (IdentityGroupServiceConfiguratorProvider provider : ServiceLoader.load(IdentityGroupServiceConfiguratorProvider.class, IdentityGroupServiceConfiguratorProvider.class.getClassLoader())) {
            for (CapabilityServiceConfigurator configurator : provider.getServiceConfigurators((ServiceNameRegistry)registry, name, channel)) {
                configurator.configure(context).build(target).install();
            }
        }
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress containerAddress = address.getParent();
        String name = containerAddress.getLastElement().getValue();
        CapabilityServiceNameRegistry registry = new CapabilityServiceNameRegistry(TransportResourceDefinition.CLUSTERING_CAPABILITIES, address);
        for (IdentityGroupServiceConfiguratorProvider provider : ServiceLoader.load(IdentityGroupServiceConfiguratorProvider.class, IdentityGroupServiceConfiguratorProvider.class.getClassLoader())) {
            for (ServiceNameProvider configurator : provider.getServiceConfigurators((ServiceNameRegistry)registry, name, null)) {
                context.removeService(configurator.getServiceName());
            }
        }
        for (CacheContainerComponent component : EnumSet.allOf(CacheContainerComponent.class)) {
            context.removeService(component.getServiceName(address));
        }
    }
}

