/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.as.clustering.controller.Definable;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modcluster.ModClusterServiceMBean;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.service.ActiveServiceSupplier;
import org.wildfly.extension.mod_cluster.LegacyMetricOperationsRegistration;
import org.wildfly.extension.mod_cluster.ModClusterExtension;
import org.wildfly.extension.mod_cluster.ModClusterLogger;
import org.wildfly.extension.mod_cluster.ModClusterModel;
import org.wildfly.extension.mod_cluster.ProxyConfigurationResourceDefinition;
import org.wildfly.extension.mod_cluster.ProxyOperation;
import org.wildfly.extension.mod_cluster.ProxyOperationExecutor;

@Deprecated
public enum LegacyProxyOperation implements Definable<OperationDefinition>,
OperationStepHandler
{
    ADD_PROXY{

        public OperationDefinition getDefinition() {
            return new SimpleOperationDefinitionBuilder(ProxyOperation.ADD_PROXY.getName(), (ResourceDescriptionResolver)ModClusterExtension.SUBSYSTEM_RESOLVER).addParameter((AttributeDefinition)ProxyOperationExecutor.HOST).addParameter((AttributeDefinition)ProxyOperationExecutor.PORT).setRuntimeOnly().addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF).setDeprecated(ModClusterModel.VERSION_6_0_0.getVersion()).build();
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isNormalServer() && LegacyProxyOperation.getService(context) != null) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        final ModClusterServiceMBean service = LegacyProxyOperation.getService(context);
                        ModClusterLogger.ROOT_LOGGER.debugf("add-proxy: %s", operation);
                        final String host = ProxyOperationExecutor.HOST.resolveModelAttribute(context, operation).asString();
                        final int port = ProxyOperationExecutor.PORT.resolveModelAttribute(context, operation).asInt();
                        try {
                            InetAddress.getByName(host);
                        }
                        catch (UnknownHostException e) {
                            throw new OperationFailedException(ModClusterLogger.ROOT_LOGGER.couldNotResolveProxyIpAddress(), (Throwable)e);
                        }
                        service.addProxy(host, port);
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                service.removeProxy(host, port);
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
    }
    ,
    DISABLE{

        public OperationDefinition getDefinition() {
            return new SimpleOperationDefinitionBuilder(ProxyOperation.DISABLE.getName(), (ResourceDescriptionResolver)ModClusterExtension.SUBSYSTEM_RESOLVER).setRuntimeOnly().setDeprecated(ModClusterModel.VERSION_6_0_0.getVersion()).build();
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isNormalServer() && LegacyProxyOperation.getService(context) != null) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        final ModClusterServiceMBean service = LegacyProxyOperation.getService(context);
                        service.disable();
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                service.enable();
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
    }
    ,
    DISABLE_CONTEXT{

        public OperationDefinition getDefinition() {
            return new SimpleOperationDefinitionBuilder(ProxyOperation.DISABLE_CONTEXT.getName(), (ResourceDescriptionResolver)ModClusterExtension.SUBSYSTEM_RESOLVER).addParameter((AttributeDefinition)ProxyOperationExecutor.VIRTUAL_HOST).addParameter((AttributeDefinition)ProxyOperationExecutor.CONTEXT).setRuntimeOnly().setDeprecated(ModClusterModel.VERSION_6_0_0.getVersion()).build();
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isNormalServer() && LegacyProxyOperation.getService(context) != null) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        final ModClusterServiceMBean service = LegacyProxyOperation.getService(context);
                        ModClusterLogger.ROOT_LOGGER.debugf("disable-context: %s", operation);
                        final String webHost = ProxyOperationExecutor.VIRTUAL_HOST.resolveModelAttribute(context, operation).asString();
                        final String webContext = ProxyOperationExecutor.CONTEXT.resolveModelAttribute(context, operation).asString();
                        try {
                            service.disableContext(webHost, webContext);
                        }
                        catch (IllegalArgumentException e) {
                            throw new OperationFailedException(ModClusterLogger.ROOT_LOGGER.contextOrHostNotFound(webHost, webContext));
                        }
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                service.enableContext(webHost, webContext);
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
    }
    ,
    ENABLE{

        public OperationDefinition getDefinition() {
            return new SimpleOperationDefinitionBuilder(ProxyOperation.ENABLE.getName(), (ResourceDescriptionResolver)ModClusterExtension.SUBSYSTEM_RESOLVER).setRuntimeOnly().setDeprecated(ModClusterModel.VERSION_6_0_0.getVersion()).build();
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isNormalServer() && LegacyProxyOperation.getService(context) != null) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        final ModClusterServiceMBean service = LegacyProxyOperation.getService(context);
                        service.enable();
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                service.disable();
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
    }
    ,
    ENABLE_CONTEXT{

        public OperationDefinition getDefinition() {
            return new SimpleOperationDefinitionBuilder(ProxyOperation.ENABLE_CONTEXT.getName(), (ResourceDescriptionResolver)ModClusterExtension.SUBSYSTEM_RESOLVER).addParameter((AttributeDefinition)ProxyOperationExecutor.VIRTUAL_HOST).addParameter((AttributeDefinition)ProxyOperationExecutor.CONTEXT).setRuntimeOnly().setDeprecated(ModClusterModel.VERSION_6_0_0.getVersion()).build();
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isNormalServer() && LegacyProxyOperation.getService(context) != null) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        final ModClusterServiceMBean service = LegacyProxyOperation.getService(context);
                        ModClusterLogger.ROOT_LOGGER.debugf("enable-context: %s", operation);
                        final String webHost = ProxyOperationExecutor.VIRTUAL_HOST.resolveModelAttribute(context, operation).asString();
                        final String webContext = ProxyOperationExecutor.CONTEXT.resolveModelAttribute(context, operation).asString();
                        try {
                            service.enableContext(webHost, webContext);
                        }
                        catch (IllegalArgumentException e) {
                            throw new OperationFailedException(ModClusterLogger.ROOT_LOGGER.contextOrHostNotFound(webHost, webContext));
                        }
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                service.disableContext(webHost, webContext);
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
    }
    ,
    LIST_PROXIES{

        public OperationDefinition getDefinition() {
            return new SimpleOperationDefinitionBuilder(ProxyOperation.LIST_PROXIES.getName(), (ResourceDescriptionResolver)ModClusterExtension.SUBSYSTEM_RESOLVER).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF).setDeprecated(ModClusterModel.VERSION_6_0_0.getVersion()).build();
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isNormalServer() && LegacyProxyOperation.getService(context) != null) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        ModClusterServiceMBean service = LegacyProxyOperation.getService(context);
                        Map map = service.getProxyInfo();
                        ModClusterLogger.ROOT_LOGGER.debugf("Mod_cluster ListProxies %s", map);
                        if (!map.isEmpty()) {
                            InetSocketAddress[] addr;
                            ModelNode result = new ModelNode();
                            for (InetSocketAddress address : addr = map.keySet().toArray(new InetSocketAddress[map.size()])) {
                                result.add(address.getHostName() + ":" + address.getPort());
                            }
                            context.getResult().set(result);
                        }
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
    }
    ,
    READ_PROXIES_CONFIGURATION{

        public OperationDefinition getDefinition() {
            return new SimpleOperationDefinitionBuilder(ProxyOperation.READ_PROXIES_CONFIGURATION.getName(), (ResourceDescriptionResolver)ModClusterExtension.SUBSYSTEM_RESOLVER).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF).setDeprecated(ModClusterModel.VERSION_6_0_0.getVersion()).build();
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isNormalServer() && LegacyProxyOperation.getService(context) != null) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        ModClusterServiceMBean service = LegacyProxyOperation.getService(context);
                        Map map = service.getProxyConfiguration();
                        ModClusterLogger.ROOT_LOGGER.debugf("Mod_cluster ProxyConfiguration %s", map);
                        if (!map.isEmpty()) {
                            ModelNode result = new ModelNode();
                            for (Map.Entry entry : map.entrySet()) {
                                result.add(((InetSocketAddress)entry.getKey()).getHostName() + ":" + ((InetSocketAddress)entry.getKey()).getPort());
                                if (entry.getValue() == null) {
                                    result.add();
                                    continue;
                                }
                                result.add((String)entry.getValue());
                            }
                            context.getResult().set(result);
                        }
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
    }
    ,
    READ_PROXIES_INFO{

        public OperationDefinition getDefinition() {
            return new SimpleOperationDefinitionBuilder(ProxyOperation.READ_PROXIES_INFO.getName(), (ResourceDescriptionResolver)ModClusterExtension.SUBSYSTEM_RESOLVER).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF).setDeprecated(ModClusterModel.VERSION_6_0_0.getVersion()).build();
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isNormalServer() && LegacyProxyOperation.getService(context) != null) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        ModClusterServiceMBean service = LegacyProxyOperation.getService(context);
                        Map map = service.getProxyInfo();
                        ModClusterLogger.ROOT_LOGGER.debugf("Mod_cluster ProxyInfo %s", map);
                        if (!map.isEmpty()) {
                            ModelNode result = new ModelNode();
                            for (Map.Entry entry : map.entrySet()) {
                                result.add(((InetSocketAddress)entry.getKey()).getHostName() + ":" + ((InetSocketAddress)entry.getKey()).getPort());
                                if (entry.getValue() == null) {
                                    result.add();
                                    continue;
                                }
                                result.add((String)entry.getValue());
                            }
                            context.getResult().set(result);
                        }
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
    }
    ,
    REFRESH{

        public OperationDefinition getDefinition() {
            return new SimpleOperationDefinitionBuilder(ProxyOperation.REFRESH.getName(), (ResourceDescriptionResolver)ModClusterExtension.SUBSYSTEM_RESOLVER).setRuntimeOnly().setDeprecated(ModClusterModel.VERSION_6_0_0.getVersion()).build();
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isNormalServer() && LegacyProxyOperation.getService(context) != null) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        ModClusterServiceMBean service = LegacyProxyOperation.getService(context);
                        service.refresh();
                        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
    }
    ,
    REMOVE_PROXY{

        public OperationDefinition getDefinition() {
            return new SimpleOperationDefinitionBuilder(ProxyOperation.REMOVE_PROXY.getName(), (ResourceDescriptionResolver)ModClusterExtension.SUBSYSTEM_RESOLVER).addParameter((AttributeDefinition)ProxyOperationExecutor.HOST).addParameter((AttributeDefinition)ProxyOperationExecutor.PORT).setRuntimeOnly().addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF).setDeprecated(ModClusterModel.VERSION_6_0_0.getVersion()).build();
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isNormalServer() && LegacyProxyOperation.getService(context) != null) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        final ModClusterServiceMBean service = LegacyProxyOperation.getService(context);
                        ModClusterLogger.ROOT_LOGGER.debugf("remove-proxy: %s", operation);
                        final String host = ProxyOperationExecutor.HOST.resolveModelAttribute(context, operation).asString();
                        final int port = ProxyOperationExecutor.PORT.resolveModelAttribute(context, operation).asInt();
                        try {
                            InetAddress.getByName(host);
                        }
                        catch (UnknownHostException e) {
                            throw new OperationFailedException(ModClusterLogger.ROOT_LOGGER.couldNotResolveProxyIpAddress(), (Throwable)e);
                        }
                        service.removeProxy(host, port);
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                service.addProxy(host, port);
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
    }
    ,
    RESET{

        public OperationDefinition getDefinition() {
            return new SimpleOperationDefinitionBuilder(ProxyOperation.RESET.getName(), (ResourceDescriptionResolver)ModClusterExtension.SUBSYSTEM_RESOLVER).setRuntimeOnly().setDeprecated(ModClusterModel.VERSION_6_0_0.getVersion()).build();
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isNormalServer() && LegacyProxyOperation.getService(context) != null) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        ModClusterServiceMBean service = LegacyProxyOperation.getService(context);
                        service.reset();
                        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
    }
    ,
    STOP{

        public OperationDefinition getDefinition() {
            return new SimpleOperationDefinitionBuilder(ProxyOperation.STOP.getName(), (ResourceDescriptionResolver)ModClusterExtension.SUBSYSTEM_RESOLVER).addParameter((AttributeDefinition)ProxyOperationExecutor.WAIT_TIME).setRuntimeOnly().setDeprecated(ModClusterModel.VERSION_6_0_0.getVersion()).build();
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isNormalServer() && LegacyProxyOperation.getService(context) != null) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        final ModClusterServiceMBean service = LegacyProxyOperation.getService(context);
                        ModClusterLogger.ROOT_LOGGER.debugf("stop: %s", operation);
                        int waitTime = ProxyOperationExecutor.WAIT_TIME.resolveModelAttribute(context, operation).asInt();
                        boolean success = service.stop((long)waitTime, TimeUnit.SECONDS);
                        context.getResult().get(LegacyProxyOperation.SESSION_DRAINING_COMPLETE).set(success);
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                service.enable();
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
    }
    ,
    STOP_CONTEXT{

        public OperationDefinition getDefinition() {
            return new SimpleOperationDefinitionBuilder(ProxyOperation.STOP_CONTEXT.getName(), (ResourceDescriptionResolver)ModClusterExtension.SUBSYSTEM_RESOLVER).addParameter((AttributeDefinition)ProxyOperationExecutor.VIRTUAL_HOST).addParameter((AttributeDefinition)ProxyOperationExecutor.CONTEXT).addParameter((AttributeDefinition)ProxyOperationExecutor.WAIT_TIME).setRuntimeOnly().setDeprecated(ModClusterModel.VERSION_6_0_0.getVersion()).build();
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isNormalServer() && LegacyProxyOperation.getService(context) != null) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        final ModClusterServiceMBean service = LegacyProxyOperation.getService(context);
                        ModClusterLogger.ROOT_LOGGER.debugf("stop-context: %s", operation);
                        final String webHost = ProxyOperationExecutor.VIRTUAL_HOST.resolveModelAttribute(context, operation).asString();
                        final String webContext = ProxyOperationExecutor.CONTEXT.resolveModelAttribute(context, operation).asString();
                        int waitTime = ProxyOperationExecutor.WAIT_TIME.resolveModelAttribute(context, operation).asInt();
                        try {
                            boolean success = service.stopContext(webHost, webContext, (long)waitTime, TimeUnit.SECONDS);
                            context.getResult().get(LegacyProxyOperation.SESSION_DRAINING_COMPLETE).set(success);
                        }
                        catch (IllegalArgumentException e) {
                            throw new OperationFailedException(ModClusterLogger.ROOT_LOGGER.contextOrHostNotFound(webHost, webContext));
                        }
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                service.enableContext(webHost, webContext);
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
    };

    static final String SESSION_DRAINING_COMPLETE = "session-draining-complete";

    private static ModClusterServiceMBean getService(OperationContext context) throws OperationFailedException {
        PathAddress proxyAddress = LegacyMetricOperationsRegistration.translateProxyPath(context, context.getCurrentAddress());
        ServiceName serviceName = ProxyConfigurationResourceDefinition.Capability.SERVICE.getServiceName(proxyAddress);
        return (ModClusterServiceMBean)new ActiveServiceSupplier(context.getServiceRegistry(true), serviceName).get();
    }
}

