/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.internal.restclient.capability.resources.AbstractOpenShiftBinaryCapability;
import com.openshift.restclient.IClient;
import com.openshift.restclient.capability.IBinaryCapability;
import com.openshift.restclient.capability.resources.IPodLogRetrieval;
import com.openshift.restclient.model.IPod;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftBinaryPodLogRetrieval
implements IPodLogRetrieval {
    private static final Logger LOG = LoggerFactory.getLogger(IPodLogRetrieval.class);
    private IPod pod;
    private IClient client;
    private Map<String, PodLogs> cache = new HashMap<String, PodLogs>();

    public OpenShiftBinaryPodLogRetrieval(IPod pod, IClient client) {
        this.pod = pod;
        this.client = client;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getName() {
        return OpenShiftBinaryPodLogRetrieval.class.getSimpleName();
    }

    @Override
    public InputStream getLogs(boolean follow, IBinaryCapability.OpenShiftBinaryOption ... options) {
        return this.getLogs(follow, (String)null, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getLogs(boolean follow, String container, IBinaryCapability.OpenShiftBinaryOption ... options) {
        String normalizedContainer = StringUtils.defaultIfBlank((String)container, (String)"");
        Map<String, PodLogs> map = this.cache;
        synchronized (map) {
            InputStream inputStream;
            block8: {
                if (this.cache.containsKey(normalizedContainer)) {
                    return this.cache.get(normalizedContainer).getLogs();
                }
                PodLogs logs = null;
                try {
                    logs = new PodLogs(this.client, follow, normalizedContainer, options);
                    inputStream = logs.getLogs();
                    if (logs == null) break block8;
                    this.cache.put(normalizedContainer, logs);
                }
                catch (Throwable throwable) {
                    if (logs != null) {
                        this.cache.put(normalizedContainer, logs);
                    }
                    throw throwable;
                }
            }
            return inputStream;
        }
    }

    @Override
    public void stop() {
        new ArrayList<String>(this.cache.keySet()).forEach(container -> this.stop((String)container));
    }

    @Override
    public synchronized void stop(String container) {
        if (!this.cache.containsKey(container)) {
            return;
        }
        try {
            PodLogs logs = this.cache.remove(container);
            logs.stop();
        }
        catch (Exception e) {
            LOG.warn("Unable to stop pod logs", (Throwable)e);
        }
    }

    protected class PodLogs
    extends AbstractOpenShiftBinaryCapability {
        public static final String LOGS_COMMAND = "logs";
        private String container;
        private boolean follow;
        private SequenceInputStream is;
        private IBinaryCapability.OpenShiftBinaryOption[] options;

        protected PodLogs(IClient client, boolean follow, String container, IBinaryCapability.OpenShiftBinaryOption ... options) {
            super(client);
            this.follow = follow;
            this.container = container;
            this.options = options;
        }

        public synchronized InputStream getLogs() {
            Process process;
            if (this.is == null && (process = this.start(this.options)) != null) {
                this.is = new SequenceInputStream(process.getInputStream(), process.getErrorStream());
            }
            return this.is;
        }

        @Override
        public boolean isSupported() {
            return true;
        }

        @Override
        public String getName() {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cleanup() {
            this.follow = false;
            if (this.getProcess() != null) {
                IOUtils.closeQuietly((InputStream)this.getProcess().getInputStream());
                IOUtils.closeQuietly((InputStream)this.getProcess().getErrorStream());
            }
            Map map = OpenShiftBinaryPodLogRetrieval.this.cache;
            synchronized (map) {
                OpenShiftBinaryPodLogRetrieval.this.cache.remove(this.container);
            }
        }

        @Override
        protected boolean validate() {
            return true;
        }

        @Override
        protected String buildArgs(List<IBinaryCapability.OpenShiftBinaryOption> options) {
            AbstractOpenShiftBinaryCapability.CommandLineBuilder builder = new AbstractOpenShiftBinaryCapability.CommandLineBuilder(LOGS_COMMAND).append(new AbstractOpenShiftBinaryCapability.Token(OpenShiftBinaryPodLogRetrieval.this.client)).append(new AbstractOpenShiftBinaryCapability.Server(OpenShiftBinaryPodLogRetrieval.this.client)).append(options).append(new PodName(OpenShiftBinaryPodLogRetrieval.this.pod)).append(new AbstractOpenShiftBinaryCapability.Namespace(OpenShiftBinaryPodLogRetrieval.this.pod));
            if (this.follow) {
                builder.append(new Follow());
            }
            if (StringUtils.isNotBlank((String)this.container)) {
                builder.append(new ContainerName(this.container));
            }
            return builder.build();
        }
    }

    static class Follow
    implements IBinaryCapability.OpenShiftBinaryOption {
        Follow() {
        }

        @Override
        public void append(StringBuilder commandLine) {
            commandLine.append(" -f");
        }
    }

    static class ContainerName
    implements IBinaryCapability.OpenShiftBinaryOption {
        private String name;

        public ContainerName(String name) {
            this.name = name;
        }

        @Override
        public void append(StringBuilder commandLine) {
            commandLine.append(" -c ").append(this.name);
        }
    }

    static class PodName
    implements IBinaryCapability.OpenShiftBinaryOption {
        private IPod pod;

        public PodName(IPod pod) {
            this.pod = pod;
        }

        @Override
        public void append(StringBuilder commandLine) {
            if (this.pod == null) {
                return;
            }
            commandLine.append(" ").append(this.pod.getName());
        }
    }
}

