/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import org.jboss.logging.Logger;
import org.keycloak.models.LDAPConstants;
import org.keycloak.services.ServicesLogger;

public class LDAPConnectionTestManager {
    private static final Logger logger = Logger.getLogger(LDAPConnectionTestManager.class);
    public static final String TEST_CONNECTION = "testConnection";
    public static final String TEST_AUTHENTICATION = "testAuthentication";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testLDAP(String action, String connectionUrl, String bindDn, String bindCredential, String useTruststoreSpi, String connectionTimeout, String tls) {
        if (!TEST_CONNECTION.equals(action) && !TEST_AUTHENTICATION.equals(action)) {
            ServicesLogger.LOGGER.unknownAction(action);
            return false;
        }
        InitialContext ldapContext = null;
        try {
            char[] bindCredentialChar3;
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            if (connectionUrl == null) {
                logger.errorf("Unknown connection URL", new Object[0]);
                boolean bl = false;
                return bl;
            }
            env.put("java.naming.provider.url", connectionUrl);
            LDAPConstants.setTruststoreSpiIfNeeded((String)useTruststoreSpi, (String)connectionUrl, env);
            if (connectionTimeout != null && !connectionTimeout.isEmpty()) {
                env.put("com.sun.jndi.ldap.connect.timeout", connectionTimeout);
            }
            if (tls != null && Boolean.parseBoolean(tls)) {
                ldapContext = new InitialLdapContext(env, null);
                try {
                    StartTlsResponse tlsResponse = (StartTlsResponse)((InitialLdapContext)ldapContext).extendedOperation(new StartTlsRequest());
                    tlsResponse.negotiate();
                }
                catch (Exception e) {
                    logger.error((Object)"Could not negotiate TLS", (Throwable)e);
                }
                if (TEST_AUTHENTICATION.equals(action)) {
                    ldapContext.addToEnvironment("java.naming.security.authentication", "simple");
                    if (bindDn == null) {
                        logger.error((Object)"Unknown bind DN");
                        boolean e = false;
                        return e;
                    }
                    ldapContext.addToEnvironment("java.naming.security.principal", bindDn);
                    bindCredentialChar3 = null;
                    if (bindCredential != null) {
                        bindCredentialChar3 = bindCredential.toCharArray();
                    }
                    ldapContext.addToEnvironment("java.naming.security.credentials", bindCredentialChar3);
                    ldapContext.lookup("");
                }
            } else {
                if (TEST_AUTHENTICATION.equals(action)) {
                    env.put("java.naming.security.authentication", "simple");
                    if (bindDn == null) {
                        logger.error((Object)"Unknown bind DN");
                        boolean bindCredentialChar2 = false;
                        return bindCredentialChar2;
                    }
                    env.put("java.naming.security.principal", bindDn);
                    bindCredentialChar3 = null;
                    if (bindCredential != null) {
                        bindCredentialChar3 = bindCredential.toCharArray();
                    }
                    env.put("java.naming.security.credentials", bindCredentialChar3);
                }
                ldapContext = new InitialLdapContext(env, null);
            }
            boolean bindCredentialChar3 = true;
            return bindCredentialChar3;
        }
        catch (Exception ne) {
            String errorMessage = TEST_AUTHENTICATION.equals(action) ? "Error when authenticating to LDAP: " : "Error when connecting to LDAP: ";
            ServicesLogger.LOGGER.errorAuthenticating(ne, errorMessage + ne.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (ldapContext != null) {
                try {
                    ldapContext.close();
                }
                catch (NamingException ne) {
                    ServicesLogger.LOGGER.errorClosingLDAP(ne);
                }
            }
        }
    }
}

