/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreePath;
import org.jsampler.CC;
import org.jsampler.view.DbDirectoryTreeNode;
import org.jsampler.view.InstrumentsDbTreeModel;
import org.jsampler.view.InstrumentsDbTreeView;

public abstract class AbstractInstrumentsDbTree
extends JTree {
    private InstrumentsDbTreeView view = null;
    private final EventHandler eventHandler = new EventHandler();

    public AbstractInstrumentsDbTree() {
        this((ActionListener)null);
    }

    public AbstractInstrumentsDbTree(ActionListener actionListener) {
        this(new InstrumentsDbTreeModel(actionListener));
    }

    public AbstractInstrumentsDbTree(InstrumentsDbTreeModel instrumentsDbTreeModel) {
        this.setView(CC.getViewConfig().getInstrumentsDbTreeView());
        this.setModel(instrumentsDbTreeModel);
        this.addTreeWillExpandListener(this.getHandler());
        this.addTreeSelectionListener(this.getHandler());
    }

    @Override
    public InstrumentsDbTreeModel getModel() {
        return (InstrumentsDbTreeModel)super.getModel();
    }

    public void removeSelectedDirectory() {
        DbDirectoryTreeNode dbDirectoryTreeNode = this.getSelectedDirectoryNode();
        if (dbDirectoryTreeNode == null) {
            return;
        }
        String string = this.getModel().getPathName(this.getModel().getPathToRoot(dbDirectoryTreeNode));
    }

    public DbDirectoryTreeNode getSelectedDirectoryNode() {
        if (this.getSelectionCount() == 0) {
            return null;
        }
        return (DbDirectoryTreeNode)this.getSelectionPath().getLastPathComponent();
    }

    public void setSelectedDirectoryNode(DbDirectoryTreeNode dbDirectoryTreeNode) {
        Object[] objectArray = this.getModel().getPathToRoot(dbDirectoryTreeNode);
        this.setSelectionPath(new TreePath(objectArray));
    }

    public String getSelectedDirectoryPath() {
        return this.getModel().getPathByNode(this.getSelectedDirectoryNode());
    }

    public void setSelectedDirectory(final String string) {
        this.getModel().loadPath(string, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbDirectoryTreeNode dbDirectoryTreeNode = AbstractInstrumentsDbTree.this.getModel().getNodeByPath(string);
                if (dbDirectoryTreeNode != null) {
                    AbstractInstrumentsDbTree.this.setSelectedDirectoryNode(dbDirectoryTreeNode);
                }
            }
        });
    }

    public void refreshDirectoryContent(String string) {
        this.getModel().refreshDirectoryContent(string);
    }

    @Override
    public boolean hasBeenExpanded(TreePath treePath) {
        return super.hasBeenExpanded(treePath) || !this.getModel().isLeaf(treePath.getLastPathComponent());
    }

    public void setView(InstrumentsDbTreeView instrumentsDbTreeView) {
        this.view = instrumentsDbTreeView;
    }

    public InstrumentsDbTreeView getView() {
        return this.view;
    }

    private EventHandler getHandler() {
        return this.eventHandler;
    }

    private class EventHandler
    implements TreeWillExpandListener,
    TreeSelectionListener {
        private EventHandler() {
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
            AbstractInstrumentsDbTree.this.getModel().treeWillExpand(treeExpansionEvent.getPath());
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = treeSelectionEvent.getPath();
            if (treePath == null) {
                System.err.println("p is null");
                return;
            }
            AbstractInstrumentsDbTree.this.getModel().treeWillExpand(treePath);
        }
    }
}

