/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include "typedef.h"
#include "name.h"
#include "tools.h"
#include "matrix.h"
#include "getput.h"
#include "bravais.h"
#include "contrib.h"
#include "sort.h"
#include "datei.h"

#define HM_TABLE TOPDIR "/tables/qcatalog/translation_HM_symbol"


static void remove_underscore(char *s)
{

   char *PP;

   PP = strchr(s,'_');
   while (PP){
      *PP=' ';
      PP = strchr(PP,'_');
   }

}

/*************************************************************************
@ void display_HM_symbol(char *qname,
@                        int zname1,
@                        int zname2,
@                        MP_INT *aff_name)
**************************************************************************/
void display_HM_symbol(char *qname,
                       int zname1,
                       int zname2,
                       MP_INT *aff_name)
{

   int number,
       i,
       z1in,
       z2in,
       found=0;

   FILE *F;

   char qin[1028],
        affin[128],
        affstring[128],
        HMSYMBOL[128];

   mpz_get_str(affstring,10,aff_name);

   F = fopen(HM_TABLE,"r");

   if (F == NULL){
      fprintf(stderr,"can't open %s\n",HM_TABLE);
      exit(4);
   }

   fscanf(F,"#%d\n",&number);

   fprintf(stdout,"possible Herman-Mauguin symbols describing a group\n");
   fprintf(stdout,"isomorphic to the given one: \n");

   for (i=0;i<number;i++){
      fscanf(F,"qname: %s zname: %d %d aff_name: %s %s\n",
                      qin,&z1in,&z2in,affin,HMSYMBOL);

      if (strcmp(qin,qname) == 0
         && z1in == zname1
         && z2in == zname2
         && strcmp(affstring,affin) == 0){

         if (found > 0) fprintf(stdout," or ");
         remove_underscore(HMSYMBOL);
         fprintf(stdout,"%s",HMSYMBOL);
         found++;
      }

   }

   fprintf(stdout,"\n");

   if (found == 0){
      fprintf(stderr,"error in display_HM_symbol\n");
      exit(3);
   }

   return;
}

