define(["events","apiclient","appStorage"],function(events,apiClientFactory,appStorage){"use strict";var ConnectionMode_Local=0,ConnectionMode_Remote=1,ConnectionMode_Manual=2;function getServerAddress(server,mode){switch(mode){case ConnectionMode_Local:return server.LocalAddress;case ConnectionMode_Manual:return server.ManualAddress;case ConnectionMode_Remote:return server.RemoteAddress;default:return server.ManualAddress||server.LocalAddress||server.RemoteAddress}}function paramsToString(params){var values=[];for(var key in params){var value=params[key];null!=value&&""!==value&&values.push(encodeURIComponent(key)+"="+encodeURIComponent(value))}return values.join("&")}function resolveFailure(instance,resolve){resolve({State:"Unavailable",ConnectUser:instance.connectUser()})}function mergeServers(credentialProvider,list1,list2){for(var i=0,length=list2.length;i<length;i++)credentialProvider.addOrUpdateServer(list1,list2[i]);return list1}function updateServerInfo(server,systemInfo){server.Name=systemInfo.ServerName,systemInfo.Id&&(server.Id=systemInfo.Id),systemInfo.LocalAddress&&(server.LocalAddress=systemInfo.LocalAddress),systemInfo.WanAddress&&(server.RemoteAddress=systemInfo.WanAddress)}function getFetchPromise(request){var headers=request.headers||{};"json"===request.dataType&&(headers.accept="application/json");var fetchRequest={headers:headers,method:request.type,credentials:"same-origin"},contentType=request.contentType;return request.data&&("string"==typeof request.data?fetchRequest.body=request.data:(fetchRequest.body=paramsToString(request.data),contentType=contentType||"application/x-www-form-urlencoded; charset=UTF-8")),contentType&&(headers["Content-Type"]=contentType),request.timeout?function(url,options,timeoutMs){return console.log("fetchWithTimeout: timeoutMs: "+timeoutMs+", url: "+url),new Promise(function(resolve,reject){var timeout=setTimeout(reject,timeoutMs);(options=options||{}).credentials="same-origin",fetch(url,options).then(function(response){clearTimeout(timeout),console.log("fetchWithTimeout: succeeded connecting to url: "+url),resolve(response)},function(error){clearTimeout(timeout),console.log("fetchWithTimeout: timed out connecting to url: "+url),reject()})})}(request.url,fetchRequest,request.timeout):fetch(request.url,fetchRequest)}function ajax(request){if(!request)throw new Error("Request cannot be null");return request.headers=request.headers||{},console.log("ConnectionManager requesting url: "+request.url),getFetchPromise(request).then(function(response){return console.log("ConnectionManager response status: "+response.status+", url: "+request.url),response.status<400?"json"===request.dataType?response.json():"text"===request.dataType?response.text():"application/json"===request.headers.accept?response.json():response:Promise.reject(response)})}function getConnectUrl(handler){return"https://connect.emby.media/service/"+handler}function replaceAll(originalString,strReplace,strWith){var reg=new RegExp(strReplace,"ig");return originalString.replace(reg,strWith)}function normalizeAddress(address){return 0!==(address=address.trim()).toLowerCase().indexOf("http")&&(address="http://"+address),address=replaceAll(address=replaceAll(address,"Http:","http:"),"Https:","https:")}function stringEqualsIgnoreCase(str1,str2){return(str1||"").toLowerCase()===(str2||"").toLowerCase()}function compareVersions(a,b){a=a.split("."),b=b.split(".");for(var i=0,length=Math.max(a.length,b.length);i<length;i++){var aVal=parseInt(a[i]||"0"),bVal=parseInt(b[i]||"0");if(aVal<bVal)return-1;if(bVal<aVal)return 1}return 0}function ConnectionManager(credentialProvider,appName,appVersion,deviceName,deviceId,getCapabilitiesFn,devicePixelRatio){console.log("Begin ConnectionManager constructor");var connectUser,self=this;function onConnectUserSignIn(user){connectUser=user,events.trigger(self,"connectusersignedin",[user])}function onAuthenticated(apiClient,result){var options={},credentials=credentialProvider.credentials(),servers=credentials.Servers.filter(function(s){return s.Id===result.ServerId}),server=servers.length?servers[0]:apiClient.serverInfo();return!1!==options.updateDateLastAccessed&&(server.DateLastAccessed=(new Date).getTime()),server.Id=result.ServerId,server.UserId=result.User.Id,server.AccessToken=result.AccessToken,credentialProvider.addOrUpdateServer(credentials.Servers,server),credentialProvider.credentials(credentials),apiClient.enableAutomaticBitrateDetection=options.enableAutomaticBitrateDetection,apiClient.serverInfo(server),afterConnected(apiClient,options),onLocalUserSignIn(server,apiClient.serverAddress())}function afterConnected(apiClient,options){!1!==(options=options||{}).reportCapabilities&&function(apiClient){self._getCapabilitiesFn().then(function(capabilities){return apiClient.reportCapabilities(capabilities)})}(apiClient),apiClient.enableAutomaticBitrateDetection=options.enableAutomaticBitrateDetection,!1!==options.enableWebSocket&&(console.log("calling apiClient.ensureWebSocket"),apiClient.ensureWebSocket())}function onLocalUserSignIn(server,serverUrl){return self._getOrAddApiClient(server,serverUrl),(self.onLocalUserSignedIn?self.onLocalUserSignedIn.call(self,server.Id,server.UserId):Promise.resolve()).then(function(){events.trigger(self,"localusersignedin",[server.Id,server.UserId])})}function ensureConnectUser(credentials){return connectUser&&connectUser.Id===credentials.ConnectUserId?Promise.resolve():credentials.ConnectUserId&&credentials.ConnectAccessToken?(connectUser=null,function(userId,accessToken){if(!userId)throw new Error("null userId");if(accessToken)return ajax({type:"GET",url:"https://connect.emby.media/service/user?id="+userId,dataType:"json",headers:{"X-Application":appName+"/"+appVersion,"X-Connect-UserToken":accessToken}});throw new Error("null accessToken")}(credentials.ConnectUserId,credentials.ConnectAccessToken).then(function(user){return onConnectUserSignIn(user),Promise.resolve()},function(){return Promise.resolve()})):Promise.resolve()}function logoutOfServer(apiClient){var logoutInfo={serverId:(apiClient.serverInfo()||{}).Id};return apiClient.logout().then(function(){events.trigger(self,"localusersignedout",[logoutInfo])},function(){events.trigger(self,"localusersignedout",[logoutInfo])})}function tryReconnectToUrl(instance,url,connectionMode,delay){return console.log("tryReconnectToUrl: "+url),function(timeout){return new Promise(function(resolve,reject){setTimeout(resolve,timeout)})}(delay).then(function(){return ajax({url:instance.getEmbyServerUrl(url,"system/info/public"),timeout:2e4,type:"GET",dataType:"json"}).then(function(result){return{url:url,connectionMode:connectionMode,data:result}})})}function allowAddress(instance,address){return!instance.rejectInsecureAddresses||0===address.indexOf("https:")}function tryReconnect(instance,serverInfo){var addresses=[],addressesStrings=[];if(!serverInfo.manualAddressOnly&&serverInfo.LocalAddress&&-1===addressesStrings.indexOf(serverInfo.LocalAddress)&&allowAddress(instance,serverInfo.LocalAddress)&&(addresses.push({url:serverInfo.LocalAddress,mode:ConnectionMode_Local,timeout:0}),addressesStrings.push(addresses[addresses.length-1].url)),serverInfo.ManualAddress&&-1===addressesStrings.indexOf(serverInfo.ManualAddress)&&allowAddress(instance,serverInfo.ManualAddress)&&(addresses.push({url:serverInfo.ManualAddress,mode:ConnectionMode_Manual,timeout:100}),addressesStrings.push(addresses[addresses.length-1].url)),!serverInfo.manualAddressOnly&&serverInfo.RemoteAddress&&-1===addressesStrings.indexOf(serverInfo.RemoteAddress)&&allowAddress(instance,serverInfo.RemoteAddress)&&(addresses.push({url:serverInfo.RemoteAddress,mode:ConnectionMode_Remote,timeout:200}),addressesStrings.push(addresses[addresses.length-1].url)),console.log("tryReconnect: "+addressesStrings.join("|")),!addressesStrings.length)return Promise.reject();for(var promises=[],i=0,length=addresses.length;i<length;i++)promises.push(tryReconnectToUrl(instance,addresses[i].url,addresses[i].mode,addresses[i].timeout));return function(promises){return new Promise(function(resolve,reject){for(var rejections=0,numPromises=promises.length,onReject=function(err){numPromises<=++rejections&&reject(err)},i=0;i<numPromises;i++)promises[i].then(resolve,onReject)})}(promises)}function resolveIfAvailable(url,server,result,connectionMode,serverUrl,options,resolve){(self.validateServerAddress?self.validateServerAddress(self,ajax,url):Promise.resolve()).then(function(){!function(server,systemInfo,connectionMode,serverUrl,options,resolve){var credentials=credentialProvider.credentials();options=options||{},credentials.ConnectAccessToken&&!1!==options.enableAutoLogin?ensureConnectUser(credentials).then(function(){server.ExchangeToken?function(server,serverUrl,credentials){if(!server.ExchangeToken)throw new Error("server.ExchangeToken cannot be null");if(!credentials.ConnectUserId)throw new Error("credentials.ConnectUserId cannot be null");var url=self.getEmbyServerUrl(serverUrl,"Connect/Exchange?format=json&ConnectUserId="+credentials.ConnectUserId),auth='MediaBrowser Client="'+appName+'", Device="'+deviceName+'", DeviceId="'+deviceId+'", Version="'+appVersion+'"';return ajax({type:"GET",url:url,dataType:"json",headers:{"X-MediaBrowser-Token":server.ExchangeToken,"X-Emby-Authorization":auth}}).then(function(auth){return server.UserId=auth.LocalUserId,server.AccessToken=auth.AccessToken,auth},function(){return server.UserId=null,server.AccessToken=null,Promise.reject()})}(server,serverUrl,credentials).then(function(){afterConnectValidated(server,credentials,systemInfo,connectionMode,serverUrl,!0,options,resolve)},function(){afterConnectValidated(server,credentials,systemInfo,connectionMode,serverUrl,!0,options,resolve)}):afterConnectValidated(server,credentials,systemInfo,connectionMode,serverUrl,!0,options,resolve)}):afterConnectValidated(server,credentials,systemInfo,connectionMode,serverUrl,!0,options,resolve)}(server,result,connectionMode,serverUrl,options,resolve)},function(){console.log("minServerVersion requirement not met. Server version: "+result.Version),resolve({State:"ServerUpdateNeeded",Servers:[server]})})}function afterConnectValidated(server,credentials,systemInfo,connectionMode,serverUrl,verifyLocalAuthentication,options,resolve){if(!1===(options=options||{}).enableAutoLogin)server.UserId=null,server.AccessToken=null;else if(verifyLocalAuthentication&&server.AccessToken&&!1!==options.enableAutoLogin)return void function(server,serverUrl){return ajax({type:"GET",url:self.getEmbyServerUrl(serverUrl,"System/Info"),dataType:"json",headers:{"X-MediaBrowser-Token":server.AccessToken}}).then(function(systemInfo){return updateServerInfo(server,systemInfo),Promise.resolve()},function(){return server.UserId=null,server.AccessToken=null,Promise.resolve()})}(server,serverUrl).then(function(){afterConnectValidated(server,credentials,systemInfo,connectionMode,serverUrl,!1,options,resolve)});updateServerInfo(server,systemInfo),server.LastConnectionMode=connectionMode,!1!==options.updateDateLastAccessed&&(server.DateLastAccessed=(new Date).getTime()),credentialProvider.addOrUpdateServer(credentials.Servers,server),credentialProvider.credentials(credentials);var result={Servers:[]};result.ApiClient=self._getOrAddApiClient(server,serverUrl),result.ApiClient.setSystemInfo(systemInfo),result.State=server.AccessToken&&!1!==options.enableAutoLogin?"SignedIn":"ServerSignIn",result.Servers.push(server),result.ApiClient.enableAutomaticBitrateDetection=options.enableAutomaticBitrateDetection,result.ApiClient.updateServerInfo(server,serverUrl);function resolveActions(){resolve(result),events.trigger(self,"connected",[result])}"SignedIn"===result.State?(afterConnected(result.ApiClient,options),onLocalUserSignIn(server,serverUrl).then(resolveActions,resolveActions)):resolveActions()}function getCacheKey(feature,apiClient,options){var viewOnly=(options=options||{}).viewOnly,cacheKey="regInfo-"+apiClient.serverId();return viewOnly&&(cacheKey+="-viewonly"),cacheKey}function addAppInfoToConnectRequest(request){request.headers=request.headers||{},request.headers["X-Application"]=appName+"/"+appVersion}this._getCapabilitiesFn=getCapabilitiesFn,this._apiClients=[],self.connectUser=function(){return connectUser},self._minServerVersion="3.5.2",self.appVersion=function(){return appVersion},self.appName=function(){return appName},self.deviceId=function(){return deviceId},self.credentialProvider=function(){return credentialProvider},self.connectUserId=function(){return credentialProvider.credentials().ConnectUserId},self.connectToken=function(){return credentialProvider.credentials().ConnectAccessToken},self.getServerInfo=function(id){return credentialProvider.credentials().Servers.filter(function(s){return s.Id===id})[0]},self.getEmbyServerUrl=function(baseUrl,handler){return baseUrl+"/emby/"+handler},self.getLastUsedServer=function(){var servers=credentialProvider.credentials().Servers;return servers.sort(function(a,b){return(b.DateLastAccessed||0)-(a.DateLastAccessed||0)}),servers.length?servers[0]:null},self.addApiClient=function(apiClient){self._apiClients.push(apiClient);var existingServers=credentialProvider.credentials().Servers.filter(function(s){return stringEqualsIgnoreCase(s.ManualAddress,apiClient.serverAddress())||stringEqualsIgnoreCase(s.LocalAddress,apiClient.serverAddress())||stringEqualsIgnoreCase(s.RemoteAddress,apiClient.serverAddress())}),existingServer=existingServers.length?existingServers[0]:apiClient.serverInfo();if(existingServer.DateLastAccessed=(new Date).getTime(),existingServer.LastConnectionMode=ConnectionMode_Manual,existingServer.ManualAddress=apiClient.serverAddress(),apiClient.manualAddressOnly&&(existingServer.manualAddressOnly=!0),apiClient.serverInfo(existingServer),apiClient.onAuthenticated=onAuthenticated,!existingServers.length){var credentials=credentialProvider.credentials();credentials.Servers=[existingServer],credentialProvider.credentials(credentials)}events.trigger(self,"apiclientcreated",[apiClient])},self.clearData=function(){console.log("connection manager clearing data"),connectUser=null;var credentials=credentialProvider.credentials();credentials.ConnectAccessToken=null,credentials.ConnectUserId=null,credentials.Servers=[],credentialProvider.credentials(credentials)},self._getOrAddApiClient=function(server,serverUrl){var apiClient=self.getApiClient(server.Id);return apiClient||((apiClient=new apiClientFactory(serverUrl,appName,appVersion,deviceName,deviceId,devicePixelRatio)).rejectInsecureAddresses=self.rejectInsecureAddresses,self._apiClients.push(apiClient),apiClient.serverInfo(server),apiClient.onAuthenticated=onAuthenticated,events.trigger(self,"apiclientcreated",[apiClient])),console.log("returning instance from getOrAddApiClient"),apiClient},self.getOrCreateApiClient=function(serverId){var servers=credentialProvider.credentials().Servers.filter(function(s){return stringEqualsIgnoreCase(s.Id,serverId)});if(!servers.length)throw new Error("Server not found: "+serverId);var server=servers[0];return self._getOrAddApiClient(server,getServerAddress(server,server.LastConnectionMode))},self.logout=function(){console.log("begin connectionManager loguot");for(var promises=[],i=0,length=self._apiClients.length;i<length;i++){var apiClient=self._apiClients[i];apiClient.accessToken()&&promises.push(logoutOfServer(apiClient))}return Promise.all(promises).then(function(){for(var credentials=credentialProvider.credentials(),servers=credentials.Servers,j=0,numServers=servers.length;j<numServers;j++){var server=servers[j];server.UserId=null,server.AccessToken=null,server.ExchangeToken=null}credentials.Servers=servers,credentials.ConnectAccessToken=null,credentials.ConnectUserId=null,credentialProvider.credentials(credentials),connectUser&&(connectUser=null,events.trigger(self,"connectusersignedout"))})},self.getSavedServers=function(){var servers=credentialProvider.credentials().Servers.slice(0);return servers.sort(function(a,b){return(b.DateLastAccessed||0)-(a.DateLastAccessed||0)}),servers},self.getAvailableServers=function(){console.log("Begin getAvailableServers");var credentials=credentialProvider.credentials();return Promise.all([function(credentials){return console.log("Begin getConnectServers"),credentials.ConnectAccessToken&&credentials.ConnectUserId?ajax({type:"GET",url:"https://connect.emby.media/service/servers?userId="+credentials.ConnectUserId,dataType:"json",headers:{"X-Application":appName+"/"+appVersion,"X-Connect-UserToken":credentials.ConnectAccessToken}}).then(function(servers){return servers.map(function(i){return{ExchangeToken:i.AccessKey,ConnectServerId:i.Id,Id:i.SystemId,Name:i.Name,RemoteAddress:i.Url,LocalAddress:i.LocalAddress}})},function(){return credentials.Servers.slice(0).filter(function(s){return s.ExchangeToken})}):Promise.resolve([])}(credentials),new Promise(function(resolve,reject){function onFinish(foundServers){var servers=foundServers.map(function(foundServer){var info={Id:foundServer.Id,LocalAddress:function(info){if(info.Address&&info.EndpointAddress){var address=info.EndpointAddress.split(":")[0],parts=info.Address.split(":");if(1<parts.length){var portString=parts[parts.length-1];isNaN(parseInt(portString))||(address+=":"+portString)}return normalizeAddress(address)}return null}(foundServer)||foundServer.Address,Name:foundServer.Name};return info.LastConnectionMode=info.ManualAddress?ConnectionMode_Manual:ConnectionMode_Local,info});resolve(servers)}require(["serverdiscovery"],function(serverDiscovery){serverDiscovery.findServers(1e3).then(onFinish,function(){onFinish([])})})})]).then(function(responses){var connectServers=responses[0],foundServers=responses[1],servers=credentials.Servers.slice(0);return mergeServers(credentialProvider,servers,foundServers),mergeServers(credentialProvider,servers,connectServers),(servers=function(servers,connectServers){return servers.filter(function(server){return!server.ExchangeToken||0<connectServers.filter(function(connectServer){return server.Id===connectServer.Id}).length})}(servers,connectServers)).sort(function(a,b){return(b.DateLastAccessed||0)-(a.DateLastAccessed||0)}),credentials.Servers=servers,credentialProvider.credentials(credentials),servers})},self.connectToServers=function(servers,options){console.log("Begin connectToServers, with "+servers.length+" servers");var firstServer=servers.length?servers[0]:null;return firstServer?self.connectToServer(firstServer,options).then(function(result){return"Unavailable"===result.State&&(result.State="ServerSelection"),console.log("resolving connectToServers with result.State: "+result.State),result}):Promise.resolve({Servers:servers,State:servers.length||self.connectUser()?"ServerSelection":"ConnectSignIn",ConnectUser:self.connectUser()})},self.connectToServer=function(server,options){return console.log("begin connectToServer"),new Promise(function(resolve,reject){options=options||{},tryReconnect(self,server).then(function(result){var serverUrl=result.url,connectionMode=result.connectionMode;result=result.data,1===compareVersions(self.minServerVersion(),result.Version)||1===compareVersions(result.Version,"8.0")?(console.log("minServerVersion requirement not met. Server version: "+result.Version),resolve({State:"ServerUpdateNeeded",Servers:[server]})):server.Id&&result.Id!==server.Id?(console.log("http request succeeded, but found a different server Id than what was expected"),resolveFailure(self,resolve)):resolveIfAvailable(serverUrl,server,result,connectionMode,serverUrl,options,resolve)},function(){resolveFailure(self,resolve)})})},self.connectToAddress=function(address,options){if(!address)return Promise.reject();address=normalizeAddress(address);var instance=this;var server={ManualAddress:address,LastConnectionMode:ConnectionMode_Manual};return self.connectToServer(server,options).catch(function(){return console.log("connectToAddress "+address+" failed"),Promise.resolve({State:"Unavailable",ConnectUser:instance.connectUser()})})},self.loginToConnect=function(username,password){return username&&password?ajax({type:"POST",url:"https://connect.emby.media/service/user/authenticate",data:{nameOrEmail:username,rawpw:password},dataType:"json",contentType:"application/x-www-form-urlencoded; charset=UTF-8",headers:{"X-Application":appName+"/"+appVersion}}).then(function(result){var credentials=credentialProvider.credentials();return credentials.ConnectAccessToken=result.AccessToken,credentials.ConnectUserId=result.User.Id,credentialProvider.credentials(credentials),onConnectUserSignIn(result.User),result}):Promise.reject()},self.signupForConnect=function(options){var email=options.email,username=options.username,password=options.password,passwordConfirm=options.passwordConfirm;if(!email)return Promise.reject({errorCode:"invalidinput"});if(!username)return Promise.reject({errorCode:"invalidinput"});if(!password)return Promise.reject({errorCode:"invalidinput"});if(!passwordConfirm)return Promise.reject({errorCode:"passwordmatch"});if(password!==passwordConfirm)return Promise.reject({errorCode:"passwordmatch"});var data={email:email,userName:username,rawpw:password};return options.grecaptcha&&(data.grecaptcha=options.grecaptcha),ajax({type:"POST",url:"https://connect.emby.media/service/register",data:data,dataType:"json",contentType:"application/x-www-form-urlencoded; charset=UTF-8",headers:{"X-Application":appName+"/"+appVersion,"X-CONNECT-TOKEN":"CONNECT-REGISTER"}}).catch(function(response){return response.json()}).then(function(result){if(result&&result.Status)return"SUCCESS"===result.Status?Promise.resolve(result):Promise.reject({errorCode:result.Status});Promise.reject()})},self.getUserInvitations=function(){var connectToken=self.connectToken();if(!connectToken)throw new Error("null connectToken");if(!self.connectUserId())throw new Error("null connectUserId");return ajax({type:"GET",url:"https://connect.emby.media/service/servers?userId="+self.connectUserId()+"&status=Waiting",dataType:"json",headers:{"X-Connect-UserToken":connectToken,"X-Application":appName+"/"+appVersion}})},self.deleteServer=function(serverId){if(!serverId)throw new Error("null serverId");var server=credentialProvider.credentials().Servers.filter(function(s){return s.Id===serverId});return server=server.length?server[0]:null,new Promise(function(resolve,reject){function onDone(){var credentials=credentialProvider.credentials();credentials.Servers=credentials.Servers.filter(function(s){return s.Id!==serverId}),credentialProvider.credentials(credentials),resolve()}if(server.ConnectServerId){var connectToken=self.connectToken(),connectUserId=self.connectUserId();if(connectToken&&connectUserId)ajax({type:"DELETE",url:"https://connect.emby.media/service/serverAuthorizations?serverId="+server.ConnectServerId+"&userId="+connectUserId,headers:{"X-Connect-UserToken":connectToken,"X-Application":appName+"/"+appVersion}}).then(onDone,onDone);else onDone()}else onDone()})},self.rejectServer=function(serverId){var connectToken=self.connectToken();if(!serverId)throw new Error("null serverId");if(!connectToken)throw new Error("null connectToken");if(!self.connectUserId())throw new Error("null connectUserId");var url="https://connect.emby.media/service/serverAuthorizations?serverId="+serverId+"&userId="+self.connectUserId();return fetch(url,{method:"DELETE",headers:{"X-Connect-UserToken":connectToken,"X-Application":appName+"/"+appVersion}})},self.acceptServer=function(serverId){var connectToken=self.connectToken();if(!serverId)throw new Error("null serverId");if(!connectToken)throw new Error("null connectToken");if(!self.connectUserId())throw new Error("null connectUserId");return ajax({type:"GET",url:"https://connect.emby.media/service/ServerAuthorizations/accept?serverId="+serverId+"&userId="+self.connectUserId(),headers:{"X-Connect-UserToken":connectToken,"X-Application":appName+"/"+appVersion}})},self.resetRegistrationInfo=function(apiClient){var cacheKey=getCacheKey(0,apiClient,{viewOnly:!0});appStorage.removeItem(cacheKey),cacheKey=getCacheKey(0,apiClient,{viewOnly:!1}),appStorage.removeItem(cacheKey),events.trigger(self,"resetregistrationinfo")},self.getRegistrationInfo=function(feature,apiClient,options){var params={serverId:apiClient.serverId(),deviceId:self.deviceId(),deviceName:deviceName,appName:appName,appVersion:appVersion,embyUserName:""};(options=options||{}).viewOnly&&(params.viewOnly=options.viewOnly);var cacheKey=getCacheKey(0,apiClient,options),regInfo=JSON.parse(appStorage.getItem(cacheKey)||"{}"),timeSinceLastValidation=(new Date).getTime()-(regInfo.lastValidDate||0);if(timeSinceLastValidation<=864e5)return console.log("getRegistrationInfo returning cached info"),Promise.resolve();var regCacheValid=timeSinceLastValidation<=864e5*(regInfo.cacheExpirationDays||7);params.embyUserName=apiClient.getCurrentUserName();var currentUserId=apiClient.getCurrentUserId();if(currentUserId&&"81f53802ea0247ad80618f55d9b4ec3c"===currentUserId.toLowerCase()&&"21585256623b4beeb26d5d3b09dec0ac"===params.serverId.toLowerCase())return Promise.reject();var getRegPromise=ajax({url:"https://mb3admin.com/admin/service/registration/validateDevice?"+paramsToString(params),type:"POST",dataType:"json"}).then(function(response){return appStorage.setItem(cacheKey,JSON.stringify({lastValidDate:(new Date).getTime(),deviceId:params.deviceId,cacheExpirationDays:response.cacheExpirationDays})),Promise.resolve()},function(response){var status=(response||{}).status;return console.log("getRegistrationInfo response: "+status),403===status?Promise.reject("overlimit"):status?Promise.reject():function(err){if(console.log("getRegistrationInfo failed: "+err),regCacheValid)return console.log("getRegistrationInfo returning cached info"),Promise.resolve();throw err}(response)});return regCacheValid?(console.log("getRegistrationInfo returning cached info"),Promise.resolve()):getRegPromise},self.createPin=function(){var request={type:"POST",url:getConnectUrl("pin"),data:{deviceId:deviceId},dataType:"json"};return addAppInfoToConnectRequest(request),ajax(request)},self.getPinStatus=function(pinInfo){if(!pinInfo)throw new Error("pinInfo cannot be null");var queryString={deviceId:pinInfo.DeviceId,pin:pinInfo.Pin},request={type:"GET",url:getConnectUrl("pin")+"?"+paramsToString(queryString),dataType:"json"};return addAppInfoToConnectRequest(request),ajax(request)},self.exchangePin=function(pinInfo){if(!pinInfo)throw new Error("pinInfo cannot be null");return function(pinInfo){if(!pinInfo)throw new Error("pinInfo cannot be null");var request={type:"POST",url:getConnectUrl("pin/authenticate"),data:{deviceId:pinInfo.DeviceId,pin:pinInfo.Pin},dataType:"json"};return addAppInfoToConnectRequest(request),ajax(request)}(pinInfo).then(function(result){var credentials=credentialProvider.credentials();return credentials.ConnectAccessToken=result.AccessToken,credentials.ConnectUserId=result.UserId,credentialProvider.credentials(credentials),ensureConnectUser(credentials)})}}return ConnectionManager.prototype.connect=function(options){console.log("Begin connect");var instance=this;return instance.getAvailableServers().then(function(servers){return instance.connectToServers(servers,options)})},ConnectionManager.prototype.isLoggedIntoConnect=function(){return!(!this.connectToken()||!this.connectUserId())},ConnectionManager.prototype.getApiClients=function(){for(var servers=this.getSavedServers(),i=0,length=servers.length;i<length;i++){var server=servers[i];if(server.Id){var serverUrl=getServerAddress(server,server.LastConnectionMode);serverUrl&&this._getOrAddApiClient(server,serverUrl)}}return this._apiClients},ConnectionManager.prototype.getApiClient=function(item){if(!item)throw new Error("item or serverId cannot be null");return item.ServerId&&(item=item.ServerId),this._apiClients.filter(function(a){var serverInfo=a.serverInfo();return!serverInfo||serverInfo.Id===item})[0]},ConnectionManager.prototype.minServerVersion=function(val){return val&&(this._minServerVersion=val),this._minServerVersion},ConnectionManager.prototype.handleMessageReceived=function(msg){var serverId=msg.ServerId;if(serverId){var apiClient=this.getApiClient(serverId);if(apiClient){if("string"==typeof msg.Data)try{msg.Data=JSON.parse(msg.Data)}catch(err){}apiClient.handleMessageReceived(msg)}}},ConnectionManager.prototype.onNetworkChanged=function(){for(var apiClients=this._apiClients,i=0,length=apiClients.length;i<length;i++)apiClients[i].onNetworkChanged()},ConnectionManager});