/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.mixin;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.mixin.IMixinRequestor;

public class MixinSourceElementRequestor
implements ISourceElementRequestor {
    private List<String> path = new ArrayList<String>();
    private IMixinRequestor requestor;
    private boolean signature = false;
    private ISourceModule module;

    public MixinSourceElementRequestor(IMixinRequestor requestor, boolean signature, ISourceModule module) {
        this.requestor = requestor;
        this.signature = signature;
        this.module = module;
    }

    protected void enterElement(String path) {
        this.path.add(path);
    }

    private IModelElement getElement(IModelElement parent, int index) {
        if (this.path.size() == index) {
            return parent;
        }
        if (parent instanceof IParent) {
            IParent par = (IParent)((Object)parent);
            IModelElement[] children = null;
            try {
                children = par.getChildren();
            }
            catch (ModelException e) {
                e.printStackTrace();
                throw new RuntimeException((Throwable)((Object)e));
            }
            int i = 0;
            while (i < children.length) {
                IModelElement el;
                if (children[i].getElementName().equals(this.path.get(index)) && (el = this.getElement(children[i], index + 1)) != null) {
                    return el;
                }
                ++i;
            }
        }
        return null;
    }

    protected IModelElement getModelElement() {
        if (!this.signature) {
            return null;
        }
        if (this.path.size() == 0) {
            return this.module;
        }
        return this.getElement(this.module, 0);
    }

    protected void exitElement() {
        if (this.path.size() > 0) {
            this.path.remove(this.path.size() - 1);
        }
    }

    protected String getKey() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.path.size()) {
            buffer.append(this.path.get(i));
            if (i != this.path.size() - 1) {
                buffer.append(IMixinRequestor.MIXIN_NAME_SEPARATOR);
            }
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public void acceptFieldReference(String fieldName, int sourcePosition) {
    }

    @Override
    public void acceptMethodReference(String methodName, int argCount, int sourcePosition, int sourceEndPosition) {
    }

    @Override
    public void acceptPackage(int declarationStart, int declarationEnd, String name) {
    }

    @Override
    public void acceptTypeReference(String typeName, int sourcePosition) {
    }

    @Override
    public boolean enterFieldCheckDuplicates(IElementRequestor.FieldInfo info) {
        return false;
    }

    @Override
    public void enterMethodRemoveSame(IElementRequestor.MethodInfo info) {
    }

    @Override
    public void enterModule() {
    }

    @Override
    public void enterModuleRoot() {
    }

    @Override
    public boolean enterTypeAppend(String fullName, String delimiter) {
        return false;
    }

    @Override
    public void exitModule(int declarationEnd) {
    }

    @Override
    public void exitModuleRoot() {
    }

    @Override
    public void exitField(int declarationEnd) {
        this.exitElement();
    }

    @Override
    public void exitMethod(int declarationEnd) {
        this.exitElement();
    }

    @Override
    public void exitType(int declarationEnd) {
        this.exitElement();
    }

    @Override
    public void enterField(IElementRequestor.FieldInfo info) {
        this.enterElement(info.name);
        IMixinRequestor.ElementInfo elInfo = new IMixinRequestor.ElementInfo();
        elInfo.key = this.getKey();
        if (this.signature) {
            elInfo.object = this.getModelElement();
        }
        this.requestor.reportElement(elInfo);
    }

    public void updateField(IElementRequestor.FieldInfo fieldInfo, int flags) {
    }

    @Override
    public void enterMethod(IElementRequestor.MethodInfo info) {
        this.enterElement(info.name);
        IMixinRequestor.ElementInfo elInfo = new IMixinRequestor.ElementInfo();
        elInfo.key = this.getKey();
        if (this.signature) {
            elInfo.object = this.getModelElement();
        }
        this.requestor.reportElement(elInfo);
    }

    @Override
    public void enterType(IElementRequestor.TypeInfo info) {
        this.enterElement(info.name);
        IMixinRequestor.ElementInfo elInfo = new IMixinRequestor.ElementInfo();
        elInfo.key = this.getKey();
        if (this.signature) {
            elInfo.object = this.getModelElement();
        }
        this.requestor.reportElement(elInfo);
    }

    @Override
    public void acceptImport(IElementRequestor.ImportInfo importInfo) {
    }

    @Override
    public void enterNamespace(String[] namespace) {
    }

    @Override
    public void exitNamespace() {
    }
}

