/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.php.refactoring.core.rename.INameUpdating;
import org.eclipse.php.refactoring.ui.PHPRefactoringUIMessages;
import org.eclipse.php.refactoring.ui.RefactoringUIPlugin;
import org.eclipse.php.refactoring.ui.wizard.RenameInputWizardPage;

public class RenameRefactoringWizard
extends RefactoringWizard {
    private final String fInputPageDescription;
    private final String fPageContextHelpId;
    private final ImageDescriptor fInputPageImageDescriptor;

    public RenameRefactoringWizard(Refactoring refactoring, String defaultPageTitle, String inputPageDescription, ImageDescriptor inputPageImageDescriptor, String pageContextHelpId) {
        super(refactoring, 4);
        this.setDefaultPageTitle(defaultPageTitle);
        this.fInputPageDescription = inputPageDescription;
        this.fInputPageImageDescriptor = inputPageImageDescriptor;
        this.fPageContextHelpId = pageContextHelpId;
    }

    protected void addUserInputPages() {
        String initialSetting = this.getNameUpdating().getCurrentElementName();
        RenameInputWizardPage inputPage = this.createInputPage(this.fInputPageDescription, initialSetting);
        inputPage.setImageDescriptor(this.fInputPageImageDescriptor);
        this.addPage((IWizardPage)inputPage);
    }

    protected INameUpdating getNameUpdating() {
        return (INameUpdating)this.getRefactoring().getAdapter(INameUpdating.class);
    }

    protected RenameInputWizardPage createInputPage(String message, String initialSetting) {
        return new RenameInputWizardPage(message, this.fPageContextHelpId, true, initialSetting){

            @Override
            protected RefactoringStatus validateTextField(String text) {
                return RenameRefactoringWizard.this.validateNewName(text);
            }
        };
    }

    protected RefactoringStatus validateNewName(String newName) {
        INameUpdating ref = this.getNameUpdating();
        ref.setNewElementName(newName);
        try {
            return ref.checkNewElementName(newName);
        }
        catch (CoreException e) {
            RefactoringUIPlugin.log((Exception)((Object)e));
            return RefactoringStatus.createFatalErrorStatus((String)PHPRefactoringUIMessages.getString("RenameRefactoringWizard_internal_error"));
        }
    }
}

