/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.breakpoints;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.lsp4e.debug.DSPPlugin;
import org.eclipse.lsp4e.debug.debugmodel.DSPStackFrame;
import org.eclipse.lsp4e.debug.debugmodel.DSPVariable;
import org.eclipse.lsp4j.debug.EvaluateArguments;
import org.eclipse.lsp4j.debug.EvaluateResponse;

public class TextSelectionToIVariable
implements IAdapterFactory {
    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (!(adaptableObject instanceof TextSelection)) {
            return null;
        }
        if (!IVariable.class.isAssignableFrom(adapterType)) {
            return null;
        }
        TextSelection selection = (TextSelection)adaptableObject;
        return (T)this.getVariableFor(selection);
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IVariable.class};
    }

    private IVariable getVariableFor(TextSelection selection) {
        IDocument document = this.getDocument(selection);
        if (document == null) {
            return null;
        }
        DSPStackFrame frame = this.getFrame();
        if (frame == null) {
            return null;
        }
        try {
            String variableName = document.get(selection.getOffset(), selection.getLength());
            if (variableName.isEmpty()) {
                variableName = this.findVariableName(document, selection.getOffset());
            }
            if (Boolean.TRUE.equals(frame.getDebugTarget().getCapabilities().getSupportsEvaluateForHovers())) {
                EvaluateArguments args = new EvaluateArguments();
                args.setContext("hover");
                args.setFrameId(frame.getFrameId());
                args.setExpression(variableName);
                try {
                    EvaluateResponse res = (EvaluateResponse)frame.getDebugProtocolServer().evaluate(args).get();
                    return new DSPVariable(this.getFrame().getDebugTarget(), res.getVariablesReference(), variableName, res.getResult(), res.getVariablesReference());
                }
                catch (ExecutionException e) {
                    DSPPlugin.logError(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    DSPPlugin.logError(e);
                }
            }
            try {
                IVariable[] iVariableArray = frame.getVariables();
                int n = iVariableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IVariable scopeVariable = iVariableArray[n2];
                    IValue scope = scopeVariable.getValue();
                    if (scope != null) {
                        IVariable[] vars;
                        IVariable[] iVariableArray2 = vars = scope.getVariables();
                        int n3 = vars.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IVariable var = iVariableArray2[n4];
                            if (var.getName().equals(variableName)) {
                                return var;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            catch (DebugException de) {
                DSPPlugin.logError(de);
            }
        }
        catch (BadLocationException e) {
            DSPPlugin.logError(e);
        }
        return null;
    }

    private String findVariableName(IDocument document, int offset) {
        block5: {
            if (Character.isJavaIdentifierPart(document.getChar(offset))) break block5;
            return null;
        }
        try {
            int startOffset = offset;
            while (startOffset - 1 >= 0 && Character.isJavaIdentifierPart(document.getChar(startOffset - 1))) {
                --startOffset;
            }
            int endOffset = offset;
            while (endOffset + 1 < document.getLength() && Character.isJavaIdentifierPart(document.getChar(endOffset + 1))) {
                ++endOffset;
            }
            return document.get(startOffset, endOffset - startOffset + 1);
        }
        catch (BadLocationException ex) {
            DSPPlugin.logError(ex);
            return null;
        }
    }

    protected DSPStackFrame getFrame() {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable != null) {
            return (DSPStackFrame)((Object)Adapters.adapt((Object)adaptable, DSPStackFrame.class));
        }
        return null;
    }

    private IDocument getDocument(TextSelection sel) {
        try {
            Method documentMethod = TextSelection.class.getDeclaredMethod("getDocument", new Class[0]);
            documentMethod.setAccessible(true);
            return (IDocument)documentMethod.invoke((Object)sel, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            DSPPlugin.logError(e);
            return null;
        }
    }
}

