/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.internal.Activator;
import org.eclipse.swt.graphics.Image;

public class DefaultDescriptorLabelProvider
extends LabelProvider {
    private Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();

    public void dispose() {
        super.dispose();
        for (Image image : this.images.values()) {
            image.dispose();
        }
    }

    public Image getImage(Object element) {
        ILaunchConfiguration config;
        if (element instanceof ILaunchDescriptor && (config = (ILaunchConfiguration)((ILaunchDescriptor)element).getAdapter(ILaunchConfiguration.class)) != null) {
            try {
                ILaunchConfigurationType type = config.getType();
                ImageDescriptor imageDescriptor = DebugUITools.getDefaultImageDescriptor((Object)type);
                if (imageDescriptor != null) {
                    Image image = this.images.get(imageDescriptor);
                    if (image == null) {
                        image = imageDescriptor.createImage();
                        this.images.put(imageDescriptor, image);
                    }
                    return image;
                }
            }
            catch (CoreException e) {
                Activator.log((IStatus)e.getStatus());
            }
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof ILaunchDescriptor) {
            return ((ILaunchDescriptor)element).getName();
        }
        return super.getText(element);
    }
}

