/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.utils.CommonUtils;

public class StringEditorTable {
    public static Table createEditableList(@NotNull Composite parent, @NotNull String name, @Nullable List<String> values, final @Nullable DBPImage icon, final @Nullable IContentProposalProvider proposalProvider) {
        Group group = UIUtils.createControlGroup(parent, name, 2, 1808, 0);
        final Table valueTable = new Table((Composite)group, 68356);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 100;
        valueTable.setLayoutData((Object)gd);
        valueTable.setLinesVisible(true);
        final TableColumn valueColumn = UIUtils.createTableColumn(valueTable, 16384, UIMessages.properties_value);
        valueTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                valueColumn.setWidth(valueTable.getClientArea().width);
            }
        });
        StringEditorTable.fillFilterValues(valueTable, values, icon);
        final CustomTableEditor tableEditor = new CustomTableEditor(valueTable){
            {
                super($anonymous0);
                this.firstTraverseIndex = 0;
                this.lastTraverseIndex = 0;
            }

            @Override
            protected Control createEditor(Table table, int index, TableItem item) {
                Text editor = new Text((Composite)table, 2048);
                editor.setText(item.getText());
                editor.addModifyListener(e -> this.saveEditorValue((Control)editor, index, item));
                if (proposalProvider != null) {
                    this.setProposalAdapter(UIUtils.installContentProposal((Control)editor, (IControlContentAdapter)new TextContentAdapter(), proposalProvider, true, false));
                }
                return editor;
            }

            @Override
            protected void saveEditorValue(Control control, int index, TableItem item) {
                item.setText(((Text)control).getText().trim());
            }
        };
        Composite buttonsGroup = UIUtils.createPlaceholder((Composite)group, 1, 5);
        buttonsGroup.setLayoutData((Object)new GridData(2));
        Button addButton = new Button(buttonsGroup, 8);
        addButton.setText(UIMessages.button_add);
        addButton.setLayoutData((Object)new GridData(768));
        final Button removeButton = new Button(buttonsGroup, 8);
        removeButton.setText(UIMessages.button_remove);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = valueTable.getSelectionIndex();
                if (selectionIndex >= 0) {
                    tableEditor.closeEditor();
                    valueTable.remove(selectionIndex);
                    removeButton.setEnabled(valueTable.getSelectionIndex() >= 0);
                }
            }
        });
        removeButton.setEnabled(false);
        Button clearButton = new Button(buttonsGroup, 8);
        clearButton.setText(UIMessages.button_clear);
        clearButton.setLayoutData((Object)new GridData(768));
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tableEditor.closeEditor();
                valueTable.removeAll();
                removeButton.setEnabled(false);
            }
        });
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem newItem = new TableItem(valueTable, 16384);
                if (icon != null) {
                    newItem.setImage(DBeaverIcons.getImage(icon));
                }
                valueTable.setSelection(newItem);
                tableEditor.closeEditor();
                tableEditor.showEditor(newItem);
                removeButton.setEnabled(true);
            }
        });
        valueTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = valueTable.getSelectionIndex();
                removeButton.setEnabled(selectionIndex >= 0);
            }
        });
        return valueTable;
    }

    public static void fillFilterValues(Table valueTable, List<String> values, DBPImage icon) {
        valueTable.removeAll();
        if (!CommonUtils.isEmpty(values)) {
            for (String value : values) {
                TableItem tableItem = new TableItem(valueTable, 16384);
                tableItem.setText(value);
                if (icon == null) continue;
                tableItem.setImage(DBeaverIcons.getImage(icon));
            }
        }
    }

    public static List<String> collectValues(Table table) {
        ArrayList<String> values = new ArrayList<String>();
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String value = item.getText().trim();
            if (!value.isEmpty()) {
                values.add(value);
            }
            ++n2;
        }
        return values;
    }
}

