/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ui.internal.preferences.PropertyMapAdapter;

public final class PreferencesAdapter
extends PropertyMapAdapter {
    private Preferences store;
    private Preferences.IPropertyChangeListener listener = event -> this.firePropertyChange(event.getProperty());

    public PreferencesAdapter(Preferences toConvert) {
        this.store = toConvert;
    }

    @Override
    protected void attachListener() {
        this.store.addPropertyChangeListener(this.listener);
    }

    @Override
    protected void detachListener() {
        this.store.removePropertyChangeListener(this.listener);
    }

    @Override
    public Set keySet() {
        HashSet result = new HashSet();
        Collections.addAll(result, this.store.propertyNames());
        return result;
    }

    @Override
    public Object getValue(String propertyId, Class propertyType) {
        if (propertyType.isAssignableFrom(String.class)) {
            return this.store.getString(propertyId);
        }
        if (propertyType == Boolean.class) {
            return this.store.getBoolean(propertyId) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (propertyType == Double.class) {
            return this.store.getDouble(propertyId);
        }
        if (propertyType == Float.class) {
            return Float.valueOf(this.store.getFloat(propertyId));
        }
        if (propertyType == Integer.class) {
            return this.store.getInt(propertyId);
        }
        if (propertyType == Long.class) {
            return this.store.getLong(propertyId);
        }
        return null;
    }

    @Override
    public boolean propertyExists(String propertyId) {
        return this.store.contains(propertyId);
    }

    @Override
    public void setValue(String propertyId, Object newValue) {
        if (newValue instanceof String) {
            this.store.setValue(propertyId, (String)newValue);
        } else if (newValue instanceof Integer) {
            this.store.setValue(propertyId, ((Integer)newValue).intValue());
        } else if (newValue instanceof Boolean) {
            this.store.setValue(propertyId, ((Boolean)newValue).booleanValue());
        } else if (newValue instanceof Double) {
            this.store.setValue(propertyId, ((Double)newValue).doubleValue());
        } else if (newValue instanceof Float) {
            this.store.setValue(propertyId, ((Float)newValue).floatValue());
        } else if (newValue instanceof Integer) {
            this.store.setValue(propertyId, ((Integer)newValue).intValue());
        } else if (newValue instanceof Long) {
            this.store.setValue(propertyId, ((Long)newValue).longValue());
        }
    }
}

