/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.jvm.ClassFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.tools.JavaFileObject;

public class ModuleNameReader {
    private static final int INITIAL_BUFFER_SIZE = 65520;
    private byte[] buf = new byte[65520];
    private int bp;
    private int[] poolIdx;

    public String readModuleName(Path p) throws IOException, BadClassFile {
        try (InputStream in = Files.newInputStream(p, new OpenOption[0]);){
            String string = this.readModuleName(in);
            return string;
        }
    }

    public String readModuleName(JavaFileObject jfo) throws IOException, BadClassFile {
        try (InputStream in = jfo.openInputStream();){
            String string = this.readModuleName(in);
            return string;
        }
    }

    public String readModuleName(InputStream in) throws IOException, BadClassFile {
        this.bp = 0;
        this.buf = ModuleNameReader.readInputStream(this.buf, in);
        int magic = this.nextInt();
        if (magic != -889275714) {
            throw new BadClassFile("illegal.start.of.class.file");
        }
        char minorVersion = this.nextChar();
        char majorVersion = this.nextChar();
        if (majorVersion < '5') {
            throw new BadClassFile("bad major version number for module: " + majorVersion);
        }
        this.indexPool();
        char access_flags = this.nextChar();
        if (access_flags != '\u8000') {
            throw new BadClassFile("invalid access flags for module: 0x" + Integer.toHexString(access_flags));
        }
        char this_class = this.nextChar();
        this.checkZero(this.nextChar(), "super_class");
        this.checkZero(this.nextChar(), "interface_count");
        this.checkZero(this.nextChar(), "fields_count");
        this.checkZero(this.nextChar(), "methods_count");
        int attributes_count = this.nextChar();
        for (int i = 0; i < attributes_count; ++i) {
            char attr_name = this.nextChar();
            int attr_length = this.nextInt();
            if (this.getUtf8Value(attr_name, false).equals("Module") && attr_length > 2) {
                return this.getModuleName(this.nextChar());
            }
            this.bp += attr_length;
        }
        throw new BadClassFile("no Module attribute");
    }

    void checkZero(int count, String name) throws BadClassFile {
        if (count != 0) {
            throw new BadClassFile("invalid " + name + " for module: " + count);
        }
    }

    char getChar(int bp) {
        return (char)(((this.buf[bp] & 0xFF) << 8) + (this.buf[bp + 1] & 0xFF));
    }

    char nextChar() {
        return (char)(((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF));
    }

    int nextInt() {
        return ((this.buf[this.bp++] & 0xFF) << 24) + ((this.buf[this.bp++] & 0xFF) << 16) + ((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF);
    }

    void indexPool() throws BadClassFile {
        this.poolIdx = new int[this.nextChar()];
        int i = 1;
        block7: while (i < this.poolIdx.length) {
            this.poolIdx[i++] = this.bp;
            byte tag = this.buf[this.bp++];
            switch (tag) {
                case 1: 
                case 2: {
                    char len = this.nextChar();
                    this.bp += len;
                    continue block7;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    this.bp += 2;
                    continue block7;
                }
                case 15: {
                    this.bp += 3;
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    this.bp += 4;
                    continue block7;
                }
                case 5: 
                case 6: {
                    this.bp += 8;
                    ++i;
                    continue block7;
                }
            }
            throw new BadClassFile("malformed constant pool");
        }
    }

    String getUtf8Value(int index, boolean internalize) throws BadClassFile {
        int utf8Index = this.poolIdx[index];
        if (this.buf[utf8Index] == 1) {
            char len = this.getChar(utf8Index + 1);
            int start = utf8Index + 3;
            if (internalize) {
                return new String(ClassFile.internalize(this.buf, start, len));
            }
            return new String(this.buf, start, (int)len);
        }
        throw new BadClassFile("bad name at index " + index);
    }

    String getModuleName(int index) throws BadClassFile {
        int infoIndex = this.poolIdx[index];
        if (this.buf[infoIndex] == 19) {
            return this.getUtf8Value(this.getChar(infoIndex + 1), true);
        }
        throw new BadClassFile("bad module name at index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readInputStream(byte[] buf, InputStream s) throws IOException {
        try {
            buf = ModuleNameReader.ensureCapacity(buf, s.available());
            int r = s.read(buf);
            int bp = 0;
            while (r != -1) {
                buf = ModuleNameReader.ensureCapacity(buf, bp += r);
                r = s.read(buf, bp, buf.length - bp);
            }
            byte[] byArray = buf;
            return byArray;
        }
        finally {
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static byte[] ensureCapacity(byte[] buf, int needed) {
        if (buf.length <= needed) {
            byte[] old = buf;
            buf = new byte[Integer.highestOneBit(needed) << 1];
            System.arraycopy(old, 0, buf, 0, old.length);
        }
        return buf;
    }

    public static class BadClassFile
    extends Exception {
        private static final long serialVersionUID = 0L;

        BadClassFile(String msg) {
            super(msg);
        }
    }
}

