"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _reactRelay = require("react-relay");

/* istanbul ignore file */
const mutation = function () {
  const node = require("./__generated__/unresolveReviewThreadMutation.graphql");

  if (node.hash && node.hash !== "8b1105e1a3db0455c522c7e5dc69b436") {
    console.error("The definition of 'unresolveReviewThreadMutation' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/unresolveReviewThreadMutation.graphql");
};

var _default = (environment, {
  threadID,
  viewerID,
  viewerLogin
}) => {
  const variables = {
    input: {
      threadId: threadID
    }
  };
  const optimisticResponse = {
    unresolveReviewThread: {
      thread: {
        id: threadID,
        isResolved: false,
        viewerCanResolve: true,
        viewerCanUnresolve: false,
        resolvedBy: {
          id: viewerID,
          login: viewerLogin || 'you'
        }
      }
    }
  };
  return new Promise((resolve, reject) => {
    (0, _reactRelay.commitMutation)(environment, {
      mutation,
      variables,
      optimisticResponse,
      onCompleted: resolve,
      onError: reject
    });
  });
};

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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