#ifndef _EFL_UI_SELECTION_TYPES_EOT_H_
#define _EFL_UI_SELECTION_TYPES_EOT_H_

#ifndef _EFL_UI_SELECTION_TYPES_EOT_TYPES
#define _EFL_UI_SELECTION_TYPES_EOT_TYPES

#ifdef EFL_BETA_API_SUPPORT
/** Selection type
 *
 * @ingroup Efl_Ui
 */
typedef enum
{
  EFL_UI_SELECTION_TYPE_PRIMARY = 0, /**< Primary text selection (highlighted or
                                      * selected text) */
  EFL_UI_SELECTION_TYPE_SECONDARY, /**< Used when primary selection is in use */
  EFL_UI_SELECTION_TYPE_DND, /**< Drag and Drop */
  EFL_UI_SELECTION_TYPE_CLIPBOARD /**< Clipboard selection (ctrl+C) */
} Efl_Ui_Selection_Type;
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/** Selection format
 *
 * @ingroup Efl_Ui
 */
typedef enum
{
  EFL_UI_SELECTION_FORMAT_TARGETS = -1 /* +1 */, /**< For matching every
                                                  * possible atom */
  EFL_UI_SELECTION_FORMAT_NONE = 0, /**< Content is from outside of EFL */
  EFL_UI_SELECTION_FORMAT_TEXT = 1, /**< Plain unformatted text: Used for things
                                     * that don't want rich markup */
  EFL_UI_SELECTION_FORMAT_MARKUP = 2, /**< Edje textblock markup, including
                                       * inline images */
  EFL_UI_SELECTION_FORMAT_IMAGE = 4, /**< Images */
  EFL_UI_SELECTION_FORMAT_VCARD = 8, /**< Vcards */
  EFL_UI_SELECTION_FORMAT_HTML = 16 /**< Raw HTML-like data (eg. webkit) */
} Efl_Ui_Selection_Format;
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/** Defines the kind of action associated with the drop data
 *
 * @ingroup Efl_Ui
 */
typedef enum
{
  EFL_UI_SELECTION_ACTION_UNKNOWN = 0, /**< Action type is unknown */
  EFL_UI_SELECTION_ACTION_COPY, /**< Copy the data */
  EFL_UI_SELECTION_ACTION_MOVE, /**< Move the data */
  EFL_UI_SELECTION_ACTION_PRIVATE, /**< Private action type */
  EFL_UI_SELECTION_ACTION_ASK, /**< Ask the user what to do */
  EFL_UI_SELECTION_ACTION_LIST, /**< List the data */
  EFL_UI_SELECTION_ACTION_LINK, /**< Link the data */
  EFL_UI_SELECTION_ACTION_DESCRIPTION /**< Describe the data */
} Efl_Ui_Selection_Action;
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/** Structure holding the info about selected data
 *
 * @ingroup Efl_Ui
 */
typedef struct _Efl_Ui_Selection_Data
{
  Eina_Position2D pos; /**< Coordinates of the drop (DND operations only) */
  Efl_Ui_Selection_Format format; /**< Format of the selection */
  Eina_Slice content; /**< Selection data */
  Efl_Ui_Selection_Action action; /**< Action to perform with the data */
  Efl_Object *item; /**< Item under the drag position. It is only available for
                     * container */
} Efl_Ui_Selection_Data;
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/** Function pointer for getting selection
 *
 * @ingroup Efl_Ui
 */
typedef void (*Efl_Ui_Selection_Data_Ready)(void *data, Efl_Object *obj, Efl_Ui_Selection_Data *seldata);
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/** Selection-changed specific information.
 *
 * @ingroup Efl_Ui
 */
typedef struct _Efl_Ui_Selection_Changed
{
  Efl_Ui_Selection_Type type; /**< Selection type */
  int seat; /**< The seat on which the selection changed, or NULL for "default"
             */
  void *display; /**< The display connection object, NULL under X11 */
  Eina_Bool exist; /**< EINA_TRUE if the selection has an owner */
} Efl_Ui_Selection_Changed;
#endif /* EFL_BETA_API_SUPPORT */


#endif

#endif
