'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
exports.default = void 0;

function _path() {
  const data = _interopRequireDefault(require('path'));

  _path = function _path() {
    return data;
  };

  return data;
}

function _micromatch() {
  const data = _interopRequireDefault(require('micromatch'));

  _micromatch = function _micromatch() {
    return data;
  };

  return data;
}

function _jestResolveDependencies() {
  const data = _interopRequireDefault(require('jest-resolve-dependencies'));

  _jestResolveDependencies = function _jestResolveDependencies() {
    return data;
  };

  return data;
}

var _testPathPatternToRegexp = _interopRequireDefault(
  require('./testPathPatternToRegexp')
);

function _jestRegexUtil() {
  const data = require('jest-regex-util');

  _jestRegexUtil = function _jestRegexUtil() {
    return data;
  };

  return data;
}

function _jestConfig() {
  const data = require('jest-config');

  _jestConfig = function _jestConfig() {
    return data;
  };

  return data;
}

function _jestSnapshot() {
  const data = require('jest-snapshot');

  _jestSnapshot = function _jestSnapshot() {
    return data;
  };

  return data;
}

function _jestUtil() {
  const data = require('jest-util');

  _jestUtil = function _jestUtil() {
    return data;
  };

  return data;
}

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {default: obj};
}

function _objectSpread(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i] != null ? arguments[i] : {};
    var ownKeys = Object.keys(source);
    if (typeof Object.getOwnPropertySymbols === 'function') {
      ownKeys = ownKeys.concat(
        Object.getOwnPropertySymbols(source).filter(function(sym) {
          return Object.getOwnPropertyDescriptor(source, sym).enumerable;
        })
      );
    }
    ownKeys.forEach(function(key) {
      _defineProperty(target, key, source[key]);
    });
  }
  return target;
}

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
  try {
    var info = gen[key](arg);
    var value = info.value;
  } catch (error) {
    reject(error);
    return;
  }
  if (info.done) {
    resolve(value);
  } else {
    Promise.resolve(value).then(_next, _throw);
  }
}

function _asyncToGenerator(fn) {
  return function() {
    var self = this,
      args = arguments;
    return new Promise(function(resolve, reject) {
      var gen = fn.apply(self, args);
      function _next(value) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, 'next', value);
      }
      function _throw(err) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, 'throw', err);
      }
      _next(undefined);
    });
  };
}

const globsToMatcher = globs => {
  if (globs == null || globs.length === 0) {
    return () => true;
  }

  return path =>
    _micromatch().default.some(
      (0, _jestUtil().replacePathSepForGlob)(path),
      globs,
      {
        dot: true
      }
    );
};

const regexToMatcher = testRegex => {
  if (!testRegex.length) {
    return () => true;
  }

  return path => testRegex.some(testRegex => new RegExp(testRegex).test(path));
};

const toTests = (context, tests) =>
  tests.map(path => ({
    context,
    duration: undefined,
    path
  }));

class SearchSource {
  constructor(context) {
    const config = context.config;
    this._context = context;
    this._rootPattern = new RegExp(
      config.roots
        .map(dir =>
          (0, _jestRegexUtil().escapePathForRegex)(dir + _path().default.sep)
        )
        .join('|')
    );
    const ignorePattern = config.testPathIgnorePatterns;
    this._testIgnorePattern = ignorePattern.length
      ? new RegExp(ignorePattern.join('|'))
      : null;
    this._testPathCases = {
      roots: path => this._rootPattern.test(path),
      testMatch: globsToMatcher(config.testMatch),
      testPathIgnorePatterns: path =>
        !this._testIgnorePattern || !this._testIgnorePattern.test(path),
      testRegex: regexToMatcher(config.testRegex)
    };
  }

  _filterTestPathsWithStats(allPaths, testPathPattern) {
    const data = {
      stats: {},
      tests: [],
      total: allPaths.length
    };
    const testCases = Object.assign({}, this._testPathCases);

    if (testPathPattern) {
      const regex = (0, _testPathPatternToRegexp.default)(testPathPattern);

      testCases.testPathPattern = path => regex.test(path);
    }

    const testCasesKeys = Object.keys(testCases);
    data.tests = allPaths.filter(test =>
      testCasesKeys.reduce((flag, key) => {
        if (testCases[key](test.path)) {
          data.stats[key] = ++data.stats[key] || 1;
          return flag && true;
        }

        data.stats[key] = data.stats[key] || 0;
        return false;
      }, true)
    );
    return data;
  }

  _getAllTestPaths(testPathPattern) {
    return this._filterTestPathsWithStats(
      toTests(this._context, this._context.hasteFS.getAllFiles()),
      testPathPattern
    );
  }

  isTestFilePath(path) {
    return Object.keys(this._testPathCases).every(key =>
      this._testPathCases[key](path)
    );
  }

  findMatchingTests(testPathPattern) {
    return this._getAllTestPaths(testPathPattern);
  }

  findRelatedTests(allPaths, collectCoverage) {
    const dependencyResolver = new (_jestResolveDependencies()).default(
      this._context.resolver,
      this._context.hasteFS,
      (0, _jestSnapshot().buildSnapshotResolver)(this._context.config)
    );
    const tests = toTests(
      this._context,
      dependencyResolver.resolveInverse(
        allPaths,
        this.isTestFilePath.bind(this),
        {
          skipNodeResolution: this._context.config.skipNodeResolution
        }
      )
    );
    let collectCoverageFrom; // If we are collecting coverage, also return collectCoverageFrom patterns

    if (collectCoverage) {
      collectCoverageFrom = Array.from(allPaths).map(filename => {
        filename = (0, _jestConfig().replaceRootDirInPath)(
          this._context.config.rootDir,
          filename
        );
        return _path().default.isAbsolute(filename)
          ? _path().default.relative(this._context.config.rootDir, filename)
          : filename;
      });
    }

    return {
      collectCoverageFrom,
      tests
    };
  }

  findTestsByPaths(paths) {
    return {
      tests: toTests(
        this._context,
        paths
          .map(p => _path().default.resolve(this._context.config.cwd, p))
          .filter(this.isTestFilePath.bind(this))
      )
    };
  }

  findRelatedTestsFromPattern(paths, collectCoverage) {
    if (Array.isArray(paths) && paths.length) {
      const resolvedPaths = paths.map(p =>
        _path().default.resolve(this._context.config.cwd, p)
      );
      return this.findRelatedTests(new Set(resolvedPaths), collectCoverage);
    }

    return {
      tests: []
    };
  }

  findTestRelatedToChangedFiles(changedFilesPromise, collectCoverage) {
    var _this = this;

    return _asyncToGenerator(function*() {
      const _ref = yield changedFilesPromise,
        repos = _ref.repos,
        changedFiles = _ref.changedFiles; // no SCM (git/hg/...) is found in any of the roots.

      const noSCM = Object.keys(repos).every(scm => repos[scm].size === 0);
      return noSCM
        ? {
            noSCM: true,
            tests: []
          }
        : _this.findRelatedTests(changedFiles, collectCoverage);
    })();
  }

  _getTestPaths(globalConfig, changedFilesPromise) {
    const paths = globalConfig.nonFlagArgs;

    if (globalConfig.onlyChanged) {
      if (!changedFilesPromise) {
        throw new Error('This promise must be present when running with -o.');
      }

      return this.findTestRelatedToChangedFiles(
        changedFilesPromise,
        globalConfig.collectCoverage
      );
    } else if (globalConfig.runTestsByPath && paths && paths.length) {
      return Promise.resolve(this.findTestsByPaths(paths));
    } else if (globalConfig.findRelatedTests && paths && paths.length) {
      return Promise.resolve(
        this.findRelatedTestsFromPattern(paths, globalConfig.collectCoverage)
      );
    } else if (globalConfig.testPathPattern != null) {
      return Promise.resolve(
        this.findMatchingTests(globalConfig.testPathPattern)
      );
    } else {
      return Promise.resolve({
        tests: []
      });
    }
  }

  getTestPaths(globalConfig, changedFilesPromise) {
    var _this2 = this;

    return _asyncToGenerator(function*() {
      const searchResult = yield _this2._getTestPaths(
        globalConfig,
        changedFilesPromise
      );
      const filterPath = globalConfig.filter;

      if (filterPath && !globalConfig.skipFilter) {
        const tests = searchResult.tests; // $FlowFixMe: dynamic require.

        const filter = require(filterPath);

        const filterResult = yield filter(tests.map(test => test.path));

        if (!Array.isArray(filterResult.filtered)) {
          throw new Error(
            `Filter ${filterPath} did not return a valid test list`
          );
        }

        const filteredSet = new Set(
          filterResult.filtered.map(result => result.test)
        );
        return _objectSpread({}, searchResult, {
          tests: tests.filter(test => filteredSet.has(test.path))
        });
      }

      return searchResult;
    })();
  }
}

exports.default = SearchSource;
