# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.tree_algorithm import TreeAlgorithm


class BoostPrimMinimumSpanningTree(TreeAlgorithm):
    """
    BoostPrimMinimumSpanningTree - Constructs a minimum spanning
       tree from a graph, start node, and the weighting array
    
    Superclass: TreeAlgorithm
    
    This vtk class uses the Boost Prim Minimum Spanning Tree generic
    algorithm to perform a minimum spanning tree creation given a
    weighting value for each of the edges in the input graph and a a
    starting node for the tree. A couple of caveats to be noted with the
    Prim implementation versus the Kruskal implementation:
    1. The negate edge weights function cannot be utilized to obtain a
       'maximal' spanning tree (an exception is thrown when negated edge
       weights exist), and
    2. the Boost implementation of the Prim algorithm returns a vertex
       predecessor map which results in some ambiguity about which edge
       from the original graph should be utilized if parallel edges
       between nodes exist; therefore, the current VTK implementation
       does not copy the edge data from the graph to the new tree.
    
    @sa
    Graph BoostGraphAdapter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkBoostPrimMinimumSpanningTree, obj, update, **traits)
    
    create_graph_vertex_id_array = tvtk_base.false_bool_trait(desc=\
        """
        Stores the graph vertex ids for the tree vertices in an array
        named "_graph_vertex_id".  Default is off.
        """
    )

    def _create_graph_vertex_id_array_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCreateGraphVertexIdArray,
                        self.create_graph_vertex_id_array_)

    negate_edge_weights = tvtk_base.false_bool_trait(desc=\
        """
        Whether to negate the edge weights. By negating the edge weights
        this algorithm will give you the 'maximal' spanning tree (i.e.
        the algorithm will try to create a spanning tree with the highest
        weighted edges). Defaulted to Off. FIXME: put a real definition
        in...
        """
    )

    def _negate_edge_weights_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNegateEdgeWeights,
                        self.negate_edge_weights_)

    def set_edge_weight_array_name(self, *args):
        """
        V.set_edge_weight_array_name(string)
        C++: virtual void SetEdgeWeightArrayName(const char *_arg)
        Set the name of the edge-weight input array, which must name an
        array that is part of the edge data of the input graph and
        contains numeric data. If the edge-weight array is not of type
        DoubleArray, the array will be copied into a temporary
        DoubleArray.
        """
        ret = self._wrap_call(self._vtk_obj.SetEdgeWeightArrayName, *args)
        return ret

    def set_origin_vertex(self, *args):
        """
        V.set_origin_vertex(int)
        C++: void SetOriginVertex(IdType index)
        V.set_origin_vertex(string, Variant)
        C++: void SetOriginVertex(StdString arrayName,
            Variant value)
        Set the index (into the vertex array) of the minimum spanning
        tree 'origin' vertex.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetOriginVertex, *my_args)
        return ret

    _updateable_traits_ = \
    (('create_graph_vertex_id_array', 'GetCreateGraphVertexIdArray'),
    ('negate_edge_weights', 'GetNegateEdgeWeights'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'create_graph_vertex_id_array', 'debug',
    'global_warning_display', 'negate_edge_weights', 'release_data_flag',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(BoostPrimMinimumSpanningTree, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit BoostPrimMinimumSpanningTree properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['create_graph_vertex_id_array', 'negate_edge_weights'], [],
            []),
            title='Edit BoostPrimMinimumSpanningTree properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit BoostPrimMinimumSpanningTree properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

