/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.CC;
import org.jsampler.task.InstrumentsDb;
import org.jsampler.view.std.StdI18n;
import org.linuxsampler.lscp.DbDirectoryInfo;

public class JSDbDirectoryPropsPane
extends JPanel {
    private final JLabel lName = this.createLabel(StdI18n.i18n.getLabel("JSDbDirectoryPropsPane.lName"));
    private final JLabel lType = this.createLabel(StdI18n.i18n.getLabel("JSDbDirectoryPropsPane.lType"));
    private final JLabel lLocation = this.createLabel(StdI18n.i18n.getLabel("JSDbDirectoryPropsPane.lLocation"));
    private final JLabel lContains = this.createLabel(StdI18n.i18n.getLabel("JSDbDirectoryPropsPane.lContains"));
    private final JLabel lCreated = this.createLabel(StdI18n.i18n.getLabel("JSDbDirectoryPropsPane.lCreated"));
    private final JLabel lModified = this.createLabel(StdI18n.i18n.getLabel("JSDbDirectoryPropsPane.lModified"));
    private final JLabel lDesc = this.createLabel(StdI18n.i18n.getLabel("JSDbDirectoryPropsPane.lDesc"));
    private final JTextArea taName = this.createTextArea();
    private final JTextArea taType = this.createTextArea();
    private final JTextArea taLocation = this.createTextArea();
    private final JTextArea taContains = this.createTextArea();
    private final JTextArea taCreated = this.createTextArea();
    private final JTextArea taModified = this.createTextArea();
    private final JTextArea taDesc = this.createTextArea();
    private DbDirectoryInfo directoryInfo;

    public JSDbDirectoryPropsPane(DbDirectoryInfo dbDirectoryInfo) {
        this.setDirectoryInfo(dbDirectoryInfo);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagLayout.setConstraints(this.lName, gridBagConstraints);
        this.add(this.lName);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.lType, gridBagConstraints);
        this.add(this.lType);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.lLocation, gridBagConstraints);
        this.add(this.lLocation);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.lContains, gridBagConstraints);
        this.add(this.lContains);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagLayout.setConstraints(this.lCreated, gridBagConstraints);
        this.add(this.lCreated);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagLayout.setConstraints(this.lModified, gridBagConstraints);
        this.add(this.lModified);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagLayout.setConstraints(this.lDesc, gridBagConstraints);
        this.add(this.lDesc);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.taName, gridBagConstraints);
        this.add(this.taName);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.taType, gridBagConstraints);
        this.add(this.taType);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.taLocation, gridBagConstraints);
        this.add(this.taLocation);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.taContains, gridBagConstraints);
        this.add(this.taContains);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagLayout.setConstraints(this.taCreated, gridBagConstraints);
        this.add(this.taCreated);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagLayout.setConstraints(this.taModified, gridBagConstraints);
        this.add(this.taModified);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagLayout.setConstraints(this.taDesc, gridBagConstraints);
        this.add(this.taDesc);
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        this.add(jSeparator);
        jSeparator = new JSeparator();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        this.add(jSeparator);
        jSeparator = new JSeparator();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        this.add(jSeparator);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        Dimension dimension = this.getPreferredSize();
        int n = dimension.width > 300 ? dimension.width : 300;
        int n2 = dimension.height > 300 ? dimension.height : 300;
        this.setPreferredSize(new Dimension(n, n2));
    }

    public DbDirectoryInfo getDirectoryInfo() {
        return this.directoryInfo;
    }

    public void setDirectoryInfo(DbDirectoryInfo dbDirectoryInfo) {
        this.directoryInfo = dbDirectoryInfo;
        this.taName.setText(dbDirectoryInfo.getName());
        this.taType.setText(StdI18n.i18n.getLabel("JSDbDirectoryPropsPane.folder"));
        this.taLocation.setText(dbDirectoryInfo.getParentDirectoryPath());
        this.taCreated.setText(dbDirectoryInfo.getDateCreated().toString());
        this.taModified.setText(dbDirectoryInfo.getDateModified().toString());
        this.taDesc.setText(dbDirectoryInfo.getDescription());
        this.updateContentInfo();
    }

    private void updateContentInfo() {
        this.taContains.setText(StdI18n.i18n.getLabel("JSDbDirectoryPropsPane.calc"));
        final InstrumentsDb.GetInstrumentCount getInstrumentCount = new InstrumentsDb.GetInstrumentCount(this.directoryInfo.getDirectoryPath(), true);
        final InstrumentsDb.GetDirectoryCount getDirectoryCount = new InstrumentsDb.GetDirectoryCount(this.directoryInfo.getDirectoryPath(), true);
        getInstrumentCount.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (getInstrumentCount.doneWithErrors()) {
                    String string = StdI18n.i18n.getLabel("JSDbDirectoryPropsPane.unknown");
                    JSDbDirectoryPropsPane.this.taContains.setText(string);
                    return;
                }
                CC.getTaskQueue().add(getDirectoryCount);
            }
        });
        getDirectoryCount.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (getDirectoryCount.doneWithErrors()) {
                    String string = StdI18n.i18n.getLabel("JSDbDirectoryPropsPane.unknown");
                    JSDbDirectoryPropsPane.this.taContains.setText(string);
                    return;
                }
                int n = (Integer)getInstrumentCount.getResult();
                int n2 = (Integer)getDirectoryCount.getResult();
                String string = StdI18n.i18n.getLabel("JSDbDirectoryPropsPane.contains", n, n2);
                JSDbDirectoryPropsPane.this.taContains.setText(string);
            }
        });
        CC.getTaskQueue().add(getInstrumentCount);
    }

    protected JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        return jLabel;
    }

    protected JTextArea createTextArea() {
        return new TextArea();
    }

    private class TextArea
    extends JTextArea {
        TextArea() {
            this.setLineWrap(true);
            this.setEditable(false);
            this.setOpaque(false);
            this.putClientProperty("substancelaf.noExtraElements", Boolean.TRUE);
            this.setBorder(BorderFactory.createEmptyBorder());
        }
    }
}

